/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.agent.service.impl;

import com.els.base.certification.agent.dao.AgentMapper;
import com.els.base.certification.agent.entity.Agent;
import com.els.base.certification.agent.entity.AgentExample;
import com.els.base.certification.agent.service.AgentService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultAgentService")
public class AgentServiceImpl
implements AgentService {
    @Resource
    protected AgentMapper agentMapper;

    @Override
    @CacheEvict(value={"agent"}, allEntries=true)
    public void addObj(Agent t) {
        this.agentMapper.insertSelective(t);
    }

    @Override
    @Transactional
    @CacheEvict(value={"agent"}, allEntries=true)
    public void batchInserts(String projectId, Company company, List<Agent> agentList) {
        if (CollectionUtils.isEmpty(agentList)) {
            return;
        }
        AgentExample agentExample = new AgentExample();
        agentExample.createCriteria().andProjectIdEqualTo(projectId).andCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
        Agent agent = new Agent();
        agent.setIsEnable(Constant.NO_INT);
        this.agentMapper.updateByExampleSelective(agent, agentExample);
        agentList.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
            item.setProjectId(projectId);
            item.setCompanyId(company.getId());
            item.setCompanySrmCode(company.getCompanyCode());
            item.setIsEnable(Constant.YES_INT);
            item.setCreateTime(new Date());
        });
        this.agentMapper.insertBatch(agentList);
    }

    @Override
    @Transactional
    @CacheEvict(value={"agent"}, allEntries=true)
    public void addAll(List<Agent> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.agentMapper.insertBatch(list);
    }

    @Override
    @CacheEvict(value={"agent"}, allEntries=true)
    public void deleteObjById(String id) {
        this.agentMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"agent"}, allEntries=true)
    public void deleteByExample(AgentExample example) {
        Assert.isNotNull(example, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), "\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.agentMapper.deleteByExample(example);
    }

    @Override
    @CacheEvict(value={"agent"}, allEntries=true)
    public void modifyObj(Agent t) {
        Assert.isNotBlank(t.getId(), "id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.agentMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"agent"}, keyGenerator="redisKeyGenerator")
    public Agent queryObjById(String id) {
        return this.agentMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"agent"}, keyGenerator="redisKeyGenerator")
    public List<Agent> queryAllObjByExample(AgentExample example) {
        return this.agentMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"agent"}, keyGenerator="redisKeyGenerator")
    public PageView<Agent> queryObjByPage(AgentExample example) {
        PageView<Agent> pageView = example.getPageView();
        pageView.setQueryResult(this.agentMapper.selectByExampleByPage(example));
        return pageView;
    }
}

