/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.agent.web.controller;

import com.els.base.certification.agent.entity.Agent;
import com.els.base.certification.agent.entity.AgentExample;
import com.els.base.certification.agent.service.AgentService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u4f9b\u5e94\u5546\u57fa\u7840\u8d44\u6599-\u4ee3\u7406\u6570\u636e")
@Controller
@RequestMapping(value={"agent"})
public class AgentController {
    @Resource
    protected AgentService agentService;

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u521b\u5efa\u4f9b\u5e94\u5546\u57fa\u7840\u8d44\u6599-\u4ee3\u7406\u6570\u636e")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> batchCreate(@RequestBody List<Agent> agentList) {
        Assert.isNotEmpty(agentList, "\u521b\u5efa\u7684\u6570\u636e\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25");
        agentList.stream().forEach(agent -> {
            Assert.isNotBlank(agent.getManufacturerIntroduce(), "\u5236\u9020\u5546\u7b80\u4ecb\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank(agent.getManufacturerBusinessLicense(), "\u5236\u9020\u5546\u8425\u4e1a\u6267\u7167\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank(agent.getCertificateQuality(), "\u5236\u9020\u5546\u8d28\u91cf\u8bc1\u4e66\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank(agent.getManufacturer3cCertificate(), "\u5236\u9020\u55463C\u8bc1\u4e66\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank(agent.getPerformanceData(), "\u5236\u9020\u5546\u884c\u4e1a\u4e1a\u7ee9\u8d44\u6599\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank(agent.getCreateDeviceList(), "\u751f\u4ea7\u8bbe\u5907\u6e05\u5355\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank(agent.getInspectionEquipmentList(), "\u68c0\u9a8c\u8bbe\u5907\u6e05\u5355\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank(agent.getFinancialInformation(), "\u8d22\u52a1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank(agent.getTestQualificationReport(), "\u4ea7\u54c1\u68c0\u6d4b\u5408\u683c\u62a5\u544a\u4e0d\u80fd\u4e3a\u7a7a");
        });
        this.agentService.batchInserts(ProjectUtils.getProjectId(), CompanyUtils.currentCompany(), agentList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u4f9b\u5e94\u5546\u57fa\u7840\u8d44\u6599-\u4ee3\u7406\u6570\u636e")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody Agent agent) {
        Assert.isNotBlank(agent.getId(), "id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.agentService.modifyObj(agent);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u5220\u9664\u4f9b\u5e94\u5546\u57fa\u7840\u8d44\u6599-\u4ee3\u7406\u6570\u636e")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, "\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        AgentExample example = new AgentExample();
        example.createCriteria().andIdIn((List)ids).andIsEnableEqualTo(Constant.YES_INT).andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        this.agentService.deleteByExample(example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u57fa\u7840\u8d44\u6599-\u4ee3\u7406\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Agent", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<Agent>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        AgentExample example = new AgentExample();
        example.setPageView(new PageView<Agent>(pageNo, pageSize));
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView pageData = this.agentService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5168\u90e8\u4f9b\u5e94\u5546\u57fa\u7840\u8d44\u6599-\u4ee3\u7406\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="companySrmCode", required=false, value="\u4f9b\u5e94\u5546SRM\u7f16\u7801", dataType="String"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Agent", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findAll"})
    @ResponseBody
    public ResponseResult<List<Agent>> findAll(@RequestParam(required=false) String companySrmCode, @RequestBody(required=false) QueryParamWapper wapper) {
        AgentExample example = new AgentExample();
        AgentExample.Criteria criteria = example.createCriteria();
        if (StringUtils.isBlank((String)companySrmCode)) {
            criteria.andIsEnableEqualTo(Constant.YES_INT).andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        } else {
            criteria.andIsEnableEqualTo(Constant.YES_INT).andCompanySrmCodeEqualTo(companySrmCode);
        }
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        List list = this.agentService.queryAllObjByExample(example);
        return ResponseResult.success(list);
    }
}

