/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.apply.service.impl;

import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.RoleExample;
import com.els.base.auth.entity.User;
import com.els.base.auth.entity.UserRole;
import com.els.base.auth.entity.UserRoleExample;
import com.els.base.auth.service.RoleService;
import com.els.base.auth.service.UserRoleService;
import com.els.base.certification.apply.dao.ApplyMapper;
import com.els.base.certification.apply.entity.Apply;
import com.els.base.certification.apply.entity.ApplyExample;
import com.els.base.certification.apply.service.ApplyService;
import com.els.base.certification.apply.util.ApplyUtils;
import com.els.base.certification.apply.util.DocumentStatusEnum;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyPartner;
import com.els.base.company.entity.CompanyPartnerExample;
import com.els.base.company.entity.CompanyUserRef;
import com.els.base.company.entity.CompanyUserRefExample;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.company.utils.PartnerRoleEnum;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.file.entity.FileData;
import com.els.base.workflow.common.entity.ProcessStartVO;
import com.els.base.workflow.common.event.TaskOperateEvent;
import com.els.base.workflow.common.service.ITaskListener;
import com.els.base.workflow.common.service.WorkFlowService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultApplyService")
public class ApplyServiceImpl
implements ApplyService,
ITaskListener {
    @Resource
    protected ApplyMapper applyMapper;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected GenerateCodeService generateCodeService;
    @Resource
    protected RoleService roleService;
    @Resource
    protected CompanyUserRefService companyUserRefService;
    @Resource
    protected UserRoleService userRoleService;
    @Resource
    protected WorkFlowService workFlowService;

    @Override
    @Transactional
    @CacheEvict(value={"apply"}, allEntries=true)
    public void addObj(Apply t) {
        this.applyMapper.insertSelective(t);
    }

    @Override
    @Transactional
    @CacheEvict(value={"apply"}, allEntries=true)
    public void insert(User user, Apply t) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(DocumentStatusEnum.NOT_AUDITED.getCode());
        list.add(DocumentStatusEnum.BEING_AUDITED.getCode());
        list.add(DocumentStatusEnum.AUDITED.getCode());
        ApplyExample example = new ApplyExample();
        ApplyExample.Criteria creiteria = example.createCriteria();
        creiteria.andSupCompanySrmCodeEqualTo(t.getSupCompanySrmCode()).andIsEnableEqualTo(Constant.YES_INT).andStatusIn(list);
        if (this.applyMapper.countByExample(example) > 0) {
            throw new CommonException("\u6b64\u4f9b\u5e94\u5546\u7f16\u7801\u5df2\u6709\u672a\u88ab\u9a73\u56de\u6216\u672a\u4f5c\u5e9f\u7684\u5355\u636e,\u4e0d\u80fd\u518d\u6dfb\u52a0\u4f9b\u5e94\u5546\u7f16\u7801\uff1a " + t.getSupCompanySrmCode());
        }
        Company c = this.companyService.queryCompanyByCode(t.getSupCompanySrmCode());
        t.setId(null);
        t.setProjectId(c.getProjectId());
        t.setSupCompanyId(c.getId());
        t.setSupCompanyName(c.getCompanyFullName());
        t.setStatus(DocumentStatusEnum.NOT_AUDITED.getCode());
        t.setSinglePerson(user.getLoginName() + "+" + user.getNickName());
        t.setDocumentNumber(this.generateCodeService.getNextCode("POTENTIAL_SUPPLIERS_APPLY_NO"));
        this.applyMapper.insertSelective(t);
    }

    @Override
    @Transactional
    @CacheEvict(value={"apply"}, allEntries=true)
    public void deleteObjByIds(List<Apply> supApply) {
        for (Apply apply : supApply) {
            if (apply.getIsInvalid() == Constant.YES_INT) {
                throw new CommonException("\u5355\u636e\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c");
            }
            if (StringUtils.isBlank((String)apply.getId())) {
                throw new CommonException("\u5220\u9664\u5931\u8d25\uff0cid\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (apply.getStatus().equals(DocumentStatusEnum.NOT_AUDITED.getCode())) {
                this.applyMapper.deleteByPrimaryKey(apply.getId());
                continue;
            }
            throw new CommonException("\u5355\u636e\u5df2\u53d1\u9001\u5ba1\u6279\u6216\u5df2\u5ba1\u6279\u6216\u5df2\u9a73\u56de\uff0c\u4e0d\u80fd\u5220\u9664");
        }
    }

    @Override
    @Transactional
    @CacheEvict(value={"apply"}, allEntries=true)
    public void modifyObj(Apply t) {
        Assert.isNotBlank(t.getId(), "\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u7f16\u8f91\u5931\u8d25");
        Apply app = this.applyMapper.selectByPrimaryKey(t.getId());
        if (t.getSupCompanySrmCode().equals(app.getSupCompanySrmCode())) {
            this.applyMapper.updateByPrimaryKeySelective(t);
        } else {
            this.applyMapper.deleteByPrimaryKey(t.getId());
            ArrayList<String> list = new ArrayList<String>();
            list.add(DocumentStatusEnum.NOT_AUDITED.getCode());
            list.add(DocumentStatusEnum.BEING_AUDITED.getCode());
            list.add(DocumentStatusEnum.AUDITED.getCode());
            String[] supCompanyCode = t.getSupCompanySrmCode().split(",");
            for (int i = 0; i < supCompanyCode.length; ++i) {
                Assert.isNotBlank(supCompanyCode[i], "\u4f9b\u5e94\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                t.setSupCompanySrmCode(supCompanyCode[i]);
                ApplyExample example = new ApplyExample();
                example.createCriteria().andSupCompanySrmCodeEqualTo(t.getSupCompanySrmCode()).andIsEnableEqualTo(Constant.YES_INT).andStatusIn(list);
                if (this.applyMapper.countByExample(example) > 0) {
                    throw new CommonException("\u6b64\u4f9b\u5e94\u5546\u7f16\u7801\u5df2\u6709\u672a\u88ab\u9a73\u56de\u6216\u672a\u4f5c\u5e9f\u7684\u5355\u636e\uff0c\u4e0d\u80fd\u518d\u6dfb\u52a0", "base_is_exists", t.getSupCompanySrmCode());
                }
                example.clear();
                Company c = this.companyService.queryCompanyByCode(t.getSupCompanySrmCode());
                t.setId(null);
                t.setProjectId(c.getProjectId());
                t.setSupCompanyId(c.getId());
                t.setSupCompanyName(c.getCompanyFullName());
                t.setStatus(DocumentStatusEnum.NOT_AUDITED.getCode());
                t.setCreateTime(new Date());
                t.setDocumentNumber(this.generateCodeService.getNextCode("POTENTIAL_SUPPLIERS_APPLY_NO"));
                this.applyMapper.insertSelective(t);
            }
        }
    }

    @Override
    @Transactional
    @CacheEvict(value={"apply"}, allEntries=true)
    public void updateIsInvalid(List<Apply> supApply) {
        for (Apply apply : supApply) {
            if (apply.getIsInvalid() == Constant.YES_INT) {
                throw new CommonException("\u5355\u636e\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u80fd\u5728\u8fdb\u884c\u6b64\u64cd\u4f5c");
            }
            if (StringUtils.isBlank((String)apply.getId())) {
                throw new CommonException("id \u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25");
            }
            if (apply.getStatus().equals(DocumentStatusEnum.BEING_AUDITED.getCode())) {
                apply.setIsInvalid(Constant.YES_INT);
                apply.setStatus(DocumentStatusEnum.INVALID.getCode());
                this.applyMapper.updateByPrimaryKeySelective(apply);
                this.workFlowService.stopProcess("qzgysdrfx", apply.getDocumentNumber());
                continue;
            }
            throw new CommonException("\u4f60\u9009\u7684\u5355\u636e\u662f\u65b0\u5efa\u6216\u5df2\u5ba1\u6838\u6216\u5df2\u9a73\u56de\uff0c\u4e0d\u80fd\u4f5c\u5e9f");
        }
    }

    @Override
    @Cacheable(value={"apply"}, keyGenerator="redisKeyGenerator")
    public Apply queryObjById(String id) {
        return this.applyMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"apply"}, keyGenerator="redisKeyGenerator")
    public List<Apply> queryAllObjByExample(ApplyExample example) {
        return this.applyMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"apply"}, keyGenerator="redisKeyGenerator")
    public PageView<Apply> queryObjByPage(ApplyExample example) {
        PageView<Apply> pageView = example.getPageView();
        pageView.setQueryResult(this.applyMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Transactional
    @CacheEvict(value={"apply"}, allEntries=true)
    public void sendToApprove(List<String> ids) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(DocumentStatusEnum.BEING_AUDITED.getCode());
        list.add(DocumentStatusEnum.AUDITED.getCode());
        list.add(DocumentStatusEnum.DISMISSAL.getCode());
        list.add(DocumentStatusEnum.INVALID.getCode());
        ApplyExample applyExample = new ApplyExample();
        applyExample.createCriteria().andIdIn((List)ids).andStatusIn(list);
        if (this.applyMapper.countByExample(applyExample) > 0) {
            throw new CommonException("\u4f60\u53d1\u9001\u7684\u5355\u636e\u5305\u542b\u5df2\u53d1\u9001\u6216\u5df2\u5ba1\u6838\u6216\u5df2\u9a73\u56de\u6216\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u80fd\u53d1\u9001\u5ba1\u6279");
        }
        applyExample.clear();
        applyExample.createCriteria().andIdIn((List)ids);
        List<Apply> applyList = this.applyMapper.selectByExample(applyExample);
        Assert.isNotEmpty(applyList, "\u67e5\u8be2\u7684\u6570\u636e\u4e3a\u7a7a");
        for (Apply apply : applyList) {
            ProcessStartVO vo = ProcessStartVO.newInstance("qzgysdrfx", apply.getDocumentNumber(), apply.getId(), "potentialSupIntroduction?id=" + apply.getId());
            vo.setListenerClass(this.getClass());
            ProcessInstance startProcess = this.workFlowService.startProcess(vo);
            if (startProcess == null) continue;
            Apply app = new Apply();
            app.setStatus(DocumentStatusEnum.BEING_AUDITED.getCode());
            app.setAuditTime(new Date());
            applyExample.clear();
            applyExample.createCriteria().andIdEqualTo(apply.getId());
            this.applyMapper.updateByExampleSelective(app, applyExample);
        }
    }

    @Override
    @Transactional
    @CacheEvict(value={"apply"}, allEntries=true)
    public void updateStatus(String id) {
        Assert.isNotBlank(id, "\u5355\u636eID\u4e3a\u7a7a");
        Apply apply = this.applyMapper.selectByPrimaryKey(id);
        String companyId = apply.getSupCompanyId();
        this.changeRole(companyId);
    }

    private void changeRole(String companyId) {
        CompanyPartnerExample example = new CompanyPartnerExample();
        example.createCriteria().andPartnerCompanyIdEqualTo(companyId);
        CompanyPartner companyPartner = new CompanyPartner();
        companyPartner.setPartnerRoleCode(PartnerRoleEnum.POTENIAL.getCode());
        companyPartner.setPartnerRoleName(PartnerRoleEnum.POTENIAL.getName());
        this.companyService.updatePartnerRole(companyPartner, example);
        RoleExample roleExample = new RoleExample();
        roleExample.createCriteria().andRoleCodeEqualTo(PartnerRoleEnum.POTENIAL.getUserRoleCode());
        List list = this.roleService.queryAllObjByExample((IExample)roleExample);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            CompanyUserRefExample companyUserExample = new CompanyUserRefExample();
            companyUserExample.createCriteria().andCompanyIdEqualTo(companyId);
            List companyUserRef = this.companyUserRefService.queryAllObjByExample(companyUserExample);
            UserRoleExample userRoleExample = new UserRoleExample();
            userRoleExample.createCriteria().andUserIdEqualTo(((CompanyUserRef)companyUserRef.get(0)).getUserId());
            List userRole = this.userRoleService.queryAllObjByExample((IExample)userRoleExample);
            for (UserRole ur : userRole) {
                for (Role role : list) {
                    ur.setRoleId(role.getId());
                    ur.setCreateTime(new Date());
                    this.userRoleService.modifyObj((Serializable)ur);
                }
            }
        }
    }

    @Override
    @Transactional
    @CacheEvict(value={"apply"}, allEntries=true)
    public void deleteObjById(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("\u5220\u9664\u5931\u8d25\uff0cid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.applyMapper.deleteByPrimaryKey(id);
    }

    @Override
    @Transactional
    @CacheEvict(value={"apply"}, allEntries=true)
    public void listen(TaskOperateEvent event) {
        Assert.isNotBlank(event.getBusinessId(), "\u4f9b\u5e94\u5546\u5bfc\u5165\u5206\u6790\u5355\u636eID\u4e3a\u7a7a");
        ApplyExample applyExample = new ApplyExample();
        applyExample.createCriteria().andIdEqualTo(event.getBusinessId());
        Apply apply = this.applyMapper.selectByPrimaryKey(event.getBusinessId());
        if (StringUtils.isBlank((String)apply.getApprovalComments())) {
            apply.setApproveSituation(event.getAssignee());
            if (StringUtils.isEmpty((String)event.getApproveDesc())) {
                apply.setApprovalComments("\u65e0");
            } else {
                apply.setApprovalComments(event.getApproveDesc());
            }
        } else {
            apply.setApproveSituation(apply.getApproveSituation() + "\n" + event.getAssignee());
            if (StringUtils.isEmpty((String)event.getApproveDesc())) {
                apply.setApprovalComments(apply.getApprovalComments() + "\n\u65e0");
            } else {
                apply.setApprovalComments(apply.getApprovalComments() + "\n" + event.getApproveDesc());
            }
        }
        apply.setPendingApprovalPeople(event.getAssignee());
        if (event.isFinished() && event.isPass()) {
            apply.setStatus(DocumentStatusEnum.AUDITED.getCode());
            this.updateStatus(event.getBusinessId());
        } else if (event.isFinished() && !event.isPass()) {
            apply.setStatus(DocumentStatusEnum.DISMISSAL.getCode());
        }
        this.applyMapper.updateByExampleSelective(apply, applyExample);
    }

    @Override
    @CacheEvict(value={"apply"}, allEntries=true)
    public FileData print(String projectId, String companyId, List<Apply> data) {
        Assert.isNotEmpty(data, "\u4f20\u8f93\u7684\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6253\u5370");
        ArrayList<String> ids = null;
        for (Apply a : data) {
            Assert.isNotBlank(a.getId(), "\u4f20\u8f93\u7684\u5355\u636e\u5b58\u5728ID\u4e3a\u7a7a");
            if (ids == null) {
                ids = new ArrayList<String>();
            }
            ids.add(a.getId());
        }
        ApplyExample example = new ApplyExample();
        example.createCriteria().andIdIn(ids);
        List<Apply> applyList = this.applyMapper.selectByExample(example);
        Assert.isNotEmpty(applyList, "\u6839\u636eID\u67e5\u8be2\u7684\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6253\u5370");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("applyList", applyList);
        FileData fileData = null;
        try {
            fileData = ApplyUtils.generatePdf(projectId, companyId, params, "A4");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileData;
    }
}

