/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.apply.web.controller;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.certification.apply.entity.Apply;
import com.els.base.certification.apply.entity.ApplyExample;
import com.els.base.certification.apply.service.ApplyService;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u6f5c\u5728\u4f9b\u5e94\u5546\u8f6c\u5165\u7533\u8bf7\u8868")
@Controller
@RequestMapping(value={"apply"})
public class ApplyController {
    @Resource
    protected ApplyService applyService;
    @Resource
    protected CompanyService companyService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u6f5c\u5728\u4f9b\u5e94\u5546\u8f6c\u5165\u7533\u8bf7\u8868")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody Apply apply) {
        Assert.isNotBlank(apply.getSupCompanySrmCode(), "\u4f9b\u5e94\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String[] companyCode = apply.getSupCompanySrmCode().split(",");
        if (companyCode.length >= 2) {
            throw new CommonException("\u4e00\u6b21\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u4f9b\u5e94\u5546\u7f16\u7801");
        }
        Assert.isNotBlank(apply.getSecondCompanyType1(), "\u4ea7\u54c1\u5927\u7c7b1\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(apply.getSecondCompanyType2(), "\u4ea7\u54c1\u5927\u7c7b2\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(apply.getSecondCompanyType3(), "\u4ea7\u54c1\u5927\u7c7b3\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(apply.getSecondCompanyType4(), "\u4ea7\u54c1\u5927\u7c7b4\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(apply.getSecondCompanyType5(), "\u4ea7\u54c1\u5927\u7c7b5\u4e0d\u80fd\u4e3a\u7a7a");
        User user = SpringSecurityUtils.getLoginUser();
        this.applyService.insert(user, apply);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u6f5c\u5728\u4f9b\u5e94\u5546\u8f6c\u5165\u7533\u8bf7\u8868")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody Apply apply) {
        if (StringUtils.isBlank((String)apply.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        this.applyService.modifyObj(apply);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u6f5c\u5728\u4f9b\u5e94\u5546\u8f6c\u5165\u7533\u8bf7\u8868\u4fe1\u606f")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody List<Apply> supApply) {
        if (CollectionUtils.isEmpty(supApply)) {
            throw new CommonException("\u5220\u9664\u5931\u8d25,\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.applyService.deleteObjByIds(supApply);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f5c\u5e9f\u6f5c\u5728\u4f9b\u5e94\u5546\u8f6c\u5165\u7533\u8bf7\u8868\u4fe1\u606f")
    @RequestMapping(value={"service/invalidDocument"})
    @ResponseBody
    public ResponseResult<String> invalidDocument(@RequestBody List<Apply> supApply) {
        if (CollectionUtils.isEmpty(supApply)) {
            throw new CommonException("\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.applyService.updateIsInvalid(supApply);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u6f5c\u5728\u4f9b\u5e94\u5546\u8f6c\u5165\u7533\u8bf7\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Apply", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<Apply>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        ApplyExample example = new ApplyExample();
        example.setPageView(new PageView<Apply>(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        ApplyExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        PageView pageData = this.applyService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636eID\u67e5\u770b\u6f5c\u5728\u4f9b\u5e94\u5546\u5bfc\u5165\u5206\u6790\u8868\u5355\u636e\u8be6\u60c5")
    @RequestMapping(value={"service/findDetailById"})
    @ResponseBody
    public ResponseResult<Apply> findDetailById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "\u5355\u636e\u7684ID\u4e0d\u80fd\u4e3a\u7a7a");
        Apply apply = (Apply)this.applyService.queryObjById(id);
        return ResponseResult.success(apply);
    }

    @ApiOperation(httpMethod="POST", value="\u53d1\u9001\u5ba1\u6279")
    @RequestMapping(value={"service/sendApproval"})
    @ResponseBody
    public ResponseResult<String> sendApproal(@RequestBody List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u53d1\u9001\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.applyService.sendToApprove(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6f5c\u5728\u4f9b\u5e94\u5546\u5bfc\u5165\u5206\u6790\u8868\u6253\u5370")
    @RequestMapping(value={"service/print"})
    @ResponseBody
    public ResponseResult<FileData> print(@RequestBody(required=true) List<Apply> data) {
        Assert.isNotEmpty(data, "\u4f20\u8f93\u7684\u6570\u636e\u4e3a\u7a7a");
        FileData fileData = this.applyService.print(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), data);
        return ResponseResult.success(fileData);
    }
}

