/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.auth.service.impl;

import com.els.base.certification.auth.dao.CompanyAuthMapper;
import com.els.base.certification.auth.entity.CompanyAuth;
import com.els.base.certification.auth.entity.CompanyAuthExample;
import com.els.base.certification.auth.service.CompanyAuthService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultCompanyAuthService")
public class CompanyAuthServiceImpl
implements CompanyAuthService {
    @Resource
    private CompanyAuthMapper companyAuthMapper;

    @Override
    @Cacheable(value={"companyAuth"}, keyGenerator="redisKeyGenerator")
    public Integer isFinish(Project project, Company company) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(Constant.NO_INT);
        CompanyAuthExample companyAuthExample = new CompanyAuthExample();
        companyAuthExample.createCriteria().andProjectIdEqualTo(project.getId()).andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
        int count = this.companyAuthMapper.countByExample(companyAuthExample);
        if (count <= 0) {
            return 0;
        }
        companyAuthExample.clear();
        companyAuthExample.createCriteria().andProjectIdEqualTo(project.getId()).andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT).andFinishFlagIn(list);
        int finishCount = this.companyAuthMapper.countByExample(companyAuthExample);
        if (finishCount > 0) {
            return 0;
        }
        return 1;
    }

    @Override
    @CacheEvict(value={"companyAuth"}, allEntries=true)
    public void deleteObjByIds(String projectId, Company company, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e");
        }
        CompanyAuthExample companyAuthExample = new CompanyAuthExample();
        companyAuthExample.createCriteria().andProjectIdEqualTo(projectId).andSupCompanyIdEqualTo(company.getId()).andIdIn((List)ids);
        CompanyAuth companyAuth = new CompanyAuth();
        companyAuth.setIsEnable(Constant.NO_INT);
        this.companyAuthMapper.updateByExampleSelective(companyAuth, companyAuthExample);
    }

    @Override
    @CacheEvict(value={"companyAuth"}, allEntries=true)
    public Integer batchInsert(String projectId, Company company, List<CompanyAuth> companyAuthList) {
        if (CollectionUtils.isEmpty(companyAuthList)) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e");
        }
        CompanyAuthExample companyAuthExample = new CompanyAuthExample();
        companyAuthExample.createCriteria().andProjectIdEqualTo(projectId).andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
        CompanyAuth companyAuth = new CompanyAuth();
        companyAuth.setIsEnable(Constant.NO_INT);
        ArrayList<Integer> list = new ArrayList<Integer>();
        this.companyAuthMapper.updateByExampleSelective(companyAuth, companyAuthExample);
        for (CompanyAuth auth : companyAuthList) {
            Assert.isNotBlank(auth.getCertificateTypeCode(), "\u6709\u8bc1\u4e66\u540d\u79f0\u4e3a\u7a7a\uff0c\u8bf7\u6b63\u786e\u9009\u62e9\u8981\u586b\u5199\u7684\u8bc1\u4e66\u540d\u79f0");
            Assert.isNotNull(auth.getEndTime(), "\u6709\u8bc1\u4e66\u7684\u6709\u6548\u65e5\u671f\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u8bc1\u4e66\u7684\u6709\u6548\u65e5\u671f");
            if (StringUtils.isBlank((String)auth.getCertificateFile()) || "[]".equals(auth.getCertificateFile())) {
                throw new CommonException("\u6709\u8bc1\u4e66\u6ca1\u6709\u4e0a\u4f20\u6587\u4ef6\uff0c\u8bf7\u4e0a\u4f20\u4e4b\u540e\u518d\u4fdd\u5b58");
            }
            auth.setId(null);
            auth.setProjectId(projectId);
            auth.setSupCompanyId(company.getId());
            auth.setIsEnable(Constant.YES_INT);
            auth.setUpdateTime(new Date());
            if (auth.getCreateTime() == null) {
                auth.setCreateTime(new Date());
            }
            Integer finishFlag = auth.getFinishFlag();
            auth.setFinishFlag(finishFlag);
            this.companyAuthMapper.insertSelective(auth);
            list.add(finishFlag);
        }
        if (list.contains(Constant.NO_INT)) {
            return 0;
        }
        return 1;
    }

    @Override
    @CacheEvict(value={"companyAuth"}, allEntries=true)
    public void addObj(CompanyAuth t) {
        this.companyAuthMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"companyAuth"}, allEntries=true)
    public void deleteObjById(String id) {
        this.companyAuthMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"companyAuth"}, allEntries=true)
    public void modifyObj(CompanyAuth t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.companyAuthMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"companyAuth"}, keyGenerator="redisKeyGenerator")
    public CompanyAuth queryObjById(String id) {
        return this.companyAuthMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"companyAuth"}, keyGenerator="redisKeyGenerator")
    public List<CompanyAuth> queryAllObjByExample(CompanyAuthExample example) {
        return this.companyAuthMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"companyAuth"}, keyGenerator="redisKeyGenerator")
    public PageView<CompanyAuth> queryObjByPage(CompanyAuthExample example) {
        PageView<CompanyAuth> pageView = example.getPageView();
        pageView.setQueryResult(this.companyAuthMapper.selectByExampleByPage(example));
        return pageView;
    }
}

