/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.business.service.impl;

import com.els.base.certification.business.dao.BusinessMapper;
import com.els.base.certification.business.entity.Business;
import com.els.base.certification.business.entity.BusinessExample;
import com.els.base.certification.business.service.BusinessService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultBusinessService")
public class BusinessServiceImpl
implements BusinessService {
    @Resource
    protected BusinessMapper businessMapper;

    @Override
    @CacheEvict(value={"business"}, allEntries=true)
    public void insertObj(Company company, List<Business> businessList) {
        Assert.isNotEmpty(businessList, "\u65b0\u5efa\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        BusinessExample example = new BusinessExample();
        example.createCriteria().andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
        Business business = new Business();
        business.setIsEnable(Constant.NO_INT);
        this.businessMapper.updateByExampleSelective(business, example);
        businessList.forEach(busin -> {
            busin.setSupCompanyId(company.getId());
            busin.setIsEnable(Constant.YES_INT);
            busin.setCreateTime(new Date());
            busin.setUpdateTime(new Date());
            this.businessMapper.insertSelective((Business)busin);
        });
    }

    @Override
    @CacheEvict(value={"business"}, allEntries=true)
    public void deleteObjByIds(String companyId, List<String> ids) {
        Assert.isNotEmpty(ids, "\u4f20\u5165\u7684\u6570\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
        BusinessExample example = new BusinessExample();
        example.createCriteria().andSupCompanyIdEqualTo(companyId).andIsEnableEqualTo(Constant.YES_INT).andIdIn((List)ids);
        Business business = new Business();
        business.setIsEnable(Constant.NO_INT);
        this.businessMapper.updateByExampleSelective(business, example);
    }

    @Override
    @CacheEvict(value={"business"}, allEntries=true)
    public void addObj(Business t) {
        this.businessMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"business"}, allEntries=true)
    public void deleteObjById(String id) {
        this.businessMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"business"}, allEntries=true)
    public void modifyObj(Business t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.businessMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"business"}, keyGenerator="redisKeyGenerator")
    public Business queryObjById(String id) {
        return this.businessMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"business"}, keyGenerator="redisKeyGenerator")
    public List<Business> queryAllObjByExample(BusinessExample example) {
        return this.businessMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"business"}, keyGenerator="redisKeyGenerator")
    public PageView<Business> queryObjByPage(BusinessExample example) {
        PageView<Business> pageView = example.getPageView();
        pageView.setQueryResult(this.businessMapper.selectByExampleByPage(example));
        return pageView;
    }
}

