/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.business.web.controller;

import com.els.base.certification.business.entity.Business;
import com.els.base.certification.business.entity.BusinessExample;
import com.els.base.certification.business.service.BusinessService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u4f9b\u5e94\u5546\u51c6\u5165\u57fa\u7840\u8d44\u6599-\u4f9b\u5e94\u5546\u7ecf\u8425\u4ea7\u54c1")
@Controller
@RequestMapping(value={"business"})
public class BusinessController {
    @Resource
    protected BusinessService businessService;

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u521b\u5efa\u4f9b\u5e94\u5546\u51c6\u5165\u57fa\u7840\u8d44\u6599-\u4f9b\u5e94\u5546\u7ecf\u8425\u4ea7\u54c1")
    @RequestMapping(value={"service/insert"})
    @ResponseBody
    public ResponseResult<String> insert(@RequestBody List<Business> businessList) {
        Assert.isNotEmpty(businessList, "\u4f20\u5165\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        this.businessService.insertObj(CompanyUtils.currentCompany(), businessList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u5220\u9664\u4f9b\u5e94\u5546\u51c6\u5165\u57fa\u7840\u8d44\u6599-\u4f9b\u5e94\u5546\u7ecf\u8425\u4ea7\u54c1")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestParam(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, "\u6570\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
        this.businessService.deleteObjByIds(CompanyUtils.currentCompanyId(), ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u51c6\u5165\u57fa\u7840\u8d44\u6599-\u4f9b\u5e94\u5546\u7ecf\u8425\u4ea7\u54c1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Business", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<Business>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        BusinessExample example = new BusinessExample();
        example.setPageView(new PageView<Business>(pageNo, pageSize));
        BusinessExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView pageData = this.businessService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}

