/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.certificate.util;

import com.els.base.certification.agent.entity.Agent;
import com.els.base.certification.agent.entity.AgentExample;
import com.els.base.certification.agent.service.AgentService;
import com.els.base.certification.auth.entity.CompanyAuth;
import com.els.base.certification.auth.entity.CompanyAuthExample;
import com.els.base.certification.auth.service.CompanyAuthService;
import com.els.base.certification.certificate.entity.CertificateExpiry;
import com.els.base.certification.certificate.entity.CertificateExpiryExample;
import com.els.base.certification.certificate.service.CertificateExpiryService;
import com.els.base.certification.common.CertificateTypeCodeEnum;
import com.els.base.certification.patents.entity.CompanyPatents;
import com.els.base.certification.patents.entity.CompanyPatentsExample;
import com.els.base.certification.patents.service.CompanyPatentsService;
import com.els.base.certification.remind.entity.RemindInfo;
import com.els.base.certification.remind.entity.RemindInfoExample;
import com.els.base.certification.remind.service.RemindInfoService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.core.utils.Constant;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class ExpirationRemindingJob {
    @Resource
    private CertificateExpiryService certificateExpiryService;
    @Resource
    private CompanyAuthService companyAuthService;
    @Resource
    private CompanyService companyService;
    @Resource
    private RemindInfoService remindInfoService;
    @Resource
    private CompanyPatentsService companyPatentsService;
    @Resource
    private AgentService agentService;

    public void remindInformation() throws ParseException {
        RemindInfoExample remindInfoExample = new RemindInfoExample();
        remindInfoExample.createCriteria().andIsEnableEqualTo(Constant.YES_INT);
        this.remindInfoService.deleteByExample(remindInfoExample);
        CertificateExpiryExample example = new CertificateExpiryExample();
        example.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andIsEnableRemindersEqualTo(Constant.YES_INT);
        List certificateList = this.certificateExpiryService.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(certificateList)) {
            return;
        }
        for (CertificateExpiry certificate : certificateList) {
            AgentExample agentExample;
            List list;
            if (certificate.getClassificationName().equals(CertificateTypeCodeEnum.PATENT.getCode())) {
                CompanyPatentsExample patentsExample = new CompanyPatentsExample();
                patentsExample.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andEndTimeIsNotNull();
                list = this.companyPatentsService.queryAllObjByExample(patentsExample);
                if (CollectionUtils.isEmpty(list)) continue;
                for (CompanyPatents companyPatents : list) {
                    this.insertToRemindInfo(companyPatents.getEndTime(), companyPatents.getSupCompanyId(), CertificateTypeCodeEnum.PATENT.getCode(), CertificateTypeCodeEnum.PATENT.getDesc(), certificate.getAdvanceReminderDays());
                }
                continue;
            }
            if (CertificateTypeCodeEnum.AGENT.getCode().equals(certificate.getClassificationName())) {
                agentExample = new AgentExample();
                agentExample.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andAgentTimeIsNotNull();
                list = this.agentService.queryAllObjByExample(agentExample);
                if (CollectionUtils.isEmpty(list)) continue;
                for (Agent agent : list) {
                    this.insertToRemindInfo(agent.getAgentTime(), agent.getCompanyId(), CertificateTypeCodeEnum.AGENT.getCode(), CertificateTypeCodeEnum.AGENT.getDesc(), certificate.getAdvanceReminderDays());
                }
                continue;
            }
            if (CertificateTypeCodeEnum.QUALITY.getCode().equals(certificate.getClassificationName())) {
                agentExample = new AgentExample();
                agentExample.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andQualityCertificateTimeIsNotNull();
                list = this.agentService.queryAllObjByExample(agentExample);
                if (CollectionUtils.isEmpty(list)) continue;
                for (Agent agent : list) {
                    this.insertToRemindInfo(agent.getQualityCertificateTime(), agent.getCompanyId(), CertificateTypeCodeEnum.QUALITY.getCode(), CertificateTypeCodeEnum.QUALITY.getDesc(), certificate.getAdvanceReminderDays());
                }
                continue;
            }
            CompanyAuthExample authExample = new CompanyAuthExample();
            authExample.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andCertificateTypeCodeEqualTo(certificate.getClassificationName()).andEndTimeIsNotNull();
            List authList = this.companyAuthService.queryAllObjByExample(authExample);
            if (CollectionUtils.isEmpty(authList)) continue;
            for (CompanyAuth auth : authList) {
                String name = CertificateTypeCodeEnum.getDesc(auth.getCertificateTypeCode());
                this.insertToRemindInfo(auth.getEndTime(), auth.getSupCompanyId(), auth.getCertificateTypeCode(), name, certificate.getAdvanceReminderDays());
            }
        }
    }

    private void insertToRemindInfo(Date endTime, String supCompanyId, String code, String name, Integer advanceReminderDays) throws ParseException {
        long reminderTime;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String newDate = formatter.format(new Date());
        String endDate = formatter.format(endTime);
        long nowDateTime = formatter.parse(newDate).getTime();
        long endDateTime = formatter.parse(endDate).getTime();
        if (endDateTime - nowDateTime <= (reminderTime = (long)(advanceReminderDays * 24 * 60 * 60 * 1000))) {
            Company company = (Company)this.companyService.queryObjById(supCompanyId);
            if (company == null) {
                return;
            }
            RemindInfo remindInfo = new RemindInfo();
            remindInfo.setSupCompanyId(company.getId());
            remindInfo.setSupCompanyName(company.getCompanyFullName());
            remindInfo.setSupCompanySrmCode(company.getCompanyCode());
            remindInfo.setCertificateTypeCode(code);
            remindInfo.setCertificateName(name);
            remindInfo.setEndTime(endTime);
            remindInfo.setIsEnable(Constant.YES_INT);
            remindInfo.setCreateTime(new Date());
            remindInfo.setStatus(Constant.NO_INT);
            this.remindInfoService.addObj(remindInfo);
        }
    }
}

