/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.common;

import org.apache.commons.lang3.StringUtils;

public enum CertificateTypeCodeEnum {
    IOS9001("ios9001", "ISO9001\u4f53\u7cfb\u8bc1\u4e66"),
    IATF16949("iatf16949", "IATF16949\u4f53\u7cfb\u8bc1\u4e66"),
    IOS14000("ios14000", "ISO14000\u8bc1\u4e66"),
    LICENSE("license", "\u8425\u4e1a\u6267\u7167/\u767b\u8bb0\u8bc1\u4e66"),
    PROXY_CARD("proxyCard", "\u4ee3\u7406\u8bc1/\u6388\u6743\u4e66"),
    CERTIFICATE_15085("15085", "15085\u8bc1\u4e66"),
    ISOTS_22163("iso22163", "ISO/TS 22163\u8bc1\u4e66"),
    OTHER("other", "\u5176\u5b83\u8bc1\u4e66"),
    PATENT("patent", "\u4e13\u5229/\u8bb8\u53ef"),
    AGENT("agent", "\u4ee3\u7406\u8bc1\u4e66"),
    QUALITY("quality", "\u751f\u4ea7\u5546\u8d28\u91cf\u8bc1\u4e66");

    private String code;
    private String desc;

    private CertificateTypeCodeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static String getDesc(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        switch (code) {
            case "ios9001": {
                return IOS9001.getDesc();
            }
            case "iatf16949": {
                return IATF16949.getDesc();
            }
            case "ios14000": {
                return IOS14000.getDesc();
            }
            case "license": {
                return LICENSE.getDesc();
            }
            case "proxyCard": {
                return PROXY_CARD.getDesc();
            }
            case "15085": {
                return CERTIFICATE_15085.getDesc();
            }
            case "iso22163": {
                return ISOTS_22163.getDesc();
            }
            case "other": {
                return OTHER.getDesc();
            }
            case "patent": {
                return PATENT.getDesc();
            }
            case "agent": {
                return AGENT.getDesc();
            }
            case "quality": {
                return QUALITY.getDesc();
            }
        }
        return null;
    }
}

