/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.contacts.service.impl;

import com.els.base.certification.contacts.dao.ContactsMapper;
import com.els.base.certification.contacts.entity.Contacts;
import com.els.base.certification.contacts.entity.ContactsExample;
import com.els.base.certification.contacts.service.ContactsService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultContactsService")
public class ContactsServiceImpl
implements ContactsService {
    @Resource
    protected ContactsMapper contactsMapper;
    @Resource
    private CompanyService companyService;

    @Override
    @Cacheable(value={"contacts"}, keyGenerator="redisKeyGenerator")
    public Integer isFinish(Project project, Company company) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(Constant.NO_INT);
        ContactsExample contactsExample = new ContactsExample();
        contactsExample.createCriteria().andProjectIdEqualTo(project.getId()).andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
        int count = this.contactsMapper.countByExample(contactsExample);
        if (count <= 0) {
            return 0;
        }
        contactsExample.clear();
        contactsExample.createCriteria().andProjectIdEqualTo(project.getId()).andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT).andFinishFlagIn(list);
        int finishCount = this.contactsMapper.countByExample(contactsExample);
        if (finishCount > 0) {
            return 0;
        }
        return 1;
    }

    @Override
    @Transactional
    @CacheEvict(value={"contacts"}, allEntries=true)
    public Integer addContacts(String projectId, String companyId, List<Contacts> contactsList) {
        if (CollectionUtils.isEmpty(contactsList)) {
            throw new CommonException("\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ContactsExample example = new ContactsExample();
        example.createCriteria().andProjectIdEqualTo(projectId).andSupCompanyIdEqualTo(companyId);
        this.contactsMapper.deleteByExample(example);
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Contacts contacts : contactsList) {
            contacts.setId(null);
            contacts.setProjectId(projectId);
            contacts.setSupCompanyId(companyId);
            contacts.setCreateTime(new Date());
            Integer finishFlag = contacts.getFinishFlag();
            contacts.setFinishFlag(finishFlag);
            this.contactsMapper.insertSelective(contacts);
            list.add(finishFlag);
        }
        if (list.contains(Constant.NO_INT)) {
            return 0;
        }
        return 1;
    }

    @Override
    @CacheEvict(value={"contacts"}, allEntries=true)
    public void deleteObjByIds(List<String> ids) {
        ContactsExample example = new ContactsExample();
        example.createCriteria().andIdIn((List)ids);
        this.contactsMapper.deleteByExample(example);
    }

    @Override
    @Transactional
    @CacheEvict(value={"contacts"}, allEntries=true)
    public void modifyObj(Contacts t) {
        t.setSupCompanyId(null);
        t.setProjectId(null);
        t.setIsEnable(null);
        this.contactsMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"contacts"}, keyGenerator="redisKeyGenerator")
    public Contacts queryObjById(String id) {
        return this.contactsMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"contacts"}, keyGenerator="redisKeyGenerator")
    public List<Contacts> queryAllObjByExample(ContactsExample example) {
        return this.contactsMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"contacts"}, keyGenerator="redisKeyGenerator")
    public PageView<Contacts> queryObjByPage(ContactsExample example) {
        PageView<Contacts> pageView = example.getPageView();
        pageView.setQueryResult(this.contactsMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public List<Contacts> queryAllContacts(String companyId) {
        if (StringUtils.isBlank((String)companyId)) {
            throw new CommonException("\u516c\u53f8ID\u4e3a\u7a7a");
        }
        ContactsExample example = new ContactsExample();
        ContactsExample.Criteria criteria = example.createCriteria();
        criteria.andSupCompanyIdEqualTo(companyId);
        List<Contacts> contacts = this.contactsMapper.selectByExample(example);
        return contacts;
    }

    @Override
    public void deleteObjById(String id) {
        this.contactsMapper.deleteByPrimaryKey(id);
    }

    @Override
    public void addObj(Contacts t) {
        this.contactsMapper.insertSelective(t);
    }
}

