/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.exempt.service.impl;

import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.RoleExample;
import com.els.base.auth.entity.User;
import com.els.base.auth.entity.UserRole;
import com.els.base.auth.entity.UserRoleExample;
import com.els.base.auth.service.RoleService;
import com.els.base.auth.service.UserRoleService;
import com.els.base.certification.apply.util.DocumentStatusEnum;
import com.els.base.certification.exempt.dao.ExemptMapper;
import com.els.base.certification.exempt.entity.Exempt;
import com.els.base.certification.exempt.entity.ExemptExample;
import com.els.base.certification.exempt.service.ExemptService;
import com.els.base.certification.exempt.utils.ExemptUtils;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyPartner;
import com.els.base.company.entity.CompanyPartnerExample;
import com.els.base.company.entity.CompanyUserRef;
import com.els.base.company.entity.CompanyUserRefExample;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.company.utils.PartnerRoleEnum;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.file.entity.FileData;
import com.els.base.workflow.common.entity.ProcessStartVO;
import com.els.base.workflow.common.event.TaskOperateEvent;
import com.els.base.workflow.common.service.ITaskListener;
import com.els.base.workflow.common.service.WorkFlowService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultExemptService")
public class ExemptServiceImpl
implements ExemptService,
ITaskListener {
    @Resource
    protected ExemptMapper exemptMapper;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected GenerateCodeService generateCodeService;
    @Resource
    protected RoleService roleService;
    @Resource
    protected CompanyUserRefService companyUserRefService;
    @Resource
    protected UserRoleService userRoleService;
    @Resource
    private WorkFlowService workFlowService;

    @Override
    @Transactional
    @CacheEvict(value={"exempt"}, allEntries=true)
    public void addObj(Exempt t) {
        this.exemptMapper.insertSelective(t);
    }

    @Override
    @Transactional
    @CacheEvict(value={"exempt"}, allEntries=true)
    public void insert(User user, Exempt t) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(DocumentStatusEnum.NOT_AUDITED.getCode());
        list.add(DocumentStatusEnum.BEING_AUDITED.getCode());
        list.add(DocumentStatusEnum.AUDITED.getCode());
        ExemptExample example = new ExemptExample();
        ExemptExample.Criteria criteria = example.createCriteria();
        criteria.andSupCompanySrmCodeEqualTo(t.getSupCompanySrmCode()).andIsEnableEqualTo(Constant.YES_INT).andStatusIn(list);
        if (this.exemptMapper.countByExample(example) > 0) {
            throw new CommonException("\u6b64\u4f9b\u5e94\u5546\u7f16\u7801\u5df2\u6709\u672a\u88ab\u9a73\u56de\u6216\u672a\u4f5c\u5e9f\u7684\u5355\u636e,\u4e0d\u80fd\u518d\u6dfb\u52a0 " + t.getSupCompanySrmCode());
        }
        String companyCode = t.getSupCompanySrmCode();
        Company c = this.companyService.queryCompanyByCode(companyCode);
        t.setId(null);
        t.setProjectId(c.getProjectId());
        t.setSupCompanyId(c.getId());
        t.setSinglePerson(user.getLoginName() + "+" + user.getNickName());
        t.setDocumentNumber(this.generateCodeService.getNextCode("SUPPLIER_EXEMPTION_NO"));
        this.exemptMapper.insertSelective(t);
    }

    @Override
    @Transactional
    @CacheEvict(value={"exempt"}, allEntries=true)
    public void deleteObjByIds(List<Exempt> supExempt) {
        for (Exempt exempt : supExempt) {
            if (exempt.getIsInvalid() == Constant.YES_INT) {
                throw new CommonException("\u5355\u636e\u4f5c\u5e9f\uff0c\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c");
            }
            if (StringUtils.isBlank((String)exempt.getId())) {
                throw new CommonException("\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (exempt.getStatus().equals(DocumentStatusEnum.NOT_AUDITED.getCode())) {
                this.exemptMapper.deleteByPrimaryKey(exempt.getId());
                continue;
            }
            throw new CommonException("\u5355\u636e\u5df2\u53d1\u9001\u5ba1\u6279\u6216\u5df2\u5ba1\u6279\u6216\u5df2\u9a73\u56de\uff0c\u4e0d\u80fd\u5220\u9664");
        }
    }

    @Override
    @Transactional
    @CacheEvict(value={"exempt"}, allEntries=true)
    public void updateIsInvalid(List<Exempt> supExempt) {
        for (Exempt exempt : supExempt) {
            if (exempt.getIsInvalid() == Constant.YES_INT) {
                throw new CommonException("\u5355\u636e\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c");
            }
            if (StringUtils.isBlank((String)exempt.getId())) {
                throw new CommonException("id \u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25");
            }
            if (exempt.getStatus().equals(DocumentStatusEnum.BEING_AUDITED.getCode())) {
                exempt.setIsInvalid(Constant.YES_INT);
                exempt.setStatus(DocumentStatusEnum.INVALID.getCode());
                this.exemptMapper.updateByPrimaryKeySelective(exempt);
                this.workFlowService.stopProcess("gyshmd", exempt.getDocumentNumber());
                continue;
            }
            throw new CommonException("\u4f60\u9009\u7684\u5355\u636e\u662f\u65b0\u5efa\u6216\u5df2\u5ba1\u6838\u6216\u5df2\u9a73\u56de\uff0c\u4e0d\u80fd\u4f5c\u5e9f");
        }
    }

    @Override
    @CacheEvict(value={"exempt"}, allEntries=true)
    public void modifyObj(Exempt t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        Exempt exempt = this.exemptMapper.selectByPrimaryKey(t.getId());
        if (t.getSupCompanySrmCode().equals(exempt.getSupCompanySrmCode())) {
            this.exemptMapper.updateByPrimaryKeySelective(t);
        } else {
            ArrayList<String> list = new ArrayList<String>();
            list.add(DocumentStatusEnum.NOT_AUDITED.getCode());
            list.add(DocumentStatusEnum.BEING_AUDITED.getCode());
            list.add(DocumentStatusEnum.AUDITED.getCode());
            ExemptExample exemptExample = new ExemptExample();
            exemptExample.createCriteria().andSupCompanySrmCodeEqualTo(t.getSupCompanySrmCode()).andIsEnableEqualTo(Constant.YES_INT).andStatusIn(list);
            if (this.exemptMapper.countByExample(exemptExample) > 0) {
                throw new CommonException("\u6b64\u4f9b\u5e94\u5546\u7f16\u7801\u5df2\u6709\u672a\u88ab\u9a73\u56de\u6216\u672a\u4f5c\u5e9f\u7684\u5355\u636e\uff0c\u4e0d\u80fd\u518d\u6dfb\u52a0");
            }
            Company supCompany = this.companyService.queryCompanyByCode(t.getSupCompanySrmCode());
            t.setSupCompanyId(supCompany.getId());
            this.exemptMapper.updateByPrimaryKeySelective(t);
        }
    }

    @Override
    @Cacheable(value={"exempt"}, keyGenerator="redisKeyGenerator")
    public Exempt queryObjById(String id) {
        return this.exemptMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"exempt"}, keyGenerator="redisKeyGenerator")
    public List<Exempt> queryAllObjByExample(ExemptExample example) {
        return this.exemptMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"exempt"}, keyGenerator="redisKeyGenerator")
    public PageView<Exempt> queryObjByPage(ExemptExample example) {
        PageView<Exempt> pageView = example.getPageView();
        pageView.setQueryResult(this.exemptMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Transactional
    @CacheEvict(value={"exempt"}, allEntries=true)
    public void sendToApprove(List<String> ids) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(DocumentStatusEnum.BEING_AUDITED.getCode());
        list.add(DocumentStatusEnum.AUDITED.getCode());
        list.add(DocumentStatusEnum.DISMISSAL.getCode());
        list.add(DocumentStatusEnum.INVALID.getCode());
        ExemptExample example = new ExemptExample();
        example.createCriteria().andIdIn((List)ids).andStatusIn(list);
        if (this.exemptMapper.countByExample(example) > 0) {
            throw new CommonException("\u4f60\u53d1\u9001\u7684\u5355\u636e\u5305\u542b\u5df2\u53d1\u9001\u5ba1\u6279\u6216\u5df2\u5ba1\u6838\u6216\u5df2\u9a73\u56de\u6216\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u80fd\u53d1\u9001\u5ba1\u6279");
        }
        example.clear();
        example.createCriteria().andIdIn((List)ids);
        List<Exempt> exemptList = this.exemptMapper.selectByExample(example);
        Assert.isNotEmpty(exemptList, "\u67e5\u8be2\u7684\u6570\u636e\u4e3a\u7a7a");
        for (Exempt exempt : exemptList) {
            ProcessStartVO vo = ProcessStartVO.newInstance("gyshmd", exempt.getDocumentNumber(), exempt.getId(), "supExemptionBill?id=" + exempt.getId());
            vo.setListenerClass(this.getClass());
            ProcessInstance startProcess = this.workFlowService.startProcess(vo);
            if (startProcess == null) continue;
            Exempt e = new Exempt();
            e.setStatus(DocumentStatusEnum.BEING_AUDITED.getCode());
            e.setAuditTime(new Date());
            example.clear();
            example.createCriteria().andIdEqualTo(exempt.getId());
            this.exemptMapper.updateByExampleSelective(e, example);
        }
    }

    @Override
    @Transactional
    @CacheEvict(value={"exempt"}, allEntries=true)
    public void updateStatus(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("\u8c41\u514d\u5355\u636eID\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25");
        }
        Exempt exempt = this.exemptMapper.selectByPrimaryKey(id);
        String companyId = exempt.getSupCompanyId();
        CompanyPartnerExample example = new CompanyPartnerExample();
        example.createCriteria().andPartnerCompanyIdEqualTo(companyId);
        CompanyPartner companyPartner = new CompanyPartner();
        companyPartner.setPartnerRoleCode(PartnerRoleEnum.QUALIFIED.getCode());
        companyPartner.setPartnerRoleName(PartnerRoleEnum.QUALIFIED.getName());
        this.companyService.updatePartnerRole(companyPartner, example);
        RoleExample roleExample = new RoleExample();
        roleExample.createCriteria().andRoleCodeEqualTo(PartnerRoleEnum.QUALIFIED.getUserRoleCode());
        List list = this.roleService.queryAllObjByExample((IExample)roleExample);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            CompanyUserRefExample companyUserExample = new CompanyUserRefExample();
            companyUserExample.createCriteria().andCompanyIdEqualTo(companyId);
            List companyUserRef = this.companyUserRefService.queryAllObjByExample(companyUserExample);
            UserRoleExample userRoleExample = new UserRoleExample();
            userRoleExample.createCriteria().andUserIdEqualTo(((CompanyUserRef)companyUserRef.get(0)).getUserId());
            List userRole = this.userRoleService.queryAllObjByExample((IExample)userRoleExample);
            for (UserRole ur : userRole) {
                for (Role role : list) {
                    ur.setRoleId(role.getId());
                    ur.setCreateTime(new Date());
                    this.userRoleService.modifyObj((Serializable)ur);
                }
            }
        }
    }

    @Override
    @Transactional
    @CacheEvict(value={"exempt"}, allEntries=true)
    public void deleteObjById(String id) {
        this.exemptMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"exempt"}, allEntries=true)
    public void listen(TaskOperateEvent event) {
        ExemptExample exemptExample = new ExemptExample();
        exemptExample.createCriteria().andIdEqualTo(event.getBusinessId());
        Exempt e = this.exemptMapper.selectByPrimaryKey(event.getBusinessId());
        e.setAuditTime(new Date());
        e.setPendingApprovalPeople(event.getAssignee());
        if (event.isFinished() && event.isPass()) {
            e.setStatus(DocumentStatusEnum.AUDITED.getCode());
            this.updateStatus(event.getBusinessId());
        } else if (event.isFinished() && !event.isPass()) {
            e.setStatus(DocumentStatusEnum.DISMISSAL.getCode());
        }
        this.exemptMapper.updateByExampleSelective(e, exemptExample);
    }

    @Override
    @CacheEvict(value={"exempt"}, allEntries=true)
    public FileData print(String projectId, String companyId, List<Exempt> data) {
        Assert.isNotEmpty(data, "\u4f20\u8f93\u7684\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u6253\u5370");
        ArrayList<String> ids = null;
        for (Exempt e : data) {
            Assert.isNotBlank(e.getId(), "\u4f20\u8f93\u7684\u5355\u636e\u4e2d\u5b58\u5728ID\u4e3a\u7a7a");
            if (ids == null) {
                ids = new ArrayList<String>();
            }
            ids.add(e.getId());
        }
        ExemptExample exemptExample = new ExemptExample();
        exemptExample.createCriteria().andIdIn(ids);
        List<Exempt> exemptList = this.exemptMapper.selectByExample(exemptExample);
        Assert.isNotEmpty(exemptList, "\u67e5\u8be2\u7684\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6253\u5370");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("exemptList", exemptList);
        FileData fileData = null;
        try {
            fileData = ExemptUtils.generatePdf(projectId, companyId, params, "A4");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileData;
    }
}

