/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.management.service.impl;

import com.els.base.certification.management.dao.ProcessManagementMapper;
import com.els.base.certification.management.entity.ProcessManagement;
import com.els.base.certification.management.entity.ProcessManagementExample;
import com.els.base.certification.management.service.ProcessManagementService;
import com.els.base.certification.process.entity.ProcessExample;
import com.els.base.certification.process.service.ProcessService;
import com.els.base.certification.process.util.AccessProcessEnum;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultProcessManagementService")
public class ProcessManagementServiceImpl
implements ProcessManagementService {
    @Resource
    protected ProcessManagementMapper processManagementMapper;
    @Resource
    protected GenerateCodeService generateCodeService;
    @Resource
    protected ProcessService processService;

    @Override
    @CacheEvict(value={"processManagement"}, allEntries=true)
    public void addObj(ProcessManagement t) {
        this.processManagementMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"processManagement"}, allEntries=true)
    public void insert(User user, Company purCompany, ProcessManagement processManagement) {
        Assert.isNotBlank(processManagement.getProcessName(), "\u6d41\u7a0b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(processManagement.getAccessProcess(), "\u51c6\u5165\u6d41\u7a0b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(processManagement.getSupClassificationName(), "\u4f9b\u5e94\u5546\u5206\u7c7b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        if (AccessProcessEnum.QUALIFICATION_REVIEW.getCode().equals(processManagement.getAccessProcess())) {
            Assert.isNotBlank(processManagement.getQualificationAuditTemplateId(), "\u53ea\u8d44\u8d28\u5ba1\u6838\u65f6\uff0c\u8d44\u8d28\u5ba1\u6838\u6a21\u7248\u4e0d\u80fd\u4e3a\u7a7a");
        } else if (AccessProcessEnum.SCENE_ASSESSMENT.getCode().equals(processManagement.getAccessProcess())) {
            Assert.isNotBlank(processManagement.getSiteInspectionTemplateId(), "\u53ea\u73b0\u573a\u8003\u5bdf\u65f6\uff0c\u73b0\u573a\u8003\u5bdf\u6a21\u7248\u4e0d\u80fd\u4e3a\u7a7a");
        } else if (AccessProcessEnum.QUALIFICATION_AND_SCENE_REVIEW.getCode().equals(processManagement.getAccessProcess())) {
            Assert.isNotBlank(processManagement.getQualificationAuditTemplateId(), "\u8d44\u8d28\u5ba1\u6838\u6a21\u7248\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank(processManagement.getSiteInspectionTemplateId(), "\u73b0\u573a\u8003\u5bdf\u6a21\u7248\u4e0d\u80fd\u4e3a\u7a7a");
        }
        processManagement.setPurCompanyName(purCompany.getCompanyFullName());
        processManagement.setPurCompanySrmCode(purCompany.getCompanyCode());
        processManagement.setPurUserId(user.getId());
        processManagement.setSinglePerson(user.getNickName());
        processManagement.setProcessNumber(this.generateCodeService.getNextCode("ADMITTANCE_PROCESS_NO"));
        processManagement.setIsEnable(Constant.YES_INT);
        processManagement.setCreateTime(new Date());
        processManagement.setUpdateTime(new Date());
        this.processManagementMapper.insertSelective(processManagement);
    }

    @Override
    @CacheEvict(value={"processManagement"}, allEntries=true)
    public void deleteObjByIds(String id) {
        Assert.isNotBlank(id, "\u6570\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
        ProcessExample processExample = new ProcessExample();
        processExample.createCriteria().andProcessIdEqualTo(id).andIsEnableEqualTo(Constant.YES_INT);
        if (this.processService.countByExample(processExample) > 0) {
            throw new CommonException("\u6240\u9009\u6d41\u7a0b\u5df2\u5728\u4f9b\u5e94\u5546\u51c6\u5165\u4e2d\u4f7f\u7528\uff0c\u5220\u9664\u5931\u8d25");
        }
        ProcessManagement t = new ProcessManagement();
        t.setId(id);
        t.setIsEnable(Constant.NO_INT);
        this.processManagementMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @CacheEvict(value={"processManagement"}, allEntries=true)
    public void modifyObj(ProcessManagement t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        Assert.isNotBlank(t.getProcessName(), "\u6d41\u7a0b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(t.getAccessProcess(), "\u51c6\u5165\u6d41\u7a0b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(t.getSupClassificationName(), "\u4f9b\u5e94\u5546\u5206\u7c7b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        ProcessExample processExample = new ProcessExample();
        processExample.createCriteria().andProcessIdEqualTo(t.getId()).andIsEnableEqualTo(Constant.YES_INT);
        if (this.processService.countByExample(processExample) > 0) {
            throw new CommonException("\u6b64\u6d41\u7a0b\u5df2\u5728\u4f9b\u5e94\u5546\u51c6\u5165\u4e2d\u4f7f\u7528\uff0c\u4e0d\u80fd\u518d\u4fee\u6539");
        }
        if (AccessProcessEnum.QUALIFICATION_REVIEW.getCode().equals(t.getAccessProcess())) {
            Assert.isNotBlank(t.getQualificationAuditTemplateId(), "\u53ea\u8d44\u8d28\u5ba1\u6838\u65f6\uff0c\u8d44\u8d28\u6a21\u7248ID\u4e0d\u80fd\u4e3a\u7a7a");
        } else if (AccessProcessEnum.SCENE_ASSESSMENT.getCode().equals(t.getAccessProcess())) {
            Assert.isNotBlank(t.getSiteInspectionTemplateId(), "\u53ea\u73b0\u573a\u8003\u5bdf\u65f6\uff0c\u73b0\u573a\u8003\u5bdf\u6a21\u7248ID\u4e0d\u80fd\u4e3a\u7a7a");
        } else if (AccessProcessEnum.QUALIFICATION_AND_SCENE_REVIEW.getCode().equals(t.getAccessProcess())) {
            Assert.isNotBlank(t.getQualificationAuditTemplateId(), "\u8d44\u8d28\u6a21\u7248ID\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank(t.getSiteInspectionTemplateId(), "\u73b0\u573a\u8003\u5bdf\u6a21\u7248ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        t.setUpdateTime(new Date());
        this.processManagementMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"processManagement"}, keyGenerator="redisKeyGenerator")
    public ProcessManagement queryObjById(String id) {
        return this.processManagementMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"processManagement"}, keyGenerator="redisKeyGenerator")
    public List<ProcessManagement> queryAllObjByExample(ProcessManagementExample example) {
        return this.processManagementMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"processManagement"}, keyGenerator="redisKeyGenerator")
    public PageView<ProcessManagement> queryObjByPage(ProcessManagementExample example) {
        PageView<ProcessManagement> pageView = example.getPageView();
        pageView.setQueryResult(this.processManagementMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"processManagement"}, allEntries=true)
    public void deleteObjById(String id) {
        this.processManagementMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"processManagement"}, allEntries=true)
    public int countByExample(ProcessManagementExample example) {
        return this.processManagementMapper.countByExample(example);
    }
}

