/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.outsourced.service.impl;

import com.els.base.certification.outsourced.dao.OutsourcedMapper;
import com.els.base.certification.outsourced.entity.Outsourced;
import com.els.base.certification.outsourced.entity.OutsourcedExample;
import com.els.base.certification.outsourced.service.OutsourcedService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultOutsourcedService")
public class OutsourcedServiceImpl
implements OutsourcedService {
    @Resource
    protected OutsourcedMapper outsourcedMapper;

    @Override
    @CacheEvict(value={"outsourced"}, allEntries=true)
    public void addObj(Outsourced t) {
        this.outsourcedMapper.insertSelective(t);
    }

    @Override
    @Transactional
    @CacheEvict(value={"outsourced"}, allEntries=true)
    public void batchInserts(String projectId, Company company, List<Outsourced> outsourcedList) {
        if (CollectionUtils.isEmpty(outsourcedList)) {
            return;
        }
        OutsourcedExample example = new OutsourcedExample();
        example.createCriteria().andProjectIdEqualTo(projectId).andCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
        Outsourced outsourced = new Outsourced();
        outsourced.setIsEnable(Constant.NO_INT);
        this.outsourcedMapper.updateByExampleSelective(outsourced, example);
        outsourcedList.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
            item.setProjectId(projectId);
            item.setCompanyId(company.getId());
            item.setCompanySrmCode(company.getCompanyCode());
            item.setIsEnable(Constant.YES_INT);
            item.setCreateTime(new Date());
        });
        this.outsourcedMapper.insertBatch(outsourcedList);
    }

    @Override
    @Transactional
    @CacheEvict(value={"outsourced"}, allEntries=true)
    public void addAll(List<Outsourced> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.outsourcedMapper.insertBatch(list);
    }

    @Override
    @CacheEvict(value={"outsourced"}, allEntries=true)
    public void deleteObjById(String id) {
        this.outsourcedMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"outsourced"}, allEntries=true)
    public void deleteByExample(OutsourcedExample example) {
        Assert.isNotNull(example, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), "\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.outsourcedMapper.deleteByExample(example);
    }

    @Override
    @CacheEvict(value={"outsourced"}, allEntries=true)
    public void modifyObj(Outsourced t) {
        Assert.isNotBlank(t.getId(), "id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.outsourcedMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"outsourced"}, keyGenerator="redisKeyGenerator")
    public Outsourced queryObjById(String id) {
        return this.outsourcedMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"outsourced"}, keyGenerator="redisKeyGenerator")
    public List<Outsourced> queryAllObjByExample(OutsourcedExample example) {
        return this.outsourcedMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"outsourced"}, keyGenerator="redisKeyGenerator")
    public PageView<Outsourced> queryObjByPage(OutsourcedExample example) {
        PageView<Outsourced> pageView = example.getPageView();
        pageView.setQueryResult(this.outsourcedMapper.selectByExampleByPage(example));
        return pageView;
    }
}

