/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.outsourced.web.controller;

import com.els.base.certification.outsourced.entity.Outsourced;
import com.els.base.certification.outsourced.entity.OutsourcedExample;
import com.els.base.certification.outsourced.service.OutsourcedService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u4f9b\u5e94\u5546\u57fa\u7840\u8d44\u6599-\u5916\u5305\u4e8c\u7ea7\u4f9b\u5e94\u5546\u4fe1\u606f")
@Controller
@RequestMapping(value={"outsourced"})
public class OutsourcedController {
    @Resource
    protected OutsourcedService outsourcedService;

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u521b\u5efa\u4f9b\u5e94\u5546\u57fa\u7840\u8d44\u6599-\u5916\u5305\u4e8c\u7ea7\u4f9b\u5e94\u5546\u4fe1\u606f")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> batchCreate(@RequestBody List<Outsourced> outsourcedList) {
        Assert.isNotEmpty(outsourcedList, "\u521b\u5efa\u7684\u6570\u636e\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25");
        outsourcedList.stream().forEach(outsourced -> {
            Assert.isNotBlank(outsourced.getBusinessLicense(), "\u5916\u5305\u5546\u8425\u4e1a\u6267\u7167\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank(outsourced.getQualitySystem(), "\u5916\u5305\u5546\u8425\u4e1a\u6267\u7167\u4e0d\u80fd\u4e3a\u7a7a");
        });
        this.outsourcedService.batchInserts(ProjectUtils.getProjectId(), CompanyUtils.currentCompany(), outsourcedList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u4f9b\u5e94\u5546\u57fa\u7840\u8d44\u6599-\u5916\u5305\u4e8c\u7ea7\u4f9b\u5e94\u5546\u4fe1\u606f")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody Outsourced outsourced) {
        Assert.isNotBlank(outsourced.getId(), "id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.outsourcedService.modifyObj(outsourced);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u5220\u9664\u4f9b\u5e94\u5546\u57fa\u7840\u8d44\u6599-\u5916\u5305\u4e8c\u7ea7\u4f9b\u5e94\u5546\u4fe1\u606f")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, "\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        OutsourcedExample example = new OutsourcedExample();
        example.createCriteria().andIdIn((List)ids).andIsEnableEqualTo(Constant.YES_INT).andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        this.outsourcedService.deleteByExample(example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u57fa\u7840\u8d44\u6599-\u5916\u5305\u4e8c\u7ea7\u4f9b\u5e94\u5546\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Outsourced", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<Outsourced>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        OutsourcedExample example = new OutsourcedExample();
        example.setPageView(new PageView<Outsourced>(pageNo, pageSize));
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView pageData = this.outsourcedService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5168\u90e8\u4f9b\u5e94\u5546\u57fa\u7840\u8d44\u6599-\u5916\u5305\u4e8c\u7ea7\u4f9b\u5e94\u5546\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="companySrmCode", required=false, value="\u4f9b\u5e94\u5546SRM\u7f16\u7801", dataType="String"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Agent", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findAll"})
    @ResponseBody
    public ResponseResult<List<Outsourced>> findAll(@RequestParam(required=false) String companySrmCode, @RequestBody(required=false) QueryParamWapper wapper) {
        OutsourcedExample example = new OutsourcedExample();
        OutsourcedExample.Criteria criteria = example.createCriteria();
        if (StringUtils.isBlank((String)companySrmCode)) {
            criteria.andIsEnableEqualTo(Constant.YES_INT).andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        } else {
            criteria.andIsEnableEqualTo(Constant.YES_INT).andCompanySrmCodeEqualTo(companySrmCode);
        }
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        List list = this.outsourcedService.queryAllObjByExample(example);
        return ResponseResult.success(list);
    }
}

