/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.patents.service.impl;

import com.els.base.certification.patents.dao.CompanyPatentsMapper;
import com.els.base.certification.patents.entity.CompanyPatents;
import com.els.base.certification.patents.entity.CompanyPatentsExample;
import com.els.base.certification.patents.service.CompanyPatentsService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultCompanyPatentsService")
public class CompanyPatentsServiceImpl
implements CompanyPatentsService {
    @Resource
    private CompanyPatentsMapper companyPatentsMapper;

    @Override
    @Cacheable(value={"companyPatents"}, keyGenerator="redisKeyGenerator")
    public Integer isFinish(Project project, Company company) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(Constant.NO_INT);
        CompanyPatentsExample companyPatentsExample = new CompanyPatentsExample();
        companyPatentsExample.createCriteria().andProjectIdEqualTo(project.getId()).andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
        int count = this.companyPatentsMapper.countByExample(companyPatentsExample);
        if (count <= 0) {
            return 0;
        }
        companyPatentsExample.clear();
        companyPatentsExample.createCriteria().andProjectIdEqualTo(project.getId()).andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT).andFinishFlagIn(list);
        int finishCount = this.companyPatentsMapper.countByExample(companyPatentsExample);
        if (finishCount > 0) {
            return 0;
        }
        return 1;
    }

    @Override
    @CacheEvict(value={"companyPatents"}, allEntries=true)
    @Transactional
    public Integer batchInsert(String projectId, Company company, List<CompanyPatents> companyPatentsList) {
        if (CollectionUtils.isEmpty(companyPatentsList)) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e");
        }
        CompanyPatentsExample companyPatentsExample = new CompanyPatentsExample();
        companyPatentsExample.createCriteria().andProjectIdEqualTo(projectId).andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
        CompanyPatents companyPatents = new CompanyPatents();
        companyPatents.setIsEnable(Constant.NO_INT);
        this.companyPatentsMapper.updateByExampleSelective(companyPatents, companyPatentsExample);
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (CompanyPatents patents : companyPatentsList) {
            Assert.isNotBlank(patents.getPatentName(), "\u4e13\u5229/\u8bb8\u53ef\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6b63\u786e\u586b\u5199\u4e13\u5229/\u8bb8\u53ef\u540d");
            Assert.isNotNull(patents.getEndTime(), "\u4e13\u5229/\u8bb8\u53ef\u7684\u6709\u6548\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u4e13\u5229/\u8bb8\u53ef\u7684\u6709\u6548\u671f");
            if ("[]".equals(patents.getPatentFile()) || StringUtils.isBlank((String)patents.getPatentFile())) {
                throw new CommonException("\u6709\u4e13\u5229/\u8bb8\u53ef\u7684\u9644\u4ef6\u6ca1\u6709\u4e0a\u4f20\uff0c\u8bf7\u4e0a\u4f20\u9644\u4ef6\u540e\u518d\u4fdd\u5b58");
            }
            patents.setId(null);
            patents.setProjectId(projectId);
            patents.setSupCompanyId(company.getId());
            patents.setIsEnable(Constant.YES_INT);
            patents.setUpdateTime(new Date());
            if (patents.getCreateTime() == null) {
                patents.setCreateTime(new Date());
            }
            Integer finishFlag = patents.getFinishFlag();
            patents.setFinishFlag(finishFlag);
            this.companyPatentsMapper.insertSelective(patents);
            list.add(finishFlag);
        }
        if (list.contains(Constant.NO_INT)) {
            return 0;
        }
        return 1;
    }

    @Override
    @CacheEvict(value={"companyPatents"}, allEntries=true)
    public void deleteObjByIds(String projectId, Company company, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e");
        }
        CompanyPatentsExample companyPatentsExample = new CompanyPatentsExample();
        companyPatentsExample.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andSupCompanyIdEqualTo(company.getId()).andProjectIdEqualTo(projectId).andIdIn((List)ids);
        CompanyPatents companyPatents = new CompanyPatents();
        companyPatents.setIsEnable(Constant.NO_INT);
        this.companyPatentsMapper.updateByExampleSelective(companyPatents, companyPatentsExample);
    }

    @Override
    @CacheEvict(value={"companyPatents"}, allEntries=true)
    public void addObj(CompanyPatents t) {
        this.companyPatentsMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"companyPatents"}, allEntries=true)
    public void deleteObjById(String id) {
        this.companyPatentsMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"companyPatents"}, allEntries=true)
    public void modifyObj(CompanyPatents t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.companyPatentsMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"companyPatents"}, keyGenerator="redisKeyGenerator")
    public CompanyPatents queryObjById(String id) {
        return this.companyPatentsMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"companyPatents"}, keyGenerator="redisKeyGenerator")
    public List<CompanyPatents> queryAllObjByExample(CompanyPatentsExample example) {
        return this.companyPatentsMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"companyPatents"}, keyGenerator="redisKeyGenerator")
    public PageView<CompanyPatents> queryObjByPage(CompanyPatentsExample example) {
        PageView<CompanyPatents> pageView = example.getPageView();
        pageView.setQueryResult(this.companyPatentsMapper.selectByExampleByPage(example));
        return pageView;
    }
}

