/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.process.service.impl;

import com.els.base.certification.process.dao.ProcessMapper;
import com.els.base.certification.process.entity.Process;
import com.els.base.certification.process.entity.ProcessExample;
import com.els.base.certification.process.service.ProcessService;
import com.els.base.certification.process.util.AccessProcessEnum;
import com.els.base.certification.process.util.AuthenticationEnum;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.excel.DateConverter;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.ObjToStrConverter;
import com.els.base.utils.excel.StrToObjConverter;
import com.els.base.utils.excel.TitleAndModelKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultProcessService")
public class ProcessServiceImpl
implements ProcessService {
    @Resource
    protected ProcessMapper processMapper;

    @Override
    @CacheEvict(value={"process"}, allEntries=true)
    public void addObj(Process t) {
        Assert.isNotBlank(t.getProcessId(), "\u51c6\u5165\u6d41\u7a0bID\u4e0d\u80fd\u4e3a\u7a7a");
        t.setIsEnable(Constant.YES_INT);
        t.setIsSend(AuthenticationEnum.UNCERTIFIED.getCode());
        t.setCreateTime(new Date());
        t.setUpdateTime(new Date());
        Process process = this.queryObjByCompanyId(t.getCompanyId());
        if (null == process) {
            this.processMapper.insertSelective(t);
        } else {
            if (StringUtils.isNotBlank((String)process.getQualificationAudit()) || StringUtils.isNotBlank((String)process.getSceneInvestigate())) {
                throw new CommonException("\u8d44\u8d28\u5ba1\u6838\u6216\u73b0\u573a\u8003\u5bdf\u5df2\u5728\u8fdb\u884c\u4e2d\uff0c\u4e0d\u80fd\u518d\u4fee\u6539\u6d41\u7a0b");
            }
            if (AccessProcessEnum.NOT_REVIEW.getCode().equals(process.getAccessProcess()) && AuthenticationEnum.UNCERTIFIED.getCode() != process.getIsSend()) {
                throw new CommonException("\u4f9b\u5e94\u5546\u5df2\u5728\u8ba4\u8bc1\u4e2d\uff0c\u4e0d\u80fd\u4fee\u6539\u6d41\u7a0b");
            }
            this.deleteObjById(process.getId());
            this.processMapper.insertSelective(t);
        }
    }

    @Override
    @CacheEvict(value={"process"}, allEntries=true)
    public void deleteObjById(String id) {
        this.processMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"process"}, allEntries=true)
    public void modifyObj(Process t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.processMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @CacheEvict(value={"process"}, allEntries=true)
    public void updateById(Process process) {
        if (StringUtils.isBlank((String)process.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.processMapper.updateByPrimaryKey(process);
    }

    @Override
    @Cacheable(value={"process"}, keyGenerator="redisKeyGenerator")
    public Process queryObjById(String id) {
        return this.processMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"process"}, keyGenerator="redisKeyGenerator")
    public List<Process> queryAllObjByExample(ProcessExample example) {
        return this.processMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"process"}, keyGenerator="redisKeyGenerator")
    public PageView<Process> queryObjByPage(ProcessExample example) {
        PageView<Process> pageView = example.getPageView();
        pageView.setQueryResult(this.processMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"process"}, keyGenerator="redisKeyGenerator")
    public Process queryObjByCompanyId(String companyId) {
        Assert.isNotBlank(companyId, "\u4f9b\u5e94\u5546\u7684ID\u4e0d\u80fd\u4e3a\u7a7a");
        ProcessExample example = new ProcessExample();
        example.createCriteria().andCompanyIdEqualTo(companyId);
        List<Process> list = this.processMapper.selectByExample(example);
        return CollectionUtils.isNotEmpty(list) ? list.get(0) : null;
    }

    @Override
    public PageView<Company> queryAllCompnayByPage(String purCompanyId, String roleEnum, Map<String, Object> queryMap) {
        PageView<Company> pageView = new PageView<Company>(MapUtils.getIntValue(queryMap, (Object)"pageNo"), MapUtils.getIntValue(queryMap, (Object)"pageSize"));
        queryMap.put("offset", (MapUtils.getIntValue(queryMap, (Object)"pageNo") - 1) * MapUtils.getIntValue(queryMap, (Object)"pageSize"));
        List<Company> list = this.processMapper.selectCompanyAndProcessInfoByPage(purCompanyId, roleEnum, queryMap);
        pageView.setQueryResult(list);
        pageView.setRowCount(this.processMapper.selectCompanyAndProcessInfoCount(purCompanyId, roleEnum, queryMap));
        return pageView;
    }

    @Override
    @CacheEvict(value={"process"}, allEntries=true)
    public int countByExample(ProcessExample example) {
        return this.processMapper.countByExample(example);
    }

    @Override
    @CacheEvict(value={"process"}, allEntries=true)
    public List<TitleAndModelKey> createExcelHeaderForPur() {
        DateConverter dateConverter = new DateConverter();
        dateConverter.setDateFormat("yyyy-MM-dd");
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"SRM\u4f9b\u5e94\u5546\u7f16\u7801", (String)"companyCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7b80\u79f0", (String)"companyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8ba4\u8bc1\u72b6\u6001", (String)"isSendName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u51c6\u5165\u6d41\u7a0b\u540d\u79f0", (String)"processName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u51c6\u5165\u6d41\u7a0b", (String)"accessProcessName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8d44\u8d28\u8003\u5bdf", (String)"qualificationAuditName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u73b0\u573a\u8003\u5bdf", (String)"sceneInvestigateName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ea7\u54c1\u5927\u7c7b1", (String)"secondCompanyTypeDesc1"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ea7\u54c1\u5927\u7c7b2", (String)"secondCompanyTypeDesc2"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ea7\u54c1\u5927\u7c7b3", (String)"secondCompanyTypeDesc3"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ea7\u54c1\u5927\u7c7b4", (String)"secondCompanyTypeDesc4"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ea7\u54c1\u5927\u7c7b5", (String)"secondCompanyTypeDesc5"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u670d\u52a1\u7c7b", (String)"firstCompanyTypeDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u82f1\u6587\u7b80\u79f0", (String)"companyEnglishAbbreviation"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u5168\u79f0", (String)"companyFullName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u82f1\u6587\u5168\u79f0", (String)"englishCompanyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"ISO9001\u4f53\u7cfb\u8bc1\u4e66", (String)"ISO9001FileName"));
        TitleAndModelKey ISO9001EndTime = ExcelUtils.createTitleAndModelKey((String)"ISO9001\u4f53\u7cfb\u8bc1\u4e66\u6709\u6548\u671f", (String)"ISO9001EndTime");
        ISO9001EndTime.setToObjConverter((StrToObjConverter)dateConverter);
        ISO9001EndTime.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(ISO9001EndTime);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"IATF16949\u4f53\u7cfb\u8bc1\u4e66", (String)"IATF16949FileName"));
        TitleAndModelKey IATF16949EndTime = ExcelUtils.createTitleAndModelKey((String)"IATF16949\u4f53\u7cfb\u8bc1\u4e66\u6709\u6548\u671f", (String)"IATF16949EndTime");
        IATF16949EndTime.setToObjConverter((StrToObjConverter)dateConverter);
        IATF16949EndTime.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(IATF16949EndTime);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"ISO14000\u4f53\u7cfb\u8bc1\u4e66", (String)"ISO14000FileName"));
        TitleAndModelKey ISO14000EndTime = ExcelUtils.createTitleAndModelKey((String)"ISO14000\u8bc1\u4e66\u6709\u6548\u671f", (String)"ISO14000EndTime");
        ISO14000EndTime.setToObjConverter((StrToObjConverter)dateConverter);
        ISO14000EndTime.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(ISO14000EndTime);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8d1f\u8d23\u4eba", (String)"contacts"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"E-MAIL", (String)"email"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"TEL(\u4e00)", (String)"telephone"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"FAXNO", (String)"fax"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8054\u7cfb\u5730\u5740(\u4e2d\u6587)", (String)"address"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u82f1\u6587\u5730\u5740", (String)"englishAddress"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7ecf\u8425\u8303\u56f4", (String)"businessScope"));
        TitleAndModelKey createTime = ExcelUtils.createTitleAndModelKey((String)"\u6ce8\u518c\u65f6\u95f4", (String)"createTime");
        createTime.setToObjConverter((StrToObjConverter)dateConverter);
        createTime.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(createTime);
        return titleAndModelKeys;
    }
}

