/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.process.web.controller;

import com.els.base.certification.auth.entity.CompanyAuth;
import com.els.base.certification.auth.entity.CompanyAuthExample;
import com.els.base.certification.auth.service.CompanyAuthService;
import com.els.base.certification.common.CertificateTypeCodeEnum;
import com.els.base.certification.management.entity.ProcessManagement;
import com.els.base.certification.management.service.ProcessManagementService;
import com.els.base.certification.process.entity.Process;
import com.els.base.certification.process.entity.ProcessExample;
import com.els.base.certification.process.service.ProcessService;
import com.els.base.certification.process.util.AccessProcessEnum;
import com.els.base.certification.process.util.AuthenticationEnum;
import com.els.base.certification.process.util.ExcelFileData;
import com.els.base.certification.process.util.ReviewResultEnum;
import com.els.base.certification.process.vo.CompanyProcessVO;
import com.els.base.certification.process.vo.CompanyQualificationVO;
import com.els.base.certification.process.vo.ReportFormVO;
import com.els.base.certification.process.vo.SupplierCompanyVO;
import com.els.base.certification.qualificationssm.entity.QualificationsSM;
import com.els.base.certification.qualificationssm.entity.QualificationsSMFlie;
import com.els.base.certification.qualificationssm.entity.QualificationsSMFlieExample;
import com.els.base.certification.qualificationssm.service.QualificationsSMFlieService;
import com.els.base.certification.qualificationssm.service.QualificationsSMService;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyTypeEnum;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.company.utils.PartnerRoleEnum;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.dictionary.DicGroupItem;
import com.els.base.core.service.dictionary.DicGroupItemService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.utils.excel.TitleAndModelKey;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import jxl.write.WriteException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u4f9b\u5e94\u5546\u51c6\u5165-\u51c6\u5165\u6d41\u7a0b")
@Controller
@RequestMapping(value={"process"})
public class ProcessController {
    @Resource
    protected ProcessService processService;
    @Resource
    protected CompanyService companyService;
    @Resource
    private DicGroupItemService dicGroupItemService;
    @Resource
    private CompanyAuthService companyAuthService;
    @Resource
    private QualificationsSMService qualificationsSMService;
    @Resource
    private QualificationsSMFlieService qualificationsSMFlieService;
    @Resource
    private ProcessManagementService processManagementService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u4f9b\u5e94\u5546\u51c6\u5165-\u51c6\u5165\u6d41\u7a0b")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody Process process) {
        Assert.isNotNull(process, "\u4fdd\u5b58\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(process.getCompanyId(), "\u4f9b\u5e94\u5546ID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(process.getAccessProcess(), "\u51c6\u5165\u6d41\u7a0b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(process.getProcessName(), "\u51c6\u5165\u6d41\u7a0b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        this.processService.addObj(process);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u4f9b\u5e94\u5546\u51c6\u5165-\u51c6\u5165\u6d41\u7a0b")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody Process process) {
        Assert.isNotBlank(process.getId(), "id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.processService.modifyObj(process);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u4f9b\u5e94\u5546\u51c6\u5165-\u51c6\u5165\u6d41\u7a0b")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.processService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u51c6\u5165-\u51c6\u5165\u6d41\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Process", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<Process>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        ProcessExample example = new ProcessExample();
        example.setPageView(new PageView<Process>(pageNo, pageSize));
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView pageData = this.processService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u8d44\u8d28\u5ba1\u6838\u3001\u73b0\u573a\u8003\u5bdf\u5355\u65f6\u67e5\u8be2\u4f9b\u5e94\u5546\u4e0e\u51c6\u5165\u6d41\u7a0b\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="accessProcess", required=true, value="\u5ba1\u6838\u6d41\u7a0b\uff1a\u4e0d\u9700\u5ba1\u6838\uff0c\u53ea\u8d44\u8d28\u5ba1\u6838\uff0c\u53ea\u73b0\u573a\u8003\u6838\uff0c\u8d44\u8d28\u5ba1\u6838->\u73b0\u573a\u8003\u6838 (1,2,3,4)", paramType="query", dataType="String"), @ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Process", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findCompanyByPage"})
    @ResponseBody
    public ResponseResult<PageView<CompanyProcessVO>> findCompanyByPage(@RequestParam String accessProcess, @RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        Assert.isNotBlank(accessProcess, "\u4f20\u5165\u7684\u51c6\u5165\u6d41\u7a0b\u4e0d\u80fd\u4e3a\u7a7a");
        CompanyExample companyExample = new CompanyExample();
        companyExample.setPageView(new PageView<Company>(pageNo, pageSize));
        companyExample.setOrderByClause("CREATE_TIME DESC");
        CompanyExample.Criteria criteria = companyExample.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample(companyExample, wapper);
        }
        String roleEnum = "stranger";
        String purCompanyId = CompanyUtils.currentCompanyId();
        PageView<Company> companyPageView = this.companyService.querySupplerCompanies(purCompanyId, companyExample, roleEnum);
        List<Company> companyList = companyPageView.getQueryResult();
        PageView companyVoPage = new PageView(pageNo, pageSize);
        if (CollectionUtils.isEmpty(companyList)) {
            return ResponseResult.success(companyVoPage);
        }
        int rowCount = 0;
        ArrayList<CompanyProcessVO> voList = new ArrayList<CompanyProcessVO>();
        for (Company company : companyList) {
            List<QualificationsSMFlie> fileList;
            QualificationsSMFlieExample fileExample;
            QualificationsSM qualificationSM;
            ProcessManagement manage;
            Process process = this.processService.queryObjByCompanyId(company.getId());
            if (null == process) continue;
            CompanyProcessVO vo = new CompanyProcessVO();
            if ("2".equals(accessProcess)) {
                if (!AccessProcessEnum.QUALIFICATION_REVIEW.getCode().equals(process.getAccessProcess()) && !AccessProcessEnum.QUALIFICATION_AND_SCENE_REVIEW.getCode().equals(process.getAccessProcess()) || !StringUtils.isBlank((String)process.getQualificationAudit()) && !ReviewResultEnum.TERMINATION.getCode().equals(process.getQualificationAudit())) continue;
                manage = (ProcessManagement)this.processManagementService.queryObjById(process.getProcessId());
                qualificationSM = (QualificationsSM)this.qualificationsSMService.queryObjById(manage.getQualificationAuditTemplateId());
                fileExample = new QualificationsSMFlieExample();
                fileExample.createCriteria().andTemplatIdEqualTo(manage.getQualificationAuditTemplateId()).andIsEnableEqualTo(Constant.YES_INT);
                fileList = this.qualificationsSMFlieService.queryAllObjByExample(fileExample);
                qualificationSM.setQualificationsSMFlielist(fileList);
                BeanUtils.copyProperties((Object)company, (Object)vo);
                this.setSecondCompanyType(company, vo);
                this.setSupplierCertification(vo);
                vo.setProcess(process);
                vo.setQualifications(qualificationSM);
                voList.add(vo);
                ++rowCount;
                continue;
            }
            if (!"3".equals(accessProcess) || !AccessProcessEnum.SCENE_ASSESSMENT.getCode().equals(process.getAccessProcess()) && (!AccessProcessEnum.QUALIFICATION_AND_SCENE_REVIEW.getCode().equals(process.getAccessProcess()) || !ReviewResultEnum.ADOPT.getCode().equals(process.getQualificationAudit())) || !StringUtils.isBlank((String)process.getSceneInvestigate()) && !ReviewResultEnum.TERMINATION.getCode().equals(process.getSceneInvestigate())) continue;
            manage = (ProcessManagement)this.processManagementService.queryObjById(process.getProcessId());
            qualificationSM = (QualificationsSM)this.qualificationsSMService.queryObjById(manage.getSiteInspectionTemplateId());
            fileExample = new QualificationsSMFlieExample();
            fileExample.createCriteria().andTemplatIdEqualTo(manage.getSiteInspectionTemplateId()).andIsEnableEqualTo(Constant.YES_INT);
            fileList = this.qualificationsSMFlieService.queryAllObjByExample(fileExample);
            qualificationSM.setQualificationsSMFlielist(fileList);
            BeanUtils.copyProperties((Object)company, (Object)vo);
            this.setSecondCompanyType(company, vo);
            this.setSupplierCertification(vo);
            vo.setProcess(process);
            vo.setQualifications(qualificationSM);
            voList.add(vo);
            ++rowCount;
        }
        companyVoPage.setQueryResult(voList);
        companyVoPage.setRowCount(rowCount);
        return ResponseResult.success(companyVoPage);
    }

    private void setCompanyAndProcessInfo(Process process, CompanyQualificationVO vo, String accessProcess) {
        Company company = (Company)this.companyService.queryObjById(process.getCompanyId());
        QualificationsSM qualificationsSM = null;
        if (AccessProcessEnum.QUALIFICATION_REVIEW.getCode().equals(accessProcess)) {
            qualificationsSM = (QualificationsSM)this.qualificationsSMService.queryObjById(process.getQualificationAuditTemplateId());
        }
        if (AccessProcessEnum.SCENE_ASSESSMENT.getCode().equals(accessProcess)) {
            qualificationsSM = (QualificationsSM)this.qualificationsSMService.queryObjById(process.getSiteInspectionTemplateId());
        }
        QualificationsSMFlieExample fileExample = new QualificationsSMFlieExample();
        fileExample.createCriteria().andTemplatIdEqualTo(qualificationsSM.getId()).andIsEnableEqualTo(Constant.YES_INT);
        List<QualificationsSMFlie> fileList = this.qualificationsSMFlieService.queryAllObjByExample(fileExample);
        qualificationsSM.setQualificationsSMFlielist(fileList);
        BeanUtils.copyProperties((Object)company, (Object)vo);
        vo.setProcess(process);
        vo.setQualifications(qualificationsSM);
    }

    @ApiOperation(httpMethod="POST", value="\u51c6\u5165\u62a5\u8868-\u51c6\u5165\u6d41\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Process", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/formFindByPage"})
    @ResponseBody
    public ResponseResult<PageView<ReportFormVO>> formFindByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        CompanyExample companyExample = new CompanyExample();
        companyExample.setPageView(new PageView<Company>(pageNo, pageSize));
        companyExample.setOrderByClause("CREATE_TIME DESC");
        companyExample.createCriteria().andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample(companyExample, wapper);
        }
        PageView companyPage = this.companyService.queryObjByPage(companyExample);
        List<Company> companyList = companyPage.getQueryResult();
        List<ReportFormVO> list = this.getReportForm(companyList);
        PageView<ReportFormVO> formPage = new PageView<ReportFormVO>(pageNo, pageSize);
        formPage.setQueryResult(list);
        return ResponseResult.success(formPage);
    }

    private List<ReportFormVO> getReportForm(List<Company> companyList) {
        ArrayList<ReportFormVO> list = new ArrayList<ReportFormVO>();
        for (Company company : companyList) {
            ReportFormVO vo = new ReportFormVO();
            Process process = this.processService.queryObjByCompanyId(company.getId());
            if (null == process) continue;
            vo.setSupCompanyName(company.getCompanyFullName());
            vo.setSupCompanySrmCode(company.getCompanyCode());
            vo.setStartTime(company.getCreateTime());
            vo.setSupplierLevelCode(process.getSupplierLevelCode());
            vo.setSupClassificationName(process.getSupClassificationName());
            vo.setAccessProcess(process.getAccessProcess());
            if (AccessProcessEnum.QUALIFICATION_REVIEW.getCode().equals(process.getAccessProcess())) {
                vo.setStatus(process.getQualificationAudit());
                if (!ReviewResultEnum.AUDIT.getCode().equals(process.getQualificationAudit())) {
                    vo.setEndTime(process.getUpdateTime());
                }
            }
            if (AccessProcessEnum.SCENE_ASSESSMENT.getCode().equals(process.getAccessProcess())) {
                vo.setStatus(process.getSceneInvestigate());
                if (!ReviewResultEnum.AUDIT.getCode().equals(process.getSceneInvestigate())) {
                    vo.setEndTime(process.getUpdateTime());
                }
            }
            if (AccessProcessEnum.QUALIFICATION_AND_SCENE_REVIEW.getCode().equals(process.getAccessProcess())) {
                vo.setStatus(ReviewResultEnum.AUDIT.getCode());
                if (ReviewResultEnum.TERMINATION.getCode().equals(process.getQualificationAudit())) {
                    vo.setStatus(process.getQualificationAudit());
                    vo.setEndTime(process.getUpdateTime());
                }
                if (!ReviewResultEnum.AUDIT.getCode().equals(process.getSceneInvestigate())) {
                    vo.setStatus(process.getSceneInvestigate());
                    vo.setEndTime(process.getUpdateTime());
                }
            }
            list.add(vo);
        }
        return list;
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u4e0e\u51c6\u5165\u6d41\u7a0b\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleEnum", required=false, value="\u964c\u751f\u4f9b\u5e94\u5546\uff0c\u5408\u683c\u4f9b\u5e94\u5546\uff08stranger/qualified\uff09", paramType="query", dataType="String", defaultValue="stranger"), @ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Process", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findAllCompanyByPage"})
    @ResponseBody
    public ResponseResult<PageView<CompanyProcessVO>> findAllCompanyByPage(@RequestParam(defaultValue="stranger") String roleEnum, @RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        CompanyExample companyExample = new CompanyExample();
        companyExample.setPageView(new PageView<Company>(pageNo, pageSize));
        companyExample.setOrderByClause("CREATE_TIME DESC");
        CompanyExample.Criteria criteria = companyExample.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample(companyExample, wapper);
        }
        String purCompanyId = CompanyUtils.currentCompanyId();
        PageView<Company> companyPageView = this.companyService.querySupplerCompanies(purCompanyId, companyExample, roleEnum);
        List<Company> companyList = companyPageView.getQueryResult();
        PageView<CompanyProcessVO> companyProcessPage = new PageView<CompanyProcessVO>(pageNo, pageSize);
        companyProcessPage.setRowCount(companyPageView.getRowCount());
        if (CollectionUtils.isEmpty(companyList)) {
            return ResponseResult.success(companyProcessPage);
        }
        List<CompanyProcessVO> list = this.getSuppliers(companyList);
        companyProcessPage.setQueryResult(list);
        return ResponseResult.success(companyProcessPage);
    }

    private List<CompanyProcessVO> getSuppliers(List<Company> companyList) {
        ArrayList<CompanyProcessVO> list = new ArrayList<CompanyProcessVO>();
        companyList.forEach(company -> {
            CompanyProcessVO vo = new CompanyProcessVO();
            BeanUtils.copyProperties((Object)company, (Object)vo);
            this.setSecondCompanyType((Company)company, vo);
            this.setSupplierCertification(vo);
            ProcessExample processExample = new ProcessExample();
            processExample.createCriteria().andCompanyIdEqualTo(company.getId());
            List processList = this.processService.queryAllObjByExample(processExample);
            Process process = new Process();
            if (CollectionUtils.isNotEmpty(processList)) {
                process = (Process)processList.get(0);
            }
            vo.setProcess(process);
            list.add(vo);
        });
        return list;
    }

    private void setSupplierCertification(CompanyProcessVO vo) {
        CompanyAuthExample companyAuthExample = new CompanyAuthExample();
        companyAuthExample.clear();
        companyAuthExample.createCriteria().andSupCompanyIdEqualTo(vo.getId()).andIsEnableEqualTo(Constant.YES_INT).andCertificateTypeCodeEqualTo(CertificateTypeCodeEnum.IATF16949.getCode());
        List companyAuthList = this.companyAuthService.queryAllObjByExample(companyAuthExample);
        if (CollectionUtils.isNotEmpty(companyAuthList)) {
            JSONArray json;
            CompanyAuth companyAuth1 = (CompanyAuth)companyAuthList.get(0);
            String str = "";
            if (StringUtils.isNotEmpty((String)companyAuth1.getCertificateFile()) && (json = JSONArray.fromObject((Object)companyAuth1.getCertificateFile())).size() > 0) {
                JSONObject job = json.getJSONObject(0);
                str = (String)job.get("name");
            }
            vo.setIATF16949FileName(str);
            vo.setIATF16949Name(companyAuth1.getCertificateFile());
            vo.setIATF16949EndTime(companyAuth1.getEndTime());
        }
        companyAuthExample.clear();
        companyAuthExample.createCriteria().andSupCompanyIdEqualTo(vo.getId()).andIsEnableEqualTo(Constant.YES_INT).andCertificateTypeCodeEqualTo(CertificateTypeCodeEnum.IOS9001.getCode());
        List companyAuthList2 = this.companyAuthService.queryAllObjByExample(companyAuthExample);
        if (CollectionUtils.isNotEmpty(companyAuthList2)) {
            JSONArray json;
            CompanyAuth companyAuth2 = (CompanyAuth)companyAuthList2.get(0);
            String str = "";
            if (StringUtils.isNotEmpty((String)companyAuth2.getCertificateFile()) && (json = JSONArray.fromObject((Object)companyAuth2.getCertificateFile())).size() > 0) {
                JSONObject job = json.getJSONObject(0);
                str = (String)job.get("name");
            }
            vo.setISO9001FileName(str);
            vo.setISO9001Name(companyAuth2.getCertificateFile());
            vo.setISO9001EndTime(companyAuth2.getEndTime());
        }
        companyAuthExample.clear();
        companyAuthExample.createCriteria().andSupCompanyIdEqualTo(vo.getId()).andIsEnableEqualTo(Constant.YES_INT).andCertificateTypeCodeEqualTo(CertificateTypeCodeEnum.IOS14000.getCode());
        List companyAuthList3 = this.companyAuthService.queryAllObjByExample(companyAuthExample);
        if (CollectionUtils.isNotEmpty(companyAuthList3)) {
            JSONArray json;
            CompanyAuth companyAuth3 = (CompanyAuth)companyAuthList3.get(0);
            String str = "";
            if (StringUtils.isNotEmpty((String)companyAuth3.getCertificateFile()) && (json = JSONArray.fromObject((Object)companyAuth3.getCertificateFile())).size() > 0) {
                JSONObject job = json.getJSONObject(0);
                str = (String)job.get("name");
            }
            vo.setISO14000FileName(str);
            vo.setISO14000Name(companyAuth3.getCertificateFile());
            vo.setISO14000EndTime(companyAuth3.getEndTime());
        }
    }

    private void setSecondCompanyType(Company company, CompanyProcessVO vo) {
        Object[] secondCompanyTypeStr;
        String secondCompanyType = company.getSecondCompanyType();
        if (StringUtils.isNotBlank((String)secondCompanyType) && ArrayUtils.isNotEmpty((Object[])(secondCompanyTypeStr = secondCompanyType.split(",")))) {
            if (secondCompanyTypeStr.length > 5) {
                vo.setSecondCompanyType1((String)secondCompanyTypeStr[0]);
                DicGroupItem dicItem1 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", (String)secondCompanyTypeStr[0]);
                if (dicItem1 != null) {
                    vo.setSecondCompanyTypeDesc1(dicItem1.getName());
                } else {
                    vo.setSecondCompanyTypeDesc1("");
                }
                vo.setSecondCompanyType2((String)secondCompanyTypeStr[1]);
                DicGroupItem dicItem2 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", (String)secondCompanyTypeStr[1]);
                if (dicItem2 != null) {
                    vo.setSecondCompanyTypeDesc2(dicItem2.getName());
                } else {
                    vo.setSecondCompanyTypeDesc2("");
                }
                vo.setSecondCompanyType3((String)secondCompanyTypeStr[2]);
                DicGroupItem dicItem3 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", (String)secondCompanyTypeStr[2]);
                if (dicItem3 != null) {
                    vo.setSecondCompanyTypeDesc3(dicItem3.getName());
                } else {
                    vo.setSecondCompanyTypeDesc3("");
                }
                vo.setSecondCompanyType4((String)secondCompanyTypeStr[3]);
                DicGroupItem dicItem4 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", (String)secondCompanyTypeStr[3]);
                if (dicItem4 != null) {
                    vo.setSecondCompanyTypeDesc4(dicItem4.getName());
                } else {
                    vo.setSecondCompanyTypeDesc4("");
                }
                vo.setSecondCompanyType5((String)secondCompanyTypeStr[4]);
                DicGroupItem dicItem5 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", (String)secondCompanyTypeStr[4]);
                if (dicItem5 != null) {
                    vo.setSecondCompanyTypeDesc5(dicItem5.getName());
                } else {
                    vo.setSecondCompanyTypeDesc5("");
                }
            } else {
                for (int i = 1; i <= secondCompanyTypeStr.length; ++i) {
                    if (i == 1) {
                        vo.setSecondCompanyType1((String)secondCompanyTypeStr[0]);
                        DicGroupItem dicItem1 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", (String)secondCompanyTypeStr[0]);
                        if (dicItem1 != null) {
                            vo.setSecondCompanyTypeDesc1(dicItem1.getName());
                            continue;
                        }
                        vo.setSecondCompanyTypeDesc1("");
                        continue;
                    }
                    if (i == 2) {
                        vo.setSecondCompanyType2((String)secondCompanyTypeStr[1]);
                        DicGroupItem dicItem2 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", (String)secondCompanyTypeStr[1]);
                        if (dicItem2 != null) {
                            vo.setSecondCompanyTypeDesc2(dicItem2.getName());
                            continue;
                        }
                        vo.setSecondCompanyTypeDesc2("");
                        continue;
                    }
                    if (i == 3) {
                        vo.setSecondCompanyType3((String)secondCompanyTypeStr[2]);
                        DicGroupItem dicItem3 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", (String)secondCompanyTypeStr[2]);
                        if (dicItem3 != null) {
                            vo.setSecondCompanyTypeDesc3(dicItem3.getName());
                            continue;
                        }
                        vo.setSecondCompanyTypeDesc3("");
                        continue;
                    }
                    if (i == 4) {
                        vo.setSecondCompanyType4((String)secondCompanyTypeStr[3]);
                        DicGroupItem dicItem4 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", (String)secondCompanyTypeStr[3]);
                        if (dicItem4 != null) {
                            vo.setSecondCompanyTypeDesc4(dicItem4.getName());
                            continue;
                        }
                        vo.setSecondCompanyTypeDesc4("");
                        continue;
                    }
                    if (i != 5) continue;
                    vo.setSecondCompanyType5((String)secondCompanyTypeStr[4]);
                    DicGroupItem dicItem5 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", (String)secondCompanyTypeStr[4]);
                    if (dicItem5 != null) {
                        vo.setSecondCompanyTypeDesc5(dicItem5.getName());
                        continue;
                    }
                    vo.setSecondCompanyTypeDesc5("");
                }
            }
        }
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u4e0e\u51c6\u5165\u6d41\u7a0b\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleEnum", required=false, value="\u964c\u751f\u4f9b\u5e94\u5546\uff0c\u5408\u683c\u4f9b\u5e94\u5546\uff08stranger/qualified\uff09", paramType="query", dataType="String", defaultValue="stranger"), @ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="map", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Process", paramType="body", dataType="Map")})
    @RequestMapping(value={"service/findAllCompanyByPages"})
    @ResponseBody
    public ResponseResult<PageView<CompanyProcessVO>> findAllCompanyByPages(@RequestParam(defaultValue="stranger") String roleEnum, @RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) Map<String, Object> queryMap) {
        queryMap.put("pageNo", pageNo);
        queryMap.put("pageSize", pageSize);
        String purCompanyId = CompanyUtils.currentCompanyId();
        PageView<Company> companyPageView = this.processService.queryAllCompnayByPage(purCompanyId, roleEnum, queryMap);
        List<Company> companyList = companyPageView.getQueryResult();
        PageView<CompanyProcessVO> companyProcessPage = new PageView<CompanyProcessVO>(pageNo, pageSize);
        companyProcessPage.setRowCount(companyPageView.getRowCount());
        if (CollectionUtils.isEmpty(companyList)) {
            return ResponseResult.success(companyProcessPage);
        }
        List<CompanyProcessVO> list = this.getSuppliers(companyList);
        companyProcessPage.setQueryResult(list);
        return ResponseResult.success(companyProcessPage);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u4e0e\u51c6\u5165\u6d41\u7a0b\u4fe1\u606f")
    @RequestMapping(value={"service/findCompanyInFo"})
    @ResponseBody
    public ResponseResult<CompanyProcessVO> findCompanyInFo(@RequestParam(required=true) String companyId) {
        Assert.isNotBlank(companyId, "\u4f9b\u5e94\u5546ID\u4e0d\u80fd\u4e3a\u7a7a");
        Company company = (Company)this.companyService.queryObjById(companyId);
        ArrayList<Company> companyList = new ArrayList<Company>();
        companyList.add(company);
        List<CompanyProcessVO> list = this.getSuppliers(companyList);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return ResponseResult.success(list.get(0));
    }

    @ApiOperation(httpMethod="POST", value="\u5408\u683c\u4f9b\u5e94\u5546\u6e05\u5355,\u5bfc\u51faExcel")
    @RequestMapping(value={"service/downloadExcelForPur"})
    @ResponseBody
    public ResponseResult<FileData> downloadExcelForPur(@RequestBody(required=false) Map<String, Object> queryMap) throws IOException, ParseException, WriteException, Exception {
        queryMap.put("pageNo", 1);
        queryMap.put("pageSize", 999);
        String purCompanyId = CompanyUtils.currentCompanyId();
        String params = (String)queryMap.get("queryParams");
        ArrayList<Company> companyList = new ArrayList();
        if (StringUtils.isBlank((String)params)) {
            PageView<Company> companyPageView = this.processService.queryAllCompnayByPage(purCompanyId, PartnerRoleEnum.QUALIFIED.getCode(), queryMap);
            companyList = companyPageView.getQueryResult();
        } else {
            String[] codeList = params.split(",");
            List<String> asList = Arrays.asList(codeList);
            CompanyExample companyExample = new CompanyExample();
            companyExample.createCriteria().andCompanyCodeIn((List)asList).andIsEnableEqualTo(Constant.YES_INT);
            companyList = this.companyService.queryAllObjByExample(companyExample);
        }
        List<Object> list = new ArrayList();
        ArrayList voList = new ArrayList();
        if (CollectionUtils.isNotEmpty(companyList)) {
            list = this.getSuppliers(companyList);
            list.forEach(processVO -> {
                SupplierCompanyVO vo = new SupplierCompanyVO();
                BeanUtils.copyProperties((Object)processVO, (Object)vo);
                vo.setFirstCompanyTypeDesc(CompanyTypeEnum.getValueForCode(processVO.getFirstCompanyType()));
                vo.setIsSendName(AuthenticationEnum.getNameForCode(processVO.getProcess().getIsSend()));
                vo.setAccessProcessName(AccessProcessEnum.getNameForCode(processVO.getProcess().getAccessProcess()));
                vo.setQualificationAuditName(ReviewResultEnum.getNameForCode(processVO.getProcess().getQualificationAudit()));
                vo.setSceneInvestigateName(ReviewResultEnum.getNameForCode(processVO.getProcess().getSceneInvestigate()));
                if (StringUtils.isBlank((String)processVO.getProcess().getProcessName())) {
                    vo.setProcessName("");
                } else {
                    vo.setProcessName(processVO.getProcess().getProcessName());
                }
                voList.add(vo);
            });
        }
        List<TitleAndModelKey> titleAndModelKeys = this.processService.createExcelHeaderForPur();
        FileData fileData = ExcelFileData.createExcelFileOutputStream(titleAndModelKeys, voList, "\u5408\u683c\u4f9b\u5e94\u5546\u6e05\u5355", "\u5408\u683c\u4f9b\u5e94\u5546\u6e05\u5355", 0);
        return ResponseResult.success(fileData);
    }
}

