/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.qualification.service.impl;

import com.els.base.certification.process.entity.Process;
import com.els.base.certification.process.service.ProcessService;
import com.els.base.certification.process.util.AccessProcessEnum;
import com.els.base.certification.process.util.AuthenticationEnum;
import com.els.base.certification.process.util.ReviewResultEnum;
import com.els.base.certification.qualification.dao.QualificationMapper;
import com.els.base.certification.qualification.entity.Qualification;
import com.els.base.certification.qualification.entity.QualificationExample;
import com.els.base.certification.qualification.entity.QualificationItem;
import com.els.base.certification.qualification.entity.QualificationItemExample;
import com.els.base.certification.qualification.service.QualificationItemService;
import com.els.base.certification.qualification.service.QualificationService;
import com.els.base.certification.qualification.util.DocumentStatusEnum;
import com.els.base.certification.qualification.util.QualificationImTemplet;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultQualificationService")
public class QualificationServiceImpl
implements QualificationService {
    private static final String IM_CODE = "ADMITTANCE_QUALIFICATION";
    @Resource
    protected QualificationMapper qualificationMapper;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected GenerateCodeService generateCodeService;
    @Resource
    protected QualificationItemService qualificationItemService;
    @Resource
    protected CompanyUserRefService companyUserRefService;
    @Resource
    protected ProcessService processService;
    @Resource
    private ThreadPoolTaskExecutor defaultThreadPool;

    @Override
    @CacheEvict(value={"qualification"}, allEntries=true)
    public void addObj(Qualification t) {
        this.qualificationMapper.insertSelective(t);
    }

    @Override
    @Transactional
    @CacheEvict(value={"qualification"}, allEntries=true)
    public void insert(User user, Qualification qualification, Company purCompany) {
        QualificationExample example = new QualificationExample();
        example.createCriteria().andDocumentStatusNotEqualTo(DocumentStatusEnum.TERMINATE_AUDIT.getCode()).andIsEnableEqualTo(Constant.YES_INT).andSupCompanySrmCodeEqualTo(qualification.getSupCompanySrmCode());
        if (this.qualificationMapper.countByExample(example) > 0) {
            throw new CommonException("\u4f9b\u5e94\u5546\u7f16\u7801\u4e3a\uff1a" + qualification.getSupCompanySrmCode() + "\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u518d\u521b\u5efa\u5355\u636e");
        }
        this.setSupCompanyInfo(qualification);
        this.setPurCompanyInfo(user, purCompany, qualification);
        this.setOtherInfo(qualification);
        this.qualificationMapper.insertSelective(qualification);
        qualification.getQualificationItemList().forEach(qualificationItem -> {
            Assert.isNotBlank(qualificationItem.getPurFile(), "\u91c7\u8d2d\u65b9\u4e0a\u4f20\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
            if (qualificationItem.getPurFile().length() > 3900) {
                throw new CommonException("\u4e0a\u4f20\u7684\u9644\u4ef6\u4e2a\u6570\u8d85\u957f\uff0c\u8bf7\u51cf\u5c11\u9644\u4ef6\u4e2a\u6570\u540e\u518d\u4fdd\u5b58");
            }
            qualificationItem.setQualificationReviewId(qualification.getId());
            qualificationItem.setPurUploadTime(new Date());
            qualificationItem.setCreateTime(new Date());
            qualificationItem.setCompanyType(Constant.NO_INT);
            this.qualificationItemService.addObj(qualificationItem);
        });
        Process process = this.processService.queryObjByCompanyId(qualification.getSupCompanyId());
        process.setSceneInvestigate("");
        process.setQualificationAudit(ReviewResultEnum.AUDIT.getCode());
        this.processService.modifyObj(process);
    }

    private void setOtherInfo(Qualification qualification) {
        qualification.setIsEnable(Constant.YES_INT);
        qualification.setDocumentStatus(DocumentStatusEnum.UNSENT.getCode());
        qualification.setCreateTime(new Date());
        qualification.setDocumentNo(this.generateCodeService.getNextCode("QUALIFICATION_AUDIT_DOCUMENT_NO"));
    }

    private void setPurCompanyInfo(User user, Company purCompany, Qualification qualification) {
        qualification.setPurCompanyUserId(user.getId());
        qualification.setSinglePerson(user.getNickName());
        qualification.setPurCompanyName(purCompany.getCompanyName());
        qualification.setPurCompanySrmCode(purCompany.getCompanyCode());
    }

    private void setSupCompanyInfo(Qualification qualification) {
        Company company = this.companyService.queryCompanyByCode(qualification.getSupCompanySrmCode());
        qualification.setSupCompanyId(company.getId());
        qualification.setSupCompanyName(company.getCompanyFullName());
        qualification.setSupContacts(company.getContacts());
        qualification.setAddress(company.getAddress());
        User supUser = this.companyUserRefService.queryMainUserOfCompany(company.getId());
        qualification.setSupCompanyUserId(supUser.getId());
        Company t = new Company();
        t.setId(company.getId());
        t.setApproveStatus(Constant.YES_INT);
        this.companyService.modifyObj(t);
    }

    @Override
    @CacheEvict(value={"qualification"}, allEntries=true)
    public void deleteObjById(String id) {
        this.qualificationMapper.deleteByPrimaryKey(id);
    }

    @Override
    @Transactional
    @CacheEvict(value={"qualification"}, allEntries=true)
    public void deleteObjByIds(List<String> ids) {
        QualificationExample example = new QualificationExample();
        example.createCriteria().andIdIn((List)ids).andIsEnableEqualTo(Constant.YES_INT).andDocumentStatusNotEqualTo(DocumentStatusEnum.UNSENT.getCode());
        if (this.qualificationMapper.countByExample(example) > 0) {
            throw new CommonException("\u6240\u9009\u5355\u636e\u4e0d\u5168\u662f\u672a\u53d1\u9001\u5355\u636e\uff0c\u4e0d\u80fd\u6267\u884c\u5220\u9664\u64cd\u4f5c");
        }
        Qualification qualification = new Qualification();
        qualification.setIsEnable(Constant.NO_INT);
        example.clear();
        example.createCriteria().andIdIn((List)ids);
        this.qualificationMapper.updateByExampleSelective(qualification, example);
        this.queryAllObjByExample(example).forEach(qualifications -> {
            Process process = this.processService.queryObjByCompanyId(qualifications.getSupCompanyId());
            process.setQualificationAudit(null);
            this.processService.updateById(process);
        });
    }

    @Override
    @CacheEvict(value={"qualification"}, allEntries=true)
    public void modifyObj(Qualification t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.qualificationMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Transactional
    @CacheEvict(value={"qualification"}, allEntries=true)
    public void purModifyObj(Qualification qualification) {
        if (!DocumentStatusEnum.UNSENT.getCode().equals(qualification.getDocumentStatus())) {
            throw new CommonException("\u4e0d\u662f\u672a\u53d1\u9001\u5355\u636e\uff0c\u4e0d\u80fd\u4fee\u6539");
        }
        Qualification cation = this.qualificationMapper.selectByPrimaryKey(qualification.getId());
        if (!cation.getSupCompanySrmCode().equals(qualification.getSupCompanySrmCode())) {
            QualificationExample qualificationExample = new QualificationExample();
            qualificationExample.createCriteria().andSupCompanySrmCodeEqualTo(qualification.getSupCompanySrmCode()).andDocumentStatusNotEqualTo(DocumentStatusEnum.TERMINATE_AUDIT.getCode()).andIsEnableEqualTo(Constant.YES_INT);
            if (this.qualificationMapper.countByExample(qualificationExample) > 0) {
                throw new CommonException("\u7f16\u7801\u4e3a\uff1a" + qualification.getSupCompanySrmCode() + "\u7684\u4f9b\u5e94\u5546\u5df2\u5b58\u5728\u5355\u636e\uff0c\u4e0d\u80fd\u518d\u521b\u5efa\u5355\u636e");
            }
        }
        this.setSupCompanyInfo(qualification);
        qualification.setUpdateTime(new Date());
        Assert.isNotEmpty(qualification.getQualificationItemList(), "\u8d44\u8d28\u5ba1\u6838\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        this.qualificationMapper.updateByPrimaryKeySelective(qualification);
        QualificationItemExample example = new QualificationItemExample();
        example.createCriteria().andQualificationReviewIdEqualTo(qualification.getId()).andCompanyTypeEqualTo(Constant.NO_INT);
        this.qualificationItemService.deleteByExample(example);
        qualification.getQualificationItemList().forEach(item -> {
            Assert.isNotBlank(item.getPurFile(), "\u91c7\u8d2d\u65b9\u4e0a\u4f20\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
            if (item.getPurFile().length() > 3900) {
                throw new CommonException("\u4e0a\u4f20\u7684\u9644\u4ef6\u4e2a\u6570\u8d85\u957f\uff0c\u8bf7\u51cf\u5c11\u9644\u4ef6\u4e2a\u6570\u540e\u518d\u4fdd\u5b58");
            }
            item.setQualificationReviewId(qualification.getId());
            item.setPurUploadTime(new Date());
            item.setCreateTime(new Date());
            item.setUpdateTime(new Date());
            item.setCompanyType(Constant.NO_INT);
            this.qualificationItemService.addObj(item);
        });
    }

    @Override
    @CacheEvict(value={"qualification"}, allEntries=true)
    public void supModifyObj(Qualification qualification) {
        if (DocumentStatusEnum.WAIT_UPLOAD.getCode().equals(qualification.getDocumentStatus()) || DocumentStatusEnum.REJECT.getCode().equals(qualification.getDocumentStatus())) {
            Qualification quali = this.queryObjById(qualification.getId());
            quali.setSupExplain(qualification.getSupExplain());
            this.qualificationMapper.updateByPrimaryKeySelective(quali);
            for (QualificationItem item : qualification.getQualificationItemList()) {
                if (Constant.NO_INT == item.getCompanyType()) continue;
                QualificationItemExample example = new QualificationItemExample();
                example.createCriteria().andQualificationReviewIdEqualTo(qualification.getId()).andCompanyTypeEqualTo(Constant.YES_INT);
                this.qualificationItemService.deleteByExample(example);
                if (StringUtils.isNotBlank((String)item.getSupFile()) && item.getSupFile().length() > 3900) {
                    throw new CommonException("\u4e0a\u4f20\u7684\u9644\u4ef6\u4e2a\u6570\u8d85\u957f\uff0c\u8bf7\u51cf\u5c11\u9644\u4ef6\u4e2a\u6570\u540e\u518d\u4fdd\u5b58");
                }
                item.setCompanyType(Constant.YES_INT);
                item.setQualificationReviewId(qualification.getId());
                item.setSupUploadTime(new Date());
                item.setCreateTime(new Date());
                item.setUpdateTime(new Date());
                this.qualificationItemService.addObj(item);
            }
        } else {
            throw new CommonException("\u6240\u9009\u5355\u636e\u4e0d\u662f\u5f85\u4e0a\u4f20\u6216\u9a73\u56de\u72b6\u6001\uff0c\u4e0d\u80fd\u6267\u884c\u4fee\u6539\u64cd\u4f5c");
        }
    }

    @Override
    @Cacheable(value={"qualification"}, keyGenerator="redisKeyGenerator")
    public Qualification queryObjById(String id) {
        return this.qualificationMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"qualification"}, keyGenerator="redisKeyGenerator")
    public List<Qualification> queryAllObjByExample(QualificationExample example) {
        return this.qualificationMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"qualification"}, keyGenerator="redisKeyGenerator")
    public PageView<Qualification> queryObjByPage(QualificationExample example) {
        PageView<Qualification> pageView = example.getPageView();
        pageView.setQueryResult(this.qualificationMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"qualification"}, allEntries=true)
    public void purSendToSup(List<String> ids) {
        QualificationExample example = new QualificationExample();
        example.createCriteria().andIdIn((List)ids).andIsEnableEqualTo(Constant.YES_INT).andDocumentStatusNotEqualTo(DocumentStatusEnum.UNSENT.getCode());
        if (this.qualificationMapper.countByExample(example) > 0) {
            throw new CommonException("\u6240\u9009\u5355\u636e\u4e0d\u5168\u662f\u672a\u53d1\u9001\u5355\u636e\uff0c\u4e0d\u80fd\u6267\u884c\u53d1\u9001\u64cd\u4f5c");
        }
        Qualification qualification = new Qualification();
        qualification.setDocumentStatus(DocumentStatusEnum.WAIT_UPLOAD.getCode());
        qualification.setUpdateTime(new Date());
        qualification.setBeforeDocumentStatus(DocumentStatusEnum.UNSENT.getCode());
        example.clear();
        example.createCriteria().andIdIn((List)ids).andIsEnableEqualTo(Constant.YES_INT);
        this.qualificationMapper.updateByExampleSelective(qualification, example);
        final List<Qualification> qualificationList = this.queryAllObjByExample(example);
        Assert.isNotEmpty(qualificationList, "\u91c7\u8d2d\u5546\u5411\u4f9b\u5e94\u5546\u53d1\u9001\u5355\u636e\u662f\u6839\u636e\u5355\u636eID\u67e5\u8be2\u51fa\u7684\u6570\u636e\u4e3a\u7a7a");
        this.defaultThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                qualificationList.forEach(quali -> {
                    QualificationImTemplet templet = QualificationServiceImpl.this.constructImInfo(1, "\u5df2\u53d1\u9001", (Qualification)quali);
                    QualificationServiceImpl.this.sendMessagesToSup(templet, (Qualification)quali);
                });
            }
        });
    }

    @Override
    @Transactional
    @CacheEvict(value={"qualification"}, allEntries=true)
    public void supSendToPur(List<String> ids) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(DocumentStatusEnum.WAIT_REVIEW.getCode());
        list.add(DocumentStatusEnum.THROUGH_AUDIT.getCode());
        list.add(DocumentStatusEnum.TERMINATE_AUDIT.getCode());
        list.add(DocumentStatusEnum.SUPPLEMENTARY_INFORMATION.getCode());
        QualificationExample example = new QualificationExample();
        example.createCriteria().andIdIn((List)ids).andIsEnableEqualTo(Constant.YES_INT).andDocumentStatusIn(list);
        if (this.qualificationMapper.countByExample(example) > 0) {
            throw new CommonException("\u6240\u9009\u5355\u636e\u5305\u542b\u5f85\u5ba1\u6838\u3001\u901a\u8fc7\u5ba1\u6838\u3001\u7ec8\u6b62\u5ba1\u6838\u6216\u5df2\u8865\u8d44\u6599\u5355\u636e\uff0c\u4e0d\u80fd\u6267\u884c\u53d1\u9001\u64cd\u4f5c");
        }
        QualificationItemExample itemExample = new QualificationItemExample();
        itemExample.createCriteria().andQualificationReviewIdIn((List)ids).andCompanyTypeEqualTo(Constant.YES_INT);
        List<QualificationItem> itemList = this.qualificationItemService.queryAllObjByExample(itemExample);
        Assert.isNotEmpty(itemList, "\u53d1\u9001\u7684\u5355\u636e\u6709\u4f9b\u5e94\u5546\u9644\u4ef6\u6ca1\u6709\u4e0a\u4f20");
        itemList.forEach(item -> {
            if (StringUtils.isBlank((String)item.getSupFile()) || "[]".equals(item.getSupFile())) {
                throw new CommonException("\u53d1\u9001\u7684\u5355\u636e\u4e2d\u6709\u7684\u4f9b\u5e94\u5546\u9644\u4ef6\u6ca1\u6709\u4e0a\u4f20");
            }
        });
        example.clear();
        example.createCriteria().andIdIn((List)ids).andIsEnableEqualTo(Constant.YES_INT);
        final List<Qualification> qualificationList = this.queryAllObjByExample(example);
        Assert.isNotEmpty(qualificationList, "\u6839\u636e\u5355\u636eID\u67e5\u8be2\u7684\u5355\u636e\u6570\u636e\u4e3a\u7a7a");
        qualificationList.forEach(qualification -> {
            if (DocumentStatusEnum.WAIT_UPLOAD.getCode().equals(qualification.getDocumentStatus())) {
                qualification.setDocumentStatus(DocumentStatusEnum.WAIT_REVIEW.getCode());
            } else {
                qualification.setDocumentStatus(DocumentStatusEnum.SUPPLEMENTARY_INFORMATION.getCode());
            }
            this.qualificationMapper.updateByPrimaryKeySelective((Qualification)qualification);
        });
        this.defaultThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                qualificationList.forEach(qualification -> {
                    QualificationImTemplet templet = QualificationServiceImpl.this.constructImInfo(2, "\u5df2\u53d1\u9001", (Qualification)qualification);
                    QualificationServiceImpl.this.sendMessagesToPur(templet, (Qualification)qualification);
                });
            }
        });
    }

    @Override
    @Transactional
    @CacheEvict(value={"qualification"}, allEntries=true)
    public void checkObjByIds(List<String> ids) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(DocumentStatusEnum.UNSENT.getCode());
        list.add(DocumentStatusEnum.THROUGH_AUDIT.getCode());
        list.add(DocumentStatusEnum.TERMINATE_AUDIT.getCode());
        list.add(DocumentStatusEnum.REJECT.getCode());
        list.add(DocumentStatusEnum.WAIT_UPLOAD.getCode());
        QualificationExample example = new QualificationExample();
        example.createCriteria().andIdIn((List)ids).andIsEnableEqualTo(Constant.YES_INT).andDocumentStatusIn(list);
        if (this.qualificationMapper.countByExample(example) > 0) {
            throw new CommonException("\u6240\u9009\u5355\u636e\u4e0d\u5168\u662f\u5f85\u5ba1\u6838\u548c\u5df2\u8865\u8d44\u6599\u5355\u636e\uff0c\u4e0d\u80fd\u6267\u884c\u5ba1\u6838\u64cd\u4f5c");
        }
        example.clear();
        example.createCriteria().andIdIn((List)ids).andIsEnableEqualTo(Constant.YES_INT);
        List<Qualification> quaList = this.qualificationMapper.selectByExample(example);
        quaList.stream().forEach(qualifi -> {
            qualifi.setBeforeDocumentStatus(qualifi.getDocumentStatus());
            qualifi.setDocumentStatus(DocumentStatusEnum.THROUGH_AUDIT.getCode());
            this.qualificationMapper.updateByPrimaryKeySelective((Qualification)qualifi);
        });
        final List<Qualification> qualificationList = this.queryAllObjByExample(example);
        Assert.isNotEmpty(qualificationList, "\u6839\u636eID\u67e5\u8be2\u51fa\u7684\u6570\u636e\u4e3a\u7a7a");
        qualificationList.forEach(qualifications -> {
            Process process = this.processService.queryObjByCompanyId(qualifications.getSupCompanyId());
            process.setQualificationAudit(ReviewResultEnum.ADOPT.getCode());
            process.setUpdateTime(new Date());
            this.processService.modifyObj(process);
        });
        this.defaultThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                qualificationList.forEach(quali -> {
                    QualificationImTemplet templet = QualificationServiceImpl.this.constructImInfo(1, "\u5ba1\u6838\u901a\u8fc7", (Qualification)quali);
                    QualificationServiceImpl.this.sendMessagesToSup(templet, (Qualification)quali);
                });
            }
        });
    }

    @Override
    @CacheEvict(value={"qualification"}, allEntries=true)
    public void rejectObjByIds(Qualification qualification) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(DocumentStatusEnum.UNSENT.getCode());
        list.add(DocumentStatusEnum.THROUGH_AUDIT.getCode());
        list.add(DocumentStatusEnum.TERMINATE_AUDIT.getCode());
        list.add(DocumentStatusEnum.REJECT.getCode());
        list.add(DocumentStatusEnum.WAIT_UPLOAD.getCode());
        QualificationExample example = new QualificationExample();
        example.createCriteria().andIdEqualTo(qualification.getId()).andIsEnableEqualTo(Constant.YES_INT).andDocumentStatusIn(list);
        if (this.qualificationMapper.countByExample(example) > 0) {
            throw new CommonException("\u6240\u9009\u5355\u636e\u4e0d\u662f\u5f85\u5ba1\u6838\u548c\u5df2\u8865\u8d44\u6599\u5355\u636e\uff0c\u4e0d\u80fd\u6267\u884c\u9a73\u56de\u64cd\u4f5c");
        }
        Qualification qualifi = this.qualificationMapper.selectByPrimaryKey(qualification.getId());
        qualification.setBeforeDocumentStatus(qualifi.getDocumentStatus());
        qualification.setDocumentStatus(DocumentStatusEnum.REJECT.getCode());
        this.qualificationMapper.updateByPrimaryKeySelective(qualification);
        final List<Qualification> qualificationList = this.queryAllObjByExample(example);
        Assert.isNotEmpty(qualificationList, "\u9a73\u56de\u662f\u6839\u636e\u5355\u636eID\u67e5\u8be2\u51fa\u7684\u5355\u636e\u6570\u636e\u4e3a\u7a7a");
        this.defaultThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                qualificationList.forEach(quali -> {
                    QualificationImTemplet templet = QualificationServiceImpl.this.constructImInfo(1, "\u5df2\u9a73\u56de", (Qualification)quali);
                    QualificationServiceImpl.this.sendMessagesToSup(templet, (Qualification)quali);
                });
            }
        });
    }

    @Override
    @Transactional
    @CacheEvict(value={"qualification"}, allEntries=true)
    public void revokeObjByIds(List<String> ids) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(DocumentStatusEnum.SUPPLEMENTARY_INFORMATION.getCode());
        list.add(DocumentStatusEnum.UNSENT.getCode());
        list.add(DocumentStatusEnum.WAIT_REVIEW.getCode());
        QualificationExample example = new QualificationExample();
        example.createCriteria().andIdIn((List)ids).andIsEnableEqualTo(Constant.YES_INT).andDocumentStatusIn(list);
        if (this.qualificationMapper.countByExample(example) > 0) {
            throw new CommonException("\u6240\u9009\u5355\u636e\u4e2d\u5305\u542b\u672a\u53d1\u9001\u3001\u5f85\u5ba1\u6838\u3001\u5df2\u8865\u8d44\u6599\u7684\u5355\u636e\uff0c\u64cd\u4f5c\u5931\u8d25");
        }
        example.clear();
        example.createCriteria().andIdIn((List)ids).andIsEnableEqualTo(Constant.YES_INT);
        List<Qualification> quaList = this.qualificationMapper.selectByExample(example);
        quaList.stream().forEach(qualifi -> {
            if (StringUtils.isBlank((String)qualifi.getBeforeDocumentStatus())) {
                throw new CommonException("\u5355\u636e\u53f7\u4e3a\uff1a" + qualifi.getDocumentNo() + "\u7684\u5355\u636e\u5df2\u6267\u884c\u4e00\u6b21\u64a4\u56de\u64cd\u4f5c\uff0c\u4e0d\u80fd\u518d\u91cd\u590d\u64cd\u4f5c");
            }
            Process process = this.processService.queryObjByCompanyId(qualifi.getSupCompanyId());
            if (process.getIsSend() != AuthenticationEnum.UNCERTIFIED.getCode()) {
                throw new CommonException("\u4f9b\u5e94\u5546:" + qualifi.getSupCompanySrmCode() + "\u5df2\u53d1\u9001\u5ba1\u6279\u8ba4\u8bc1\uff0c\u4e0d\u80fd\u518d\u6267\u884c\u64a4\u56de\u64cd\u4f5c");
            }
            if (process.getAccessProcess().equals(AccessProcessEnum.QUALIFICATION_AND_SCENE_REVIEW.getCode()) && StringUtils.isNotBlank((String)process.getSceneInvestigate())) {
                throw new CommonException("\u4f9b\u5e94\u5546:" + qualifi.getSupCompanySrmCode() + "\u7684\u73b0\u573a\u8003\u5bdf\u5df2\u5f00\u59cb\uff0c\u4e0d\u80fd\u518d\u6267\u884c\u64a4\u56de\u64cd\u4f5c");
            }
            if (qualifi.getDocumentStatus().equals(DocumentStatusEnum.TERMINATE_AUDIT.getCode())) {
                example.clear();
                example.createCriteria().andDocumentStatusNotEqualTo(DocumentStatusEnum.TERMINATE_AUDIT.getCode()).andIsEnableEqualTo(Constant.YES_INT).andSupCompanySrmCodeEqualTo(qualifi.getSupCompanySrmCode());
                if (this.qualificationMapper.countByExample(example) > 0) {
                    throw new CommonException("\u4f9b\u5e94\u5546\uff1a" + qualifi.getSupCompanySrmCode() + "\u5df2\u91cd\u65b0\u521b\u5efa\u4e86\u5355\u636e\uff0c\u4e0d\u80fd\u518d\u6267\u884c\u64a4\u56de\u64cd\u4f5c");
                }
            }
            if (qualifi.getDocumentStatus().equals(DocumentStatusEnum.THROUGH_AUDIT.getCode()) || qualifi.getDocumentStatus().equals(DocumentStatusEnum.TERMINATE_AUDIT.getCode())) {
                process.setQualificationAudit(ReviewResultEnum.AUDIT.getCode());
                process.setUpdateTime(new Date());
                this.processService.modifyObj(process);
            }
            qualifi.setDocumentStatus(qualifi.getBeforeDocumentStatus());
            qualifi.setBeforeDocumentStatus("");
            this.qualificationMapper.updateByPrimaryKeySelective((Qualification)qualifi);
        });
    }

    @Override
    @Transactional
    @CacheEvict(value={"qualification"}, allEntries=true)
    public void terminationAuditObjByIds(List<String> ids) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(DocumentStatusEnum.UNSENT.getCode());
        list.add(DocumentStatusEnum.THROUGH_AUDIT.getCode());
        list.add(DocumentStatusEnum.TERMINATE_AUDIT.getCode());
        list.add(DocumentStatusEnum.REJECT.getCode());
        list.add(DocumentStatusEnum.WAIT_UPLOAD.getCode());
        QualificationExample example = new QualificationExample();
        example.createCriteria().andIdIn((List)ids).andIsEnableEqualTo(Constant.YES_INT).andDocumentStatusIn(list);
        if (this.qualificationMapper.countByExample(example) > 0) {
            throw new CommonException("\u6240\u9009\u5355\u636e\u4e0d\u5168\u662f\u5f85\u5ba1\u6838\u548c\u5df2\u8865\u8d44\u6599\u5355\u636e\uff0c\u4e0d\u80fd\u6267\u884c\u7ec8\u6b62\u5ba1\u6838\u64cd\u4f5c");
        }
        example.clear();
        example.createCriteria().andIdIn((List)ids).andIsEnableEqualTo(Constant.YES_INT);
        List<Qualification> quaList = this.qualificationMapper.selectByExample(example);
        quaList.stream().forEach(qualifi -> {
            qualifi.setBeforeDocumentStatus(qualifi.getDocumentStatus());
            qualifi.setDocumentStatus(DocumentStatusEnum.TERMINATE_AUDIT.getCode());
            this.qualificationMapper.updateByPrimaryKeySelective((Qualification)qualifi);
        });
        final List<Qualification> qualificationList = this.queryAllObjByExample(example);
        Assert.isNotEmpty(qualificationList, "\u6839\u636e\u5355\u636eID\u67e5\u8be2\u7684\u5355\u636e\u4e3a\u7a7a");
        qualificationList.forEach(qualifications -> {
            Process process = this.processService.queryObjByCompanyId(qualifications.getSupCompanyId());
            process.setQualificationAudit(ReviewResultEnum.TERMINATION.getCode());
            process.setUpdateTime(new Date());
            this.processService.modifyObj(process);
        });
        this.defaultThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                qualificationList.forEach(quali -> {
                    QualificationImTemplet templet = QualificationServiceImpl.this.constructImInfo(1, "\u7ec8\u6b62\u5f00\u53d1", (Qualification)quali);
                    QualificationServiceImpl.this.sendMessagesToSup(templet, (Qualification)quali);
                });
            }
        });
    }

    protected void sendMessagesToSup(QualificationImTemplet templet, Qualification qualification) {
        Message message = Message.init((Object)templet).setBusinessTypeCode(IM_CODE).setCompanyCode(qualification.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(qualification.getPurCompanyUserId()).addReceiverId(qualification.getSupCompanyUserId());
        MessageSendUtils.sendMessage((Message)message);
    }

    protected void sendMessagesToPur(QualificationImTemplet templet, Qualification qualification) {
        Message message = Message.init((Object)templet).setBusinessTypeCode(IM_CODE).setCompanyCode(qualification.getSupCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(qualification.getSupCompanyUserId()).addReceiverId(qualification.getPurCompanyUserId());
        MessageSendUtils.sendMessage((Message)message);
    }

    protected QualificationImTemplet constructImInfo(int role, String operate, Qualification qualification) {
        Assert.isNotNull(qualification, "\u53d1\u9001\u7684\u6570\u636e\u4e3a\u7a7a");
        QualificationImTemplet qualificationImTemplet = new QualificationImTemplet();
        if (1 == role) {
            qualificationImTemplet.setRole("\u91c7\u8d2d\u5546");
            if (StringUtils.isNotBlank((String)qualification.getPurCompanyName())) {
                qualificationImTemplet.setCompanyName(qualification.getPurCompanyName());
            } else {
                qualificationImTemplet.setCompanyName("");
            }
        } else {
            qualificationImTemplet.setRole("\u4f9b\u5e94\u5546");
            if (StringUtils.isNotBlank((String)qualification.getSupCompanyName())) {
                qualificationImTemplet.setCompanyName(qualification.getSupCompanyName());
            } else {
                qualificationImTemplet.setCompanyName("");
            }
        }
        Assert.isNotBlank(operate, "\u64cd\u4f5c\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u53d1\u9001\u6d88\u606f");
        qualificationImTemplet.setOperate(operate);
        qualificationImTemplet.setOtherInfo("\u4e86\u8d44\u8d28\u5ba1\u6838\u5355\u636e\uff0c\u5355\u636e\u53f7\u4e3a\uff1a");
        qualificationImTemplet.setBillList(qualification.getDocumentNo());
        return qualificationImTemplet;
    }
}

