/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.qualification.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.certification.qualification.entity.Qualification;
import com.els.base.certification.qualification.entity.QualificationExample;
import com.els.base.certification.qualification.entity.QualificationItem;
import com.els.base.certification.qualification.entity.QualificationItemExample;
import com.els.base.certification.qualification.service.QualificationItemService;
import com.els.base.certification.qualification.service.QualificationService;
import com.els.base.certification.qualification.util.DocumentStatusEnum;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u4f9b\u5e94\u5546\u51c6\u5165-\u8d44\u8d28\u5ba1\u6838\u5355")
@Controller
@RequestMapping(value={"qualification"})
public class QualificationController {
    @Resource
    protected QualificationService qualificationService;
    @Resource
    protected QualificationItemService qualificationItemService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u4f9b\u5e94\u5546\u51c6\u5165-\u8d44\u8d28\u5ba1\u6838\u5355")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody Qualification qualification) {
        Assert.isNotNull(qualification, "\u4fdd\u5b58\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(qualification.getSupCompanySrmCode(), "\u4f9b\u5e94\u5546SRM\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(qualification.getQualificationItemList(), "\u8d44\u8d28\u5ba1\u6838\u6587\u4ef6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        com.els.base.auth.entity.User user = SpringSecurityUtils.getLoginUser();
        this.qualificationService.insert((User)user, qualification, CompanyUtils.currentCompany());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u4f9b\u5e94\u5546\u51c6\u5165-\u8d44\u8d28\u5ba1\u6838\u5355")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody Qualification qualification) {
        Assert.isNotBlank(qualification.getId(), "id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.qualificationService.modifyObj(qualification);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u65b9\u7f16\u8f91\u4f9b\u5e94\u5546\u51c6\u5165-\u8d44\u8d28\u5ba1\u6838\u5355")
    @RequestMapping(value={"service/purEdit"})
    @ResponseBody
    public ResponseResult<String> purEdit(@RequestBody Qualification qualification) {
        Assert.isNotBlank(qualification.getId(), "id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        Assert.isNotBlank(qualification.getSupCompanySrmCode(), "\u4f9b\u5e94\u5546SRM\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        this.qualificationService.purModifyObj(qualification);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u4fee\u6539\u4f9b\u5e94\u5546\u51c6\u5165-\u8d44\u8d28\u5ba1\u6838\u5355")
    @RequestMapping(value={"service/supEdit"})
    @ResponseBody
    public ResponseResult<String> supEdit(@RequestBody Qualification qualification) {
        Assert.isNotBlank(qualification.getId(), "id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        Assert.isNotBlank(qualification.getSupCompanySrmCode(), "\u4f9b\u5e94\u5546SRM\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        this.qualificationService.supModifyObj(qualification);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u65b9\u6279\u91cf\u5220\u9664\u4f9b\u5e94\u5546\u51c6\u5165-\u8d44\u8d28\u5ba1\u6838\u5355")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, "\u4f20\u5165\u7684\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
        this.qualificationService.deleteObjByIds(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546\u67e5\u8be2\u4f9b\u5e94\u5546\u51c6\u5165-\u8d44\u8d28\u5ba1\u6838\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Qualification", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/pur/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<Qualification>> purFindByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        QualificationExample example = new QualificationExample();
        example.setPageView(new PageView<Qualification>(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        QualificationExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andPurCompanyUserIdEqualTo(SpringSecurityUtils.getLoginUser().getId());
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView pageData = this.qualificationService.queryObjByPage(example);
        pageData.getQueryResult().forEach(qualification -> {
            QualificationItemExample itemExample = new QualificationItemExample();
            itemExample.createCriteria().andQualificationReviewIdEqualTo(qualification.getId());
            List<QualificationItem> itemList = this.qualificationItemService.queryAllObjByExample(itemExample);
            qualification.setQualificationItemList(itemList);
        });
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u67e5\u8be2\u4f9b\u5e94\u5546\u51c6\u5165-\u8d44\u8d28\u5ba1\u6838\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Qualification", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/sup/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<Qualification>> supFindByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        QualificationExample example = new QualificationExample();
        example.setPageView(new PageView<Qualification>(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        QualificationExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andDocumentStatusNotEqualTo(DocumentStatusEnum.UNSENT.getCode());
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView pageData = this.qualificationService.queryObjByPage(example);
        pageData.getQueryResult().forEach(data -> {
            QualificationItemExample itemExample = new QualificationItemExample();
            itemExample.createCriteria().andQualificationReviewIdEqualTo(data.getId());
            List<QualificationItem> itemList = this.qualificationItemService.queryAllObjByExample(itemExample);
            data.setQualificationItemList(itemList);
        });
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546\u67e5\u770b\u5355\u636e\u8be6\u60c5-\u8d44\u8d28\u5ba1\u6838\u5355")
    @RequestMapping(value={"service/pur/findQualificationById"})
    @ResponseBody
    public ResponseResult<Qualification> purFindQualificationById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
        Qualification qualification = (Qualification)this.qualificationService.queryObjById(id);
        Assert.isNotNull(qualification, "\u6839\u636eID\u67e5\u8be2\u7684\u6570\u636e\u4e3a\u7a7a");
        QualificationItemExample qualificationItemExample = new QualificationItemExample();
        qualificationItemExample.setOrderByClause("CREATE_TIME DESC");
        if (DocumentStatusEnum.UNSENT.getCode().equals(qualification.getDocumentStatus()) || DocumentStatusEnum.WAIT_UPLOAD.getCode().equals(qualification.getDocumentStatus()) || DocumentStatusEnum.REJECT.getCode().equals(qualification.getDocumentStatus())) {
            qualificationItemExample.createCriteria().andQualificationReviewIdEqualTo(id).andCompanyTypeEqualTo(Constant.NO_INT);
            qualification.setQualificationItemList(this.qualificationItemService.queryAllObjByExample(qualificationItemExample));
        } else {
            qualificationItemExample.createCriteria().andQualificationReviewIdEqualTo(id);
            qualification.setQualificationItemList(this.qualificationItemService.queryAllObjByExample(qualificationItemExample));
        }
        return ResponseResult.success(qualification);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u67e5\u770b\u5355\u636e\u8be6\u60c5-\u8d44\u8d28\u5ba1\u6838\u5355")
    @RequestMapping(value={"service/sup/findQualificationById"})
    @ResponseBody
    public ResponseResult<Qualification> supFindQualificationById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
        Qualification qualification = (Qualification)this.qualificationService.queryObjById(id);
        Assert.isNotNull(qualification, "\u6839\u636eID\u67e5\u8be2\u7684\u6570\u636e\u4e3a\u7a7a");
        QualificationItemExample qualificationItemExample = new QualificationItemExample();
        qualificationItemExample.setOrderByClause("CREATE_TIME DESC");
        qualificationItemExample.createCriteria().andQualificationReviewIdEqualTo(id);
        List<QualificationItem> itemList = this.qualificationItemService.queryAllObjByExample(qualificationItemExample);
        qualification.setQualificationItemList(itemList);
        return ResponseResult.success(qualification);
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546\u6279\u91cf\u53d1\u9001\u4f9b\u5e94\u5546\u51c6\u5165-\u8d44\u8d28\u5ba1\u6838\u5355")
    @RequestMapping(value={"service/purSendByIds"})
    @ResponseBody
    public ResponseResult<String> purSendByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, "\u53d1\u9001\u5355\u636e\u7684ID\u4e0d\u80fd\u4e3a\u7a7a");
        this.qualificationService.purSendToSup(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u6279\u91cf\u53d1\u9001\u4f9b\u5e94\u5546\u51c6\u5165-\u8d44\u8d28\u5ba1\u6838\u5355")
    @RequestMapping(value={"service/supSendByIds"})
    @ResponseBody
    public ResponseResult<String> supSendByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, "\u53d1\u9001\u5355\u636e\u7684ID\u4e0d\u80fd\u4e3a\u7a7a");
        this.qualificationService.supSendToPur(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546\u6279\u91cf\u5ba1\u6838\u4f9b\u5e94\u5546\u51c6\u5165-\u8d44\u8d28\u5ba1\u6838\u5355")
    @RequestMapping(value={"service/checkByIds"})
    @ResponseBody
    public ResponseResult<String> checkByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, "\u5ba1\u6838\u7684\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
        this.qualificationService.checkObjByIds(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546\u9a73\u56de\u4f9b\u5e94\u5546\u51c6\u5165-\u8d44\u8d28\u5ba1\u6838\u5355")
    @RequestMapping(value={"service/rejectById"})
    @ResponseBody
    public ResponseResult<String> rejectById(@RequestBody(required=true) Qualification qualification) {
        Assert.isNotNull(qualification, "\u9a73\u56de\u53d1\u9001\u5355\u636e\u7684\u6570\u636e\u4e3a\u7a7a");
        Assert.isNotBlank(qualification.getId(), "\u8981\u9a73\u56de\u7684\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank(qualification.getRejectReason(), "\u9a73\u56de\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a");
        this.qualificationService.rejectObjByIds(qualification);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546\u6279\u91cf\u7ec8\u6b62\u5ba1\u6838\u4f9b\u5e94\u5546\u51c6\u5165-\u8d44\u8d28\u5ba1\u6838\u5355")
    @RequestMapping(value={"service/terminationAuditByIds"})
    @ResponseBody
    public ResponseResult<String> terminationAuditByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, "\u8981\u7ec8\u6b62\u7684\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
        this.qualificationService.terminationAuditObjByIds(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546\u6279\u91cf\u64a4\u56de\u4f9b\u5e94\u5546\u51c6\u5165-\u8d44\u8d28\u5ba1\u6838\u5355")
    @RequestMapping(value={"service/revokeByIds"})
    @ResponseBody
    public ResponseResult<String> revokeByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, "\u8981\u64a4\u56de\u7684\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
        this.qualificationService.revokeObjByIds(ids);
        return ResponseResult.success();
    }
}

