/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.recommend.service.impl;

import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.RoleExample;
import com.els.base.auth.entity.User;
import com.els.base.auth.entity.UserRole;
import com.els.base.auth.entity.UserRoleExample;
import com.els.base.auth.service.RoleService;
import com.els.base.auth.service.UserRoleService;
import com.els.base.certification.common.ConfirmStatusEnum;
import com.els.base.certification.common.DocumentStatusEnum;
import com.els.base.certification.contacts.entity.Contacts;
import com.els.base.certification.contacts.entity.ContactsExample;
import com.els.base.certification.contacts.service.ContactsService;
import com.els.base.certification.recommend.dao.CompanyRecommendFormMapper;
import com.els.base.certification.recommend.entity.CompanyRecommendForm;
import com.els.base.certification.recommend.entity.CompanyRecommendFormExample;
import com.els.base.certification.recommend.service.CompanyRecommendFormService;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.entity.CompanyPartner;
import com.els.base.company.entity.CompanyPartnerExample;
import com.els.base.company.entity.CompanyUserRef;
import com.els.base.company.entity.CompanyUserRefExample;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.company.utils.PartnerRoleEnum;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.file.entity.FileData;
import com.els.base.file.utils.FileDataUtils;
import com.els.base.utils.pdf.HtmlToPdfUtils;
import com.els.base.utils.template.BeetlTemplateUtils;
import com.els.base.workflow.common.entity.ProcessStartVO;
import com.els.base.workflow.common.event.TaskOperateEvent;
import com.els.base.workflow.common.service.ITaskListener;
import com.els.base.workflow.common.service.WorkFlowService;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultCompanyRecommendFormService")
public class CompanyRecommendFormServiceImpl
implements CompanyRecommendFormService,
ITaskListener {
    @Resource
    private CompanyRecommendFormMapper companyRecommendFormMapper;
    @Resource
    private CompanyService companyService;
    @Resource
    private GenerateCodeService generateCodeService;
    @Resource
    private RoleService roleService;
    @Resource
    private CompanyUserRefService companyUserRefService;
    @Resource
    private UserRoleService userRoleService;
    @Resource
    private WorkFlowService workFlowService;
    @Resource
    private ContactsService contactsService;

    @Override
    @CacheEvict(value={"companyRecommendForm"}, allEntries=true)
    @Transactional
    public FileData print(Project project, Company company, List<CompanyRecommendForm> companyRecommendFormList) {
        List<String> ids = this.checkRecommendFormData(companyRecommendFormList);
        List<CompanyRecommendForm> printDataList = this.findByCompanyRecommendFormIds(ids);
        FileData fileData = null;
        try {
            fileData = this.printCompanyRecommendForm(project, company, printDataList);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CommonException("\u6253\u5370\u5931\u8d25\uff01");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new CommonException("\u6253\u5370\u5931\u8d25\uff01");
        }
        return fileData;
    }

    private FileData printCompanyRecommendForm(Project project, Company company, List<CompanyRecommendForm> printDataList) throws IOException, InterruptedException {
        Assert.isNotEmpty(printDataList, "\u6253\u5370\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25\uff01");
        HashMap<String, List<CompanyRecommendForm>> params = new HashMap<String, List<CompanyRecommendForm>>();
        params.put("printDataList", printDataList);
        String html = BeetlTemplateUtils.renderFromFile((String)"company_recommend_form.html", params);
        String fileName = "\u5408\u683c\u4f9b\u5e94\u5546\u5bfc\u5165\u8868_A4_" + DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd-HH-mm");
        FileData fileData = FileDataUtils.createTempEmptyPDF((String)project.getId(), (String)company.getId(), (String)fileName);
        HtmlToPdfUtils.generatePdf((String)html, (File)fileData.toFile(), (String)"A4", (boolean)false, (String)fileName);
        return fileData;
    }

    private List<CompanyRecommendForm> findByCompanyRecommendFormIds(List<String> ids) {
        Assert.isNotEmpty(ids, "Id\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25\uff01");
        CompanyRecommendFormExample companyRecommendFormExample = new CompanyRecommendFormExample();
        companyRecommendFormExample.createCriteria().andIdIn((List)ids);
        List<CompanyRecommendForm> printDataList = this.companyRecommendFormMapper.selectByExample(companyRecommendFormExample);
        for (CompanyRecommendForm f : printDataList) {
            ContactsExample contactsExample = new ContactsExample();
            contactsExample.createCriteria().andSupCompanyIdEqualTo(f.getSupCompanyId());
            List<Contacts> contactsList = this.contactsService.queryAllObjByExample(contactsExample);
            f.setContactsList(contactsList);
        }
        return printDataList;
    }

    private List<String> checkRecommendFormData(List<CompanyRecommendForm> companyRecommendFormList) {
        ArrayList<String> ids = new ArrayList<String>();
        Assert.isNotEmpty(companyRecommendFormList, "\u6253\u5370\u6570\u636e\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25\uff01");
        for (CompanyRecommendForm companyRecommendForm : companyRecommendFormList) {
            Assert.isNotBlank(companyRecommendForm.getId(), "Id\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25\uff01");
            ids.add(companyRecommendForm.getId());
        }
        return ids;
    }

    @Override
    @CacheEvict(value={"companyRecommendForm"}, allEntries=true)
    @Transactional
    public void listen(TaskOperateEvent event) {
        if (event == null) {
            return;
        }
        String businessId = event.getBusinessId();
        if (StringUtils.isBlank((String)businessId)) {
            return;
        }
        CompanyRecommendForm companyRecommendForm = this.companyRecommendFormMapper.selectByPrimaryKey(businessId);
        String assignee = event.getAssignee();
        String fullMessage = event.getApproveDesc();
        if (event.isFinished() && event.isPass()) {
            companyRecommendForm.setApproveTime(new Date());
            companyRecommendForm.setApproveStatus(Integer.valueOf(DocumentStatusEnum.AUDITED.getCode()));
            companyRecommendForm.setApproveUserName(StringUtils.defaultIfBlank((String)companyRecommendForm.getApproveUserName(), (String)"") + "\n" + assignee);
            companyRecommendForm.setApproveResult(fullMessage);
            companyRecommendForm.setCurrentApprover(assignee);
            this.companyRecommendFormMapper.updateByPrimaryKeySelective(companyRecommendForm);
            this.switchQualifiedRole(companyRecommendForm.getSupCompanyId());
        } else if (event.isFinished() && !event.isPass()) {
            companyRecommendForm.setApproveTime(new Date());
            companyRecommendForm.setApproveStatus(Integer.valueOf(DocumentStatusEnum.DISMISSAL.getCode()));
            companyRecommendForm.setApproveUserName(StringUtils.defaultIfBlank((String)companyRecommendForm.getApproveUserName(), (String)"") + "\n" + assignee);
            companyRecommendForm.setApproveResult(fullMessage);
            companyRecommendForm.setCurrentApprover(assignee);
            this.companyRecommendFormMapper.updateByPrimaryKeySelective(companyRecommendForm);
        } else {
            companyRecommendForm.setApproveTime(new Date());
            companyRecommendForm.setApproveUserName(StringUtils.defaultIfBlank((String)companyRecommendForm.getApproveUserName(), (String)"") + "\n" + assignee);
            companyRecommendForm.setApproveResult(fullMessage);
            companyRecommendForm.setCurrentApprover(assignee);
            this.companyRecommendFormMapper.updateByPrimaryKeySelective(companyRecommendForm);
        }
    }

    @Override
    @CacheEvict(value={"companyRecommendForm"}, allEntries=true)
    @Transactional
    public void approve(Project project, Company company, User loginUser, List<CompanyRecommendForm> companyRecommendFormList) {
        this.checkRecommendFormData(project, companyRecommendFormList);
        for (CompanyRecommendForm companyRecommendForm : companyRecommendFormList) {
            ProcessStartVO vo = ProcessStartVO.newInstance("hggysdrtjb", companyRecommendForm.getRecommendNo(), companyRecommendForm.getId(), "qualifiedSupIntroduct?id=" + companyRecommendForm.getId());
            vo.setListenerClass(this.getClass());
            ProcessInstance startProcess = this.workFlowService.startProcess(vo);
            if (startProcess == null) continue;
            CompanyRecommendForm companyRecommendForm1 = new CompanyRecommendForm();
            companyRecommendForm1.setId(companyRecommendForm.getId());
            companyRecommendForm1.setApproveStatus(Integer.valueOf(DocumentStatusEnum.BEING_AUDITED.getCode()));
            companyRecommendForm1.setApproveTime(new Date());
            this.companyRecommendFormMapper.updateByPrimaryKeySelective(companyRecommendForm1);
        }
    }

    private void checkRecommendFormData(Project project, List<CompanyRecommendForm> companyRecommendFormList) {
        if (CollectionUtils.isEmpty(companyRecommendFormList)) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e");
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (CompanyRecommendForm companyRecommendForm : companyRecommendFormList) {
            if (StringUtils.isBlank((String)companyRecommendForm.getId())) {
                throw new CommonException("\u6570\u636eID\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636eID");
            }
            if (StringUtils.isBlank((String)companyRecommendForm.getSupCompanyId())) {
                throw new CommonException("\u4f9b\u5e94\u5546ID\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u64cd\u4f5c\u5931\u8d25\uff0c\u4f9b\u5e94\u5546ID");
            }
            ids.add(companyRecommendForm.getId());
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(Integer.valueOf(DocumentStatusEnum.AUDITED.getCode()));
        list.add(Integer.valueOf(DocumentStatusEnum.DISMISSAL.getCode()));
        CompanyRecommendFormExample companyRecommendFormExample = new CompanyRecommendFormExample();
        companyRecommendFormExample.createCriteria().andIdIn(ids).andPurCompanyIdEqualTo(project.getCompanyId()).andApproveStatusIn(list).andProjectIdEqualTo(project.getId());
        int count = this.companyRecommendFormMapper.countByExample(companyRecommendFormExample);
        if (count > 0) {
            throw new CommonException("\u5355\u636e\u4e2d\u5305\u542b\u5df2\u9a73\u56de\u6216\u8005\u5df2\u7ecf\u5ba1\u6838\u901a\u8fc7\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5!");
        }
    }

    private void switchQualifiedRole(String companyId) {
        CompanyPartnerExample example = new CompanyPartnerExample();
        example.createCriteria().andPartnerCompanyIdEqualTo(companyId);
        CompanyPartner companyPartner = new CompanyPartner();
        companyPartner.setPartnerRoleCode(PartnerRoleEnum.QUALIFIED.getCode());
        companyPartner.setPartnerRoleName(PartnerRoleEnum.QUALIFIED.getName());
        this.companyService.updatePartnerRole(companyPartner, example);
        RoleExample roleExample = new RoleExample();
        roleExample.createCriteria().andRoleCodeEqualTo(PartnerRoleEnum.QUALIFIED.getUserRoleCode());
        List list = this.roleService.queryAllObjByExample((IExample)roleExample);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            CompanyUserRefExample companyUserExample = new CompanyUserRefExample();
            companyUserExample.createCriteria().andCompanyIdEqualTo(companyId);
            List companyUserRef = this.companyUserRefService.queryAllObjByExample(companyUserExample);
            UserRoleExample userRoleExample = new UserRoleExample();
            userRoleExample.createCriteria().andUserIdEqualTo(((CompanyUserRef)companyUserRef.get(0)).getUserId());
            List userRole = this.userRoleService.queryAllObjByExample((IExample)userRoleExample);
            for (UserRole ur : userRole) {
                for (Role role : list) {
                    ur.setRoleId(role.getId());
                    ur.setCreateTime(new Date());
                    this.userRoleService.modifyObj((Serializable)ur);
                }
            }
        }
    }

    @Override
    @CacheEvict(value={"companyRecommendForm"}, allEntries=true)
    @Transactional
    public void reject(Project project, Company company, List<CompanyRecommendForm> companyRecommendFormList) {
        if (CollectionUtils.isEmpty(companyRecommendFormList)) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e");
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (CompanyRecommendForm companyRecommendForm : companyRecommendFormList) {
            if (StringUtils.isBlank((String)companyRecommendForm.getId())) {
                throw new CommonException("\u6570\u636eID\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636eID");
            }
            ids.add(companyRecommendForm.getId());
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(Integer.valueOf(DocumentStatusEnum.NOT_AUDITED.getCode()));
        list.add(Integer.valueOf(DocumentStatusEnum.AUDITED.getCode()));
        list.add(Integer.valueOf(DocumentStatusEnum.DISMISSAL.getCode()));
        CompanyRecommendFormExample companyRecommendFormExample = new CompanyRecommendFormExample();
        companyRecommendFormExample.createCriteria().andIdIn(ids).andPurCompanyIdEqualTo(project.getCompanyId()).andApproveStatusIn(list).andProjectIdEqualTo(project.getId());
        int count = this.companyRecommendFormMapper.countByExample(companyRecommendFormExample);
        if (count > 0) {
            throw new CommonException("\u5355\u636e\u4e2d\u5305\u542b\u672a\u63d0\u4ea4\u5ba1\u6838\u3001\u5df2\u9a73\u56de\u6216\u8005\u5df2\u7ecf\u5ba1\u6838\u901a\u8fc7\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5!");
        }
        companyRecommendFormExample.clear();
        companyRecommendFormExample.createCriteria().andIdIn(ids).andPurCompanyIdEqualTo(project.getCompanyId()).andApproveStatusEqualTo(Integer.valueOf(DocumentStatusEnum.BEING_AUDITED.getCode())).andProjectIdEqualTo(project.getId());
        CompanyRecommendForm companyRecommendForm = new CompanyRecommendForm();
        companyRecommendForm.setApproveStatus(Integer.valueOf(DocumentStatusEnum.DISMISSAL.getCode()));
        this.companyRecommendFormMapper.updateByExampleSelective(companyRecommendForm, companyRecommendFormExample);
    }

    @Override
    @CacheEvict(value={"companyRecommendForm"}, allEntries=true)
    @Transactional
    public void sendApprove(Project project, Company company, User loginUser, List<CompanyRecommendForm> companyRecommendFormList) {
        if (CollectionUtils.isEmpty(companyRecommendFormList)) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e");
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (CompanyRecommendForm companyRecommendForm : companyRecommendFormList) {
            if (StringUtils.isBlank((String)companyRecommendForm.getId())) {
                throw new CommonException("\u6570\u636eID\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636eID");
            }
            ids.add(companyRecommendForm.getId());
        }
        CompanyRecommendFormExample companyRecommendFormExample = new CompanyRecommendFormExample();
        companyRecommendFormExample.createCriteria().andIdIn(ids).andPurCompanyIdEqualTo(project.getCompanyId()).andConfirmStatusEqualTo(ConfirmStatusEnum.STATUS_ABOLISH.getStatus()).andProjectIdEqualTo(project.getId());
        int count = this.companyRecommendFormMapper.countByExample(companyRecommendFormExample);
        if (count > 0) {
            throw new CommonException("\u5355\u636e\u4e2d\u5305\u542b\u5df2\u4f5c\u5e9f\u6570\u636e\uff0c\u4e0d\u80fd\u518d\u64cd\u4f5c!");
        }
        ArrayList<Integer> theseElements = new ArrayList<Integer>();
        theseElements.add(Integer.valueOf(DocumentStatusEnum.BEING_AUDITED.getCode()));
        theseElements.add(Integer.valueOf(DocumentStatusEnum.AUDITED.getCode()));
        theseElements.add(Integer.valueOf(DocumentStatusEnum.DISMISSAL.getCode()));
        companyRecommendFormExample.clear();
        companyRecommendFormExample.createCriteria().andIdIn(ids).andPurCompanyIdEqualTo(project.getCompanyId()).andApproveStatusIn(theseElements).andProjectIdEqualTo(project.getId());
        int count2 = this.companyRecommendFormMapper.countByExample(companyRecommendFormExample);
        if (count2 > 0) {
            throw new CommonException("\u5355\u636e\u4e2d\u5305\u542b\u6b63\u5728\u5ba1\u6838\u6216\u8005\u5df2\u5ba1\u6838,\u5df2\u9a73\u56de\u7684\u6570\u636e\uff0c\u4e0d\u80fd\u518d\u64cd\u4f5c!");
        }
        companyRecommendFormExample.clear();
        companyRecommendFormExample.createCriteria().andIdIn(ids);
        List<CompanyRecommendForm> companyRecommendForms = this.companyRecommendFormMapper.selectByExample(companyRecommendFormExample);
        Assert.isNotEmpty(companyRecommendForms, "\u5ba1\u6838\u6570\u636e\u4e0d\u5b58\u5728");
        this.approve(project, company, loginUser, companyRecommendForms);
    }

    @Override
    @CacheEvict(value={"companyRecommendForm"}, allEntries=true)
    @Transactional
    public void abolish(Project project, Company company, List<CompanyRecommendForm> companyRecommendFormList) {
        if (CollectionUtils.isEmpty(companyRecommendFormList)) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e");
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (CompanyRecommendForm companyRecommendForm : companyRecommendFormList) {
            if (StringUtils.isBlank((String)companyRecommendForm.getId())) {
                throw new CommonException("\u6570\u636eID\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636eID");
            }
            ids.add(companyRecommendForm.getId());
        }
        CompanyRecommendFormExample companyRecommendFormExample = new CompanyRecommendFormExample();
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(Integer.valueOf(DocumentStatusEnum.NOT_AUDITED.getCode()));
        list.add(Integer.valueOf(DocumentStatusEnum.AUDITED.getCode()));
        list.add(Integer.valueOf(DocumentStatusEnum.DISMISSAL.getCode()));
        companyRecommendFormExample.createCriteria().andIdIn(ids).andPurCompanyIdEqualTo(project.getCompanyId()).andApproveStatusIn(list).andProjectIdEqualTo(project.getId());
        int count2 = this.companyRecommendFormMapper.countByExample(companyRecommendFormExample);
        if (count2 > 0) {
            throw new CommonException("\u5355\u636e\u4e2d\u5305\u542b\u672a\u5ba1\u6838\u6216\u8005\u5df2\u5ba1\u6838\u6216\u8005\u5df2\u9a73\u56de\u7684\u6570\u636e\uff0c\u64cd\u4f5c\u5931\u8d25!");
        }
        companyRecommendFormExample.clear();
        companyRecommendFormExample.createCriteria().andIdIn(ids).andPurCompanyIdEqualTo(project.getCompanyId()).andConfirmStatusEqualTo(ConfirmStatusEnum.STATUS_ABOLISH.getStatus()).andProjectIdEqualTo(project.getId());
        int count = this.companyRecommendFormMapper.countByExample(companyRecommendFormExample);
        if (count > 0) {
            throw new CommonException("\u5355\u636e\u4e2d\u5305\u542b\u5df2\u4f5c\u5e9f\u6570\u636e\uff0c\u64cd\u4f5c\u5931\u8d25!");
        }
        CompanyRecommendForm companyRecommendForm = new CompanyRecommendForm();
        companyRecommendForm.setConfirmStatus(ConfirmStatusEnum.STATUS_ABOLISH.getStatus());
        companyRecommendFormExample.clear();
        companyRecommendFormExample.createCriteria().andIdIn(ids).andPurCompanyIdEqualTo(project.getCompanyId()).andProjectIdEqualTo(project.getId());
        this.companyRecommendFormMapper.updateByExampleSelective(companyRecommendForm, companyRecommendFormExample);
        companyRecommendFormExample.clear();
        companyRecommendFormExample.createCriteria().andIdIn(ids);
        List<CompanyRecommendForm> companyRecommendForms = this.companyRecommendFormMapper.selectByExample(companyRecommendFormExample);
        for (CompanyRecommendForm recommendForm : companyRecommendForms) {
            this.workFlowService.stopProcess("hggysdrtjb", recommendForm.getRecommendNo());
        }
    }

    @Override
    @CacheEvict(value={"companyRecommendForm"}, allEntries=true)
    @Transactional
    public void deleteObjByIds(Project project, Company company, List<CompanyRecommendForm> companyRecommendFormList) {
        if (CollectionUtils.isEmpty(companyRecommendFormList)) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e");
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (CompanyRecommendForm companyRecommendForm : companyRecommendFormList) {
            if (StringUtils.isBlank((String)companyRecommendForm.getId())) {
                throw new CommonException("\u6570\u636eID\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636eID");
            }
            ids.add(companyRecommendForm.getId());
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(Integer.valueOf(DocumentStatusEnum.BEING_AUDITED.getCode()));
        list.add(Integer.valueOf(DocumentStatusEnum.AUDITED.getCode()));
        list.add(Integer.valueOf(DocumentStatusEnum.DISMISSAL.getCode()));
        CompanyRecommendFormExample companyRecommendFormExample = new CompanyRecommendFormExample();
        companyRecommendFormExample.createCriteria().andIdIn(ids).andPurCompanyIdEqualTo(project.getCompanyId()).andApproveStatusIn(list).andProjectIdEqualTo(project.getId());
        int count = this.companyRecommendFormMapper.countByExample(companyRecommendFormExample);
        if (count > 0) {
            throw new CommonException("\u53ea\u80fd\u5220\u9664\u672a\u5ba1\u6838\u72b6\u6001\u7684\u5355\u636e\uff0c\u8bf7\u68c0\u67e5\uff0c\u8c22\u8c22!");
        }
        CompanyRecommendForm companyRecommendForm = new CompanyRecommendForm();
        companyRecommendForm.setIsEnable(Constant.NO_INT);
        companyRecommendFormExample.clear();
        companyRecommendFormExample.createCriteria().andIdIn(ids).andPurCompanyIdEqualTo(project.getCompanyId()).andProjectIdEqualTo(project.getId());
        this.companyRecommendFormMapper.updateByExampleSelective(companyRecommendForm, companyRecommendFormExample);
    }

    @Override
    @CacheEvict(value={"companyRecommendForm"}, allEntries=true)
    @Transactional
    public void insert(String projectId, Company company, User user, CompanyRecommendForm companyRecommendForm) {
        if (companyRecommendForm == null) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e");
        }
        this.setSupCompanyInfo(ProjectUtils.getProject(), companyRecommendForm);
        this.setPurCompanyInfo(company, companyRecommendForm);
        this.setCompanyRecommendForm(ProjectUtils.getProject(), user, companyRecommendForm);
        if (StringUtils.isEmpty((String)companyRecommendForm.getId())) {
            this.companyRecommendFormMapper.insertSelective(companyRecommendForm);
        } else {
            this.companyRecommendFormMapper.updateByPrimaryKey(companyRecommendForm);
        }
    }

    private void setCompanyRecommendForm(Project project, User user, CompanyRecommendForm companyRecommendForm) {
        companyRecommendForm.setProjectId(project.getId());
        companyRecommendForm.setCreateBillName(user.getNickName());
        companyRecommendForm.setCreateTime(new Date());
        String auditNoticeNo = this.generateCodeService.getNextCode("RECOMMEND_NO");
        companyRecommendForm.setRecommendNo(auditNoticeNo);
        companyRecommendForm.setIsEnable(Constant.YES_INT);
        companyRecommendForm.setConfirmStatus(ConfirmStatusEnum.STATUS_CONFIRM.getStatus());
        companyRecommendForm.setApproveStatus(Integer.valueOf(DocumentStatusEnum.NOT_AUDITED.getCode()));
    }

    private void setPurCompanyInfo(Company company, CompanyRecommendForm companyRecommendForm) {
        companyRecommendForm.setPurCompanyId(company.getId());
        companyRecommendForm.setPurCompanyName(company.getCompanyName());
        companyRecommendForm.setPurCompanyFullName(company.getCompanyFullName());
        companyRecommendForm.setPurCompanySrmCode(company.getCompanyCode());
        companyRecommendForm.setPurCompanySapCode(company.getCompanySapCode());
    }

    private void setSupCompanyInfo(Project project, CompanyRecommendForm companyRecommendForm) {
        if (StringUtils.isEmpty((String)companyRecommendForm.getSupCompanySrmCode())) {
            throw new CommonException("\u4f9b\u5e94\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", "\u4f9b\u5e94\u5546SRM\u7f16\u7801");
        }
        CompanyExample companyExample = new CompanyExample();
        companyExample.createCriteria().andProjectIdEqualTo(project.getId()).andCompanyCodeEqualTo(companyRecommendForm.getSupCompanySrmCode());
        PageView<Company> companyPageView = this.companyService.querySupplerCompanies(project.getCompanyId(), companyExample, PartnerRoleEnum.POTENIAL.getCode());
        List<Company> queryResult = companyPageView.getQueryResult();
        if (CollectionUtils.isEmpty(queryResult)) {
            throw new CommonException("\u6f5c\u5728\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728", "do_not_exists", "\u6f5c\u5728\u4f9b\u5e94\u5546");
        }
        Company superCompany = queryResult.get(0);
        companyRecommendForm.setSupCompanyId(superCompany.getId());
        companyRecommendForm.setSupCompanySrmCode(superCompany.getCompanyCode());
        companyRecommendForm.setSupCompanySapCode(superCompany.getCompanySapCode());
        companyRecommendForm.setSupCompanyName(superCompany.getCompanyName());
        companyRecommendForm.setSupCompanyFullName(superCompany.getCompanyFullName());
        companyRecommendForm.setSupCompanyAddress(superCompany.getAddress());
        companyRecommendForm.setSupCompanyProductionAddress(superCompany.getProductionAddress());
    }

    @Override
    @CacheEvict(value={"companyRecommendForm"}, allEntries=true)
    public void addObj(CompanyRecommendForm t) {
        this.companyRecommendFormMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"companyRecommendForm"}, allEntries=true)
    public void deleteObjById(String id) {
        this.companyRecommendFormMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"companyRecommendForm"}, allEntries=true)
    public void modifyObj(CompanyRecommendForm t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.companyRecommendFormMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"companyRecommendForm"}, keyGenerator="redisKeyGenerator")
    public CompanyRecommendForm queryObjById(String id) {
        return this.companyRecommendFormMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"companyRecommendForm"}, keyGenerator="redisKeyGenerator")
    public List<CompanyRecommendForm> queryAllObjByExample(CompanyRecommendFormExample example) {
        return this.companyRecommendFormMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"companyRecommendForm"}, keyGenerator="redisKeyGenerator")
    public PageView<CompanyRecommendForm> queryObjByPage(CompanyRecommendFormExample example) {
        PageView<CompanyRecommendForm> pageView = example.getPageView();
        List<CompanyRecommendForm> formList = this.companyRecommendFormMapper.selectByExampleByPage(example);
        for (CompanyRecommendForm f : formList) {
            ContactsExample contactsExample = new ContactsExample();
            contactsExample.createCriteria().andSupCompanyIdEqualTo(f.getSupCompanyId());
            List<Contacts> c = this.contactsService.queryAllObjByExample(contactsExample);
            f.setContactsList(c);
        }
        pageView.setQueryResult(formList);
        return pageView;
    }
}

