/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.remind.service.impl;

import com.els.base.certification.auth.service.CompanyAuthService;
import com.els.base.certification.certificate.service.CertificateExpiryService;
import com.els.base.certification.remind.dao.RemindInfoMapper;
import com.els.base.certification.remind.entity.RemindInfo;
import com.els.base.certification.remind.entity.RemindInfoExample;
import com.els.base.certification.remind.service.RemindInfoService;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultRemindInfoService")
public class RemindInfoServiceImpl
implements RemindInfoService {
    @Resource
    protected RemindInfoMapper remindInfoMapper;
    @Resource
    private CertificateExpiryService certificateExpiryService;
    @Resource
    private CompanyAuthService companyAuthService;
    @Resource
    private CompanyService companyService;
    @Resource
    private RemindInfoService remindInfoService;

    @Override
    @CacheEvict(value={"remindInfo"}, allEntries=true)
    public void addObj(RemindInfo t) {
        this.remindInfoMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"remindInfo"}, allEntries=true)
    public void batchObjByIds(List<String> ids) {
        RemindInfoExample example = new RemindInfoExample();
        example.createCriteria().andIdIn((List)ids).andStatusEqualTo(Constant.YES_INT);
        if (this.remindInfoMapper.countByExample(example) > 0) {
            throw new CommonException("\u6240\u9009\u6570\u636e\u5305\u542b\u5df2\u786e\u8ba4\u7684\uff0c\u64cd\u4f5c\u5931\u8d25");
        }
        example.clear();
        example.createCriteria().andIdIn((List)ids).andStatusEqualTo(Constant.NO_INT);
        RemindInfo remind = new RemindInfo();
        remind.setStatus(Constant.YES_INT);
        this.remindInfoMapper.updateByExampleSelective(remind, example);
    }

    @Override
    @CacheEvict(value={"remindInfo"}, allEntries=true)
    public void deleteObjById(String id) {
        this.remindInfoMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"remindInfo"}, allEntries=true)
    public void modifyObj(RemindInfo t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.remindInfoMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @CacheEvict(value={"remindInfo"}, allEntries=true)
    public void modifyByExample(RemindInfo remindInfo, RemindInfoExample remindInfoExample) {
        Assert.isNotNull(remindInfo, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        this.remindInfoMapper.updateByExampleSelective(remindInfo, remindInfoExample);
    }

    @Override
    @Cacheable(value={"remindInfo"}, keyGenerator="redisKeyGenerator")
    public RemindInfo queryObjById(String id) {
        return this.remindInfoMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"remindInfo"}, keyGenerator="redisKeyGenerator")
    public List<RemindInfo> queryAllObjByExample(RemindInfoExample example) {
        return this.remindInfoMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"remindInfo"}, keyGenerator="redisKeyGenerator")
    public PageView<RemindInfo> queryObjByPage(RemindInfoExample example) {
        PageView<RemindInfo> pageView = example.getPageView();
        pageView.setQueryResult(this.remindInfoMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"remindInfo"}, keyGenerator="redisKeyGenerator")
    public int countByExample(RemindInfoExample remindInfoExample) {
        int countByExample = this.remindInfoMapper.countByExample(remindInfoExample);
        return countByExample;
    }
}

