/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.remind.web.controller;

import com.els.base.certification.process.util.ExcelFileData;
import com.els.base.certification.remind.entity.RemindInfo;
import com.els.base.certification.remind.entity.RemindInfoExample;
import com.els.base.certification.remind.service.RemindInfoService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.utils.excel.DateConverter;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.ObjToStrConverter;
import com.els.base.utils.excel.StrToObjConverter;
import com.els.base.utils.excel.TitleAndModelKey;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.qqt.message.client.JsonUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import jxl.write.WriteException;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u4f9b\u5e94\u5546\u51c6\u5165-\u5230\u671f\u63d0\u9192\u4f9b\u5e94\u5546\u4fe1\u606f")
@Controller
@RequestMapping(value={"remindInfo"})
public class RemindInfoController {
    @Resource
    protected RemindInfoService remindInfoService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u4f9b\u5e94\u5546\u51c6\u5165-\u5230\u671f\u63d0\u9192\u4f9b\u5e94\u5546\u4fe1\u606f")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody RemindInfo remindInfo) {
        this.remindInfoService.addObj(remindInfo);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u4f9b\u5e94\u5546\u51c6\u5165-\u5230\u671f\u63d0\u9192\u4f9b\u5e94\u5546\u4fe1\u606f")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody RemindInfo remindInfo) {
        Assert.isNotBlank(remindInfo.getId(), "id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.remindInfoService.modifyObj(remindInfo);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u4f9b\u5e94\u5546\u51c6\u5165-\u5230\u671f\u63d0\u9192\u4f9b\u5e94\u5546\u4fe1\u606f")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.remindInfoService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u6279\u91cf\u786e\u8ba4\u5355\u636e\u4f9b\u5e94\u5546\u51c6\u5165-\u5230\u671f\u63d0\u9192\u4f9b\u5e94\u5546\u4fe1\u606f")
    @RequestMapping(value={"service/batchByIds"})
    @ResponseBody
    public ResponseResult<String> batchByIds(@RequestBody List<String> ids) {
        Assert.isNotEmpty(ids, "\u786e\u8ba4\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.remindInfoService.batchObjByIds(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546\u67e5\u8be2\u4f9b\u5e94\u5546\u51c6\u5165-\u5230\u671f\u63d0\u9192\u4f9b\u5e94\u5546\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 RemindInfo", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/purFindByPage"})
    @ResponseBody
    public ResponseResult<PageView<RemindInfo>> purFindByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        RemindInfoExample example = new RemindInfoExample();
        example.setPageView(new PageView<RemindInfo>(pageNo, pageSize));
        example.setOrderByClause("SUP_COMPANY_SRM_CODE DESC ");
        RemindInfoExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView pageData = this.remindInfoService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u67e5\u8be2\u4f9b\u5e94\u5546\u51c6\u5165-\u5230\u671f\u63d0\u9192\u4f9b\u5e94\u5546\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 RemindInfo", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/supFindByPage"})
    @ResponseBody
    public ResponseResult<PageView<RemindInfo>> supFindByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        RemindInfoExample example = new RemindInfoExample();
        example.setPageView(new PageView<RemindInfo>(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME ASC");
        RemindInfoExample.Criteria criteria = example.createCriteria();
        criteria.andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        PageView pageData = this.remindInfoService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u51c6\u5165-\u5230\u671f\u63d0\u9192\u4f9b\u5e94\u5546\u4fe1\u606f\u5bfc\u51faExcel")
    @RequestMapping(value={"service/downloadExcelForPur"})
    @ResponseBody
    public ResponseResult<FileData> downloadExcelForPur(@RequestBody Map<String, Object> queryMap) throws JsonParseException, JsonMappingException, IOException, WriteException, ParseException {
        String queryParams = (String)queryMap.get("queryParams");
        String ids = (String)queryMap.get("ids");
        RemindInfoExample example = new RemindInfoExample();
        example.setOrderByClause("SUP_COMPANY_SRM_CODE DESC ");
        RemindInfoExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (StringUtils.isNotEmpty((String)queryParams)) {
            QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtil.convertValue((String)queryParams, QueryParamWapper.class);
            CriteriaUtils.addCriterion(criteria, queryParamWapper);
        }
        if (StringUtils.isNotBlank((String)ids)) {
            criteria.andIdIn((List)Arrays.asList(ids.split(",")));
        }
        List list = this.remindInfoService.queryAllObjByExample(example);
        List<TitleAndModelKey> titleAndModelKeys = this.createExcelHeaderForPur();
        FileData fileData = ExcelFileData.createExcelFileOutputStream(titleAndModelKeys, list, "\u4f9b\u5e94\u5546\u8d44\u8d28\u5230\u671f\u63d0\u9192\u4fe1\u606f", "\u4f9b\u5e94\u5546\u8d44\u8d28\u5230\u671f\u63d0\u9192\u4fe1\u606f", 0);
        return ResponseResult.success(fileData);
    }

    private List<TitleAndModelKey> createExcelHeaderForPur() {
        DateConverter dateConverter = new DateConverter();
        dateConverter.setDateFormat("yyyy-MM-dd");
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546SRM\u7f16\u7801", (String)"supCompanySrmCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u540d\u79f0", (String)"supCompanyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8bc1\u4e66\u540d\u79f0/\u7c7b\u578b", (String)"certificateName"));
        TitleAndModelKey endTime = ExcelUtils.createTitleAndModelKey((String)"\u5230\u671f\u65e5\u671f", (String)"endTime");
        endTime.setToObjConverter((StrToObjConverter)dateConverter);
        endTime.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(endTime);
        return titleAndModelKeys;
    }
}

