/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.suppliercategory.service.impl;

import com.els.base.certification.suppliercategory.dao.SupplierCategoryMapper;
import com.els.base.certification.suppliercategory.entity.SupplierCategory;
import com.els.base.certification.suppliercategory.entity.SupplierCategoryExample;
import com.els.base.certification.suppliercategory.service.SupplierCategoryService;
import com.els.base.company.dao.CompanyMapper;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="defaultSupplierCategoryService")
public class SupplierCategoryServiceImpl
implements SupplierCategoryService {
    @Resource
    protected SupplierCategoryMapper supplierCategoryMapper;
    @Resource
    private CompanyMapper companyMapper;
    @Resource
    private CompanyService companyServic;

    @Override
    @CacheEvict(value={"supplierCategory"}, allEntries=true)
    public void addObj(SupplierCategory t) {
        SupplierCategoryExample example = new SupplierCategoryExample();
        example.createCriteria().andCategoryCodeEqualTo(t.getCategoryCode());
        if (this.supplierCategoryMapper.countByExample(example) > 0) {
            throw new CommonException("\u65b0\u589e\u7684\u4f9b\u5e94\u5546\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u76f8\u540c");
        }
        this.supplierCategoryMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"supplierCategory"}, allEntries=true)
    public void deleteObjById(String id) {
        this.supplierCategoryMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"supplierCategory"}, allEntries=true)
    public void modifyObj(SupplierCategory t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.supplierCategoryMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"supplierCategory"}, keyGenerator="redisKeyGenerator")
    public SupplierCategory queryObjById(String id) {
        return this.supplierCategoryMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"supplierCategory"}, keyGenerator="redisKeyGenerator")
    public List<SupplierCategory> queryAllObjByExample(SupplierCategoryExample example) {
        return this.supplierCategoryMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"supplierCategory"}, keyGenerator="redisKeyGenerator")
    public PageView<SupplierCategory> queryObjByPage(SupplierCategoryExample example) {
        PageView<SupplierCategory> pageView = example.getPageView();
        pageView.setQueryResult(this.supplierCategoryMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"supplierCategory"}, allEntries=true)
    public void deleteCascadedMaterialCategoryInfo(String parentId) {
        if (StringUtils.isBlank((String)parentId)) {
            throw new CommonException("\u4e0a\u4e00\u7ea7\u4f20\u7684id\u4e3a\u7a7a!");
        }
        this.supplierCategoryMapper.deleteByPrimaryKey(parentId);
        SupplierCategoryExample materialCategoryExample = new SupplierCategoryExample();
        materialCategoryExample.createCriteria().andParentIdEqualTo(parentId).andIsEnableEqualTo(Constant.YES_INT);
        List<SupplierCategory> list = this.supplierCategoryMapper.selectByExample(materialCategoryExample);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (SupplierCategory supplierCategory : list) {
            this.deleteCascadedMaterialCategoryInfo(supplierCategory.getId());
        }
    }

    @Override
    @Cacheable(value={"supplierCategory"}, keyGenerator="redisKeyGenerator")
    public List<SupplierCategory> queryByParentId(String parentId) {
        if (StringUtils.isBlank((String)parentId)) {
            return null;
        }
        SupplierCategoryExample example = new SupplierCategoryExample();
        example.createCriteria().andParentIdEqualTo(parentId).andIsEnableEqualTo(Constant.YES_INT);
        List<SupplierCategory> list = this.supplierCategoryMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        for (SupplierCategory materialCategory : list) {
            materialCategory.setSupplierCategoryList(this.queryByParentId(materialCategory.getId()));
        }
        return list;
    }

    @Override
    @CacheEvict(value={"supplierCategory"}, allEntries=true)
    public void addSupCategory(Company c, String supplierCategoryId) {
        if (StringUtils.isBlank((String)c.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728\u65e0\u6cd5\u66f4\u65b0");
        }
        SupplierCategory supplierCategory = this.supplierCategoryMapper.selectByPrimaryKey(supplierCategoryId);
        if (supplierCategory == null) {
            throw new CommonException("\u8be5\u5206\u7c7b\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u4fdd\u5b58");
        }
        c.setCategoryName(supplierCategory.getCompanyCategory());
        c.setCategoryCode(supplierCategory.getCategoryCode());
        this.companyServic.modifyObj(c);
    }

    @Override
    @CacheEvict(value={"supplierCategory"}, allEntries=true)
    public void addSupCategory(Company company, String supplierCategoryId, String type) {
        switch (type) {
            case "0": {
                this.addSupCategory(company, supplierCategoryId);
                break;
            }
            case "1": {
                this.addProductImportanceName(company, supplierCategoryId);
                break;
            }
            case "2": {
                this.addSymbiosis(company, supplierCategoryId);
                break;
            }
            case "3": {
                this.addCriticalityName(company, supplierCategoryId);
                break;
            }
            default: {
                this.addSupCategory(company, supplierCategoryId);
            }
        }
    }

    private void addCriticalityName(Company company, String supplierCategoryId) {
        if (StringUtils.isBlank((String)company.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728\u65e0\u6cd5\u66f4\u65b0");
        }
        SupplierCategory supplierCategory = this.supplierCategoryMapper.selectByPrimaryKey(supplierCategoryId);
        if (supplierCategory == null) {
            throw new CommonException("\u8be5\u5206\u7c7b\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u4fdd\u5b58");
        }
        company.setCriticalityId(supplierCategoryId);
        company.setCriticalityName(supplierCategory.getCompanyCategory());
        this.companyServic.modifyObj(company);
    }

    private void addSymbiosis(Company company, String supplierCategoryId) {
        if (StringUtils.isBlank((String)company.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728\u65e0\u6cd5\u66f4\u65b0");
        }
        SupplierCategory supplierCategory = this.supplierCategoryMapper.selectByPrimaryKey(supplierCategoryId);
        if (supplierCategory == null) {
            throw new CommonException("\u8be5\u5206\u7c7b\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u4fdd\u5b58");
        }
        company.setSymbiosisId(supplierCategoryId);
        company.setSymbiosis(supplierCategory.getCompanyCategory());
        this.companyServic.modifyObj(company);
    }

    private void addProductImportanceName(Company company, String supplierCategoryId) {
        if (StringUtils.isBlank((String)company.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728\u65e0\u6cd5\u66f4\u65b0");
        }
        SupplierCategory supplierCategory = this.supplierCategoryMapper.selectByPrimaryKey(supplierCategoryId);
        if (supplierCategory == null) {
            throw new CommonException("\u8be5\u5206\u7c7b\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u4fdd\u5b58");
        }
        company.setProductImportanceId(supplierCategoryId);
        company.setProductImportanceName(supplierCategory.getCompanyCategory());
        this.companyServic.modifyObj(company);
    }

    @Override
    @CacheEvict(value={"supplierCategory"}, allEntries=true)
    public void deleteByExample(SupplierCategoryExample example) {
        Assert.isNotEmpty(example.getOredCriteria(), "\u4e0d\u80fd\u8fdb\u884c\u5168\u8868\u5220\u9664\uff01");
        this.supplierCategoryMapper.deleteByExample(example);
    }
}

