/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.supplierchangesheet.service.impl;

import com.els.base.certification.supplierchangesheet.dao.ChangePatentsAndAgentMapper;
import com.els.base.certification.supplierchangesheet.entity.ChangePatentsAndAgent;
import com.els.base.certification.supplierchangesheet.entity.ChangePatentsAndAgentExample;
import com.els.base.certification.supplierchangesheet.service.ChangePatentsAndAgentService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultChangePatentsAndAgentService")
public class ChangePatentsAndAgentServiceImpl
implements ChangePatentsAndAgentService {
    @Resource
    protected ChangePatentsAndAgentMapper changePatentsAndAgentMapper;

    @Override
    @CacheEvict(value={"changePatentsAndAgent"}, allEntries=true)
    public void addObj(ChangePatentsAndAgent t) {
        this.changePatentsAndAgentMapper.insertSelective(t);
    }

    @Override
    @Transactional
    @CacheEvict(value={"changePatentsAndAgent"}, allEntries=true)
    public void addAll(List<ChangePatentsAndAgent> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.changePatentsAndAgentMapper.insertBatch(list);
    }

    @Override
    @CacheEvict(value={"changePatentsAndAgent"}, allEntries=true)
    public void deleteObjById(String id) {
        this.changePatentsAndAgentMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"changePatentsAndAgent"}, allEntries=true)
    public void deleteByExample(ChangePatentsAndAgentExample example) {
        Assert.isNotNull(example, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), "\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.changePatentsAndAgentMapper.deleteByExample(example);
    }

    @Override
    @CacheEvict(value={"changePatentsAndAgent"}, allEntries=true)
    public void modifyObj(ChangePatentsAndAgent t) {
        Assert.isNotBlank(t.getId(), "id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.changePatentsAndAgentMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"changePatentsAndAgent"}, keyGenerator="redisKeyGenerator")
    public ChangePatentsAndAgent queryObjById(String id) {
        return this.changePatentsAndAgentMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"changePatentsAndAgent"}, keyGenerator="redisKeyGenerator")
    public List<ChangePatentsAndAgent> queryAllObjByExample(ChangePatentsAndAgentExample example) {
        return this.changePatentsAndAgentMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"changePatentsAndAgent"}, keyGenerator="redisKeyGenerator")
    public PageView<ChangePatentsAndAgent> queryObjByPage(ChangePatentsAndAgentExample example) {
        PageView<ChangePatentsAndAgent> pageView = example.getPageView();
        pageView.setQueryResult(this.changePatentsAndAgentMapper.selectByExampleByPage(example));
        return pageView;
    }
}

