/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.supplierchangesheet.service.impl;

import com.els.base.certification.supplierchangesheet.dao.SupplierChangeSheetMapper;
import com.els.base.certification.supplierchangesheet.emum.ApproveStatus;
import com.els.base.certification.supplierchangesheet.emum.ChangType;
import com.els.base.certification.supplierchangesheet.entity.ChangePatentsAndAgent;
import com.els.base.certification.supplierchangesheet.entity.ChangePatentsAndAgentExample;
import com.els.base.certification.supplierchangesheet.entity.SupAuthentication;
import com.els.base.certification.supplierchangesheet.entity.SupAuthenticationExample;
import com.els.base.certification.supplierchangesheet.entity.SupplierChangeSheet;
import com.els.base.certification.supplierchangesheet.entity.SupplierChangeSheetDETAILE;
import com.els.base.certification.supplierchangesheet.entity.SupplierChangeSheetDETAILEExample;
import com.els.base.certification.supplierchangesheet.entity.SupplierChangeSheetExample;
import com.els.base.certification.supplierchangesheet.service.ChangePatentsAndAgentService;
import com.els.base.certification.supplierchangesheet.service.SupAuthenticationService;
import com.els.base.certification.supplierchangesheet.service.SupplierChangeSheetDETAILEService;
import com.els.base.certification.supplierchangesheet.service.SupplierChangeSheetService;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.workflow.common.entity.ProcessStartVO;
import com.els.base.workflow.common.event.TaskOperateEvent;
import com.els.base.workflow.common.service.ITaskListener;
import com.els.base.workflow.common.service.WorkFlowService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultSupplierChangeSheetService")
public class SupplierChangeSheetServiceImpl
implements SupplierChangeSheetService,
ITaskListener {
    private Logger logger = LoggerFactory.getLogger(SupplierChangeSheetServiceImpl.class);
    @Resource
    protected SupplierChangeSheetMapper supplierChangeSheetMapper;
    @Resource
    protected GenerateCodeService generatecodeservice;
    @Resource
    protected SupplierChangeSheetDETAILEService SupplierChangeSheetDetaleService;
    @Resource
    protected SupAuthenticationService supAuthenticationService;
    @Resource
    protected WorkFlowService workFlowService;
    @Resource
    protected ChangePatentsAndAgentService changePatentsAndAgentService;

    @Override
    @CacheEvict(value={"supplierChangeSheet"}, allEntries=true)
    public void addObj(SupplierChangeSheet t) {
        this.supplierChangeSheetMapper.insertSelective(t);
    }

    @Override
    @Transactional
    @CacheEvict(value={"supplierChangeSheet"}, allEntries=true)
    public void insert(SupplierChangeSheet t, User loginUser, Company company) {
        Assert.isNotNull(t, "\u53d8\u66f4\u5355\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull(t.getSupplierChangeSheetDetaileList(), "\u53d8\u66f4\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\u5426\u5219\u65e0\u6cd5\u751f\u6210\u4f9b\u5e94\u5546\u4fe1\u606f\u53d8\u66f4\u5355");
        String ChangeBillNos = this.generatecodeservice.getNextCode("CHANGE_BILL_NO");
        t.setChangeBillNo(ChangeBillNos);
        t.setConfirmTime(new Date());
        t.setConfirmBillName(loginUser.getNickName());
        t.setSupplierSapCode(company.getCompanySapCode());
        t.setSupCompanyId(company.getCompanyCode());
        t.setSupplierName(company.getCompanyName());
        t.setChangType(ChangType.INFORMATION.getCode());
        t.setUpdateTime(new Date());
        t.setCreateBillTime(new Date());
        if (t.getSupplierChangeSheetDetaileList().size() > 0 && !t.getSupplierChangeSheetDetaileList().isEmpty()) {
            List<SupplierChangeSheetDETAILE> list = t.getSupplierChangeSheetDetaileList();
            for (int i = 0; i < list.size(); ++i) {
                SupplierChangeSheetDETAILE supplierChangeSheetDETAILE = list.get(i);
                supplierChangeSheetDETAILE.setChangeBillNo(ChangeBillNos);
                supplierChangeSheetDETAILE.setCreateTime(new Date());
                String content = supplierChangeSheetDETAILE.getContent();
                String changeContent = supplierChangeSheetDETAILE.getChangeContent();
                if (!content.equals(changeContent)) continue;
                throw new CommonException("\u539f\u5185\u5bb9\u4e0e\u66f4\u6539\u5185\u5bb9\u4e0d\u80fd\u76f8\u540c");
            }
            this.SupplierChangeSheetDetaleService.addAll(list);
            this.supplierChangeSheetMapper.insertSelective(t);
        }
    }

    @Override
    @Transactional
    @CacheEvict(value={"supplierChangeSheet"}, allEntries=true)
    public void addCertification(SupplierChangeSheet t, User loginUser, Company company) {
        Assert.isNotNull(t, "\u53d8\u66f4\u5355\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        String ChangeBillNos = this.generatecodeservice.getNextCode("CHANGE_BILL_NO");
        t.setChangeBillNo(ChangeBillNos);
        t.setConfirmTime(new Date());
        t.setConfirmBillName(loginUser.getNickName());
        t.setSupplierSapCode(company.getCompanySapCode());
        t.setSupCompanyId(company.getCompanyCode());
        t.setSupplierName(company.getCompanyName());
        t.setChangType(ChangType.QUALIFICATION.getCode());
        t.setUpdateTime(new Date());
        t.setCreateBillTime(new Date());
        if (t.getSupAuthenticationList() != null && !t.getSupAuthenticationList().isEmpty()) {
            List<SupAuthentication> list = t.getSupAuthenticationList();
            for (int i = 0; i < list.size(); ++i) {
                SupAuthentication supAuthentication = list.get(i);
                Assert.isNotNull(supAuthentication.getEffectiveDate(), "\u8bc1\u4e66\u6709\u6548\u671f\u4e0d\u80fd\u4e3a\u7a7a");
                if (StringUtils.isBlank((String)supAuthentication.getAttachment()) || supAuthentication.getAttachment().equals("[]")) {
                    throw new CommonException("\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u5fc5\u987b\u4e0a\u4f20\u9644\u4ef6");
                }
                supAuthentication.setChangbillno(ChangeBillNos);
                supAuthentication.setIsEnable(Constant.YES_INT);
                supAuthentication.setUpdateDate(new Date());
            }
            this.supAuthenticationService.addAll(list);
            this.supplierChangeSheetMapper.insertSelective(t);
        }
    }

    @Override
    @Transactional
    @CacheEvict(value={"supplierChangeSheet"}, allEntries=true)
    public void addPatentsAndAgent(SupplierChangeSheet t, User loginUser, Company company) {
        Assert.isNotEmpty(t.getChangePatentsAndAgentList(), "\u9700\u8981\u53d8\u66f4\u7684\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        String ChangeBillNos = this.generatecodeservice.getNextCode("CHANGE_BILL_NO");
        t.setChangeBillNo(ChangeBillNos);
        t.setConfirmTime(new Date());
        t.setConfirmBillName(loginUser.getNickName());
        t.setSupplierSapCode(company.getCompanySapCode());
        t.setSupCompanyId(company.getCompanyCode());
        t.setSupplierName(company.getCompanyName());
        t.setUpdateTime(new Date());
        t.setCreateBillTime(new Date());
        if (t.getChangType().intValue() == ChangType.PATENTS.getCode()) {
            t.getChangePatentsAndAgentList().forEach(patents -> {
                Assert.isNotNull(patents.getEndTime(), "\u4e13\u5229/\u8bb8\u53ef\u7684\u6709\u6548\u671f\u81f3\u4e0d\u80fd\u4e3a\u7a7a");
                if (StringUtils.isBlank((String)patents.getPatentFile()) || "[]".equals(patents.getPatentFile())) {
                    throw new CommonException("\u4e13\u5229/\u8bb8\u53ef\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
                }
                patents.setChangeBillNo(ChangeBillNos);
                patents.setIsEnable(Constant.YES_INT);
                patents.setCreateTime(new Date());
            });
        }
        if (t.getChangType().intValue() == ChangType.AGENT.getCode()) {
            t.getChangePatentsAndAgentList().forEach(agent -> {
                Assert.isNotNull(agent.getAgentTime(), "\u4ee3\u7406\u8bc1\u6709\u6548\u671f\u4e0d\u80fd\u4e3a\u7a7a");
                Assert.isNotNull(agent.getQualityCertificateTime(), "\u751f\u4ea7\u5546\u8d28\u91cf\u4f53\u7cfb\u8bc1\u4e66\u6709\u6548\u671f\u4e0d\u80fd\u4e3a\u7a7a");
                agent.setChangeBillNo(ChangeBillNos);
                agent.setIsEnable(Constant.YES_INT);
                agent.setCreateTime(new Date());
            });
        }
        this.supplierChangeSheetMapper.insertSelective(t);
        this.changePatentsAndAgentService.addAll(t.getChangePatentsAndAgentList());
    }

    @Override
    @Transactional
    @CacheEvict(value={"supplierChangeSheet"}, allEntries=true)
    public void deleteObjById(String id) {
        SupplierChangeSheet sc = this.supplierChangeSheetMapper.selectByPrimaryKey(id);
        if (sc.getApproveStatus().intValue() != ApproveStatus.UNAUDITED.getCode()) {
            throw new CommonException("\u53ea\u6709\u65b0\u5efa\u7684\u5355\u636e\u624d\u53ef\u4ee5\u5220\u9664");
        }
        String changeBillNo = sc.getChangeBillNo();
        SupplierChangeSheetDETAILEExample sheetExample = new SupplierChangeSheetDETAILEExample();
        sheetExample.createCriteria().andChangeBillNoEqualTo(changeBillNo);
        this.SupplierChangeSheetDetaleService.deleteByExample(sheetExample);
        SupAuthenticationExample authExample = new SupAuthenticationExample();
        authExample.createCriteria().andChangbillnoEqualTo(changeBillNo);
        this.supAuthenticationService.deleteByExample(authExample);
        ChangePatentsAndAgentExample agentExample = new ChangePatentsAndAgentExample();
        agentExample.createCriteria().andChangeBillNoEqualTo(changeBillNo);
        this.changePatentsAndAgentService.deleteByExample(agentExample);
        this.supplierChangeSheetMapper.deleteByPrimaryKey(id);
    }

    @Override
    @Transactional
    @CacheEvict(value={"supplierChangeSheet"}, allEntries=true)
    public void modifyObj(SupplierChangeSheet t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        String changeBillNo = t.getChangeBillNo();
        if (CollectionUtils.isNotEmpty(t.getSupplierChangeSheetDetaileList())) {
            this.SupplierChangeSheetDetaleService.deleteByChangeBillNo(changeBillNo);
            List<SupplierChangeSheetDETAILE> list = t.getSupplierChangeSheetDetaileList();
            for (SupplierChangeSheetDETAILE sc : list) {
                sc.setChangeBillNo(changeBillNo);
                sc.setCreateTime(new Date());
                String content = sc.getContent();
                String changeContent = sc.getChangeContent();
                if (content.equals(changeContent)) {
                    throw new CommonException("\u539f\u5185\u5bb9\u4e0e\u66f4\u6539\u5185\u5bb9\u4e0d\u80fd\u76f8\u540c");
                }
                this.SupplierChangeSheetDetaleService.addObj(sc);
            }
        }
        if (CollectionUtils.isNotEmpty(t.getSupAuthenticationList())) {
            this.supAuthenticationService.deleteByChangeBillNo(changeBillNo);
            List<SupAuthentication> supAuthenticationList = t.getSupAuthenticationList();
            for (SupAuthentication supAuthentication : supAuthenticationList) {
                Assert.isNotNull(supAuthentication.getEffectiveDate(), "\u8bc1\u4e66\u6709\u6548\u671f\u4e0d\u80fd\u4e3a\u7a7a");
                if (supAuthentication.getAttachment().equals("[]") || StringUtils.isBlank((String)supAuthentication.getAttachment())) {
                    throw new CommonException("\u8bc1\u4e66\u7684\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u4e0a\u4f20\u9644\u4ef6");
                }
                supAuthentication.setChangbillno(changeBillNo);
                supAuthentication.setIsEnable(Constant.YES_INT);
                supAuthentication.setUpdateDate(new Date());
                this.supAuthenticationService.addObj(supAuthentication);
            }
        }
        if (CollectionUtils.isNotEmpty(t.getChangePatentsAndAgentList())) {
            ChangePatentsAndAgentExample changeExample = new ChangePatentsAndAgentExample();
            changeExample.createCriteria().andChangeBillNoEqualTo(changeBillNo);
            this.changePatentsAndAgentService.deleteByExample(changeExample);
            t.getChangePatentsAndAgentList().forEach(change -> {
                if (t.getChangType().intValue() == ChangType.PATENTS.getCode()) {
                    Assert.isNotNull(change.getEndTime(), "\u4e13\u5229/\u8bb8\u53ef\u7684\u6709\u6548\u671f\u4e0d\u80fd\u4e3a\u7a7a");
                    if (change.getPatentFile().equals("[]") || StringUtils.isBlank((String)change.getPatentFile())) {
                        throw new CommonException("\u4e13\u5229/\u8bb8\u53ef\u7684\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u4e0a\u4f20\u9644\u4ef6");
                    }
                }
                if (t.getChangType().intValue() == ChangType.AGENT.getCode()) {
                    Assert.isNotNull(change.getAgentTime(), "\u4ee3\u7406\u8bc1\u7684\u6709\u6548\u671f\u4e0d\u80fd\u4e3a\u7a7a");
                    Assert.isNotNull(change.getQualityCertificateTime(), "\u751f\u4ea7\u5546\u8d28\u91cf\u4f53\u7cfb\u8bc1\u4e66\u6709\u6548\u671f\u4e0d\u80fd\u4e3a\u7a7a");
                }
                change.setChangeBillNo(changeBillNo);
                change.setIsEnable(Constant.YES_INT);
                change.setCreateTime(new Date());
                this.changePatentsAndAgentService.addObj(change);
            });
        }
        t.setUpdateTime(new Date());
        this.supplierChangeSheetMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"supplierChangeSheet"}, keyGenerator="redisKeyGenerator")
    public SupplierChangeSheet queryObjById(String id) {
        SupplierChangeSheet sc = this.supplierChangeSheetMapper.selectByPrimaryKey(id);
        Assert.isNotNull(sc, "\u6570\u636e\u4e0d\u5b58\u5728");
        sc.setSupplierChangeSheetDetaileList(this.SupplierChangeSheetDetaleService.selectBill(sc.getChangeBillNo()));
        List<SupAuthentication> selectBill = this.supAuthenticationService.selectBill(sc.getChangeBillNo());
        sc.setSupAuthenticationList(selectBill);
        ChangePatentsAndAgentExample agentExample = new ChangePatentsAndAgentExample();
        agentExample.createCriteria().andChangeBillNoEqualTo(sc.getChangeBillNo());
        List<ChangePatentsAndAgent> agentList = this.changePatentsAndAgentService.queryAllObjByExample(agentExample);
        sc.setChangePatentsAndAgentList(agentList);
        return sc;
    }

    @Override
    @Cacheable(value={"supplierChangeSheet"}, keyGenerator="redisKeyGenerator")
    public List<SupplierChangeSheet> queryAllObjByExample(SupplierChangeSheetExample example) {
        return this.supplierChangeSheetMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"supplierChangeSheet"}, keyGenerator="redisKeyGenerator")
    public PageView<SupplierChangeSheet> queryObjByPage(SupplierChangeSheetExample example) {
        PageView<SupplierChangeSheet> pageView = example.getPageView();
        pageView.setQueryResult(this.supplierChangeSheetMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"supplierChangeSheet"}, allEntries=true)
    public void approve(String id) {
        Assert.isNotBlank(id, "\u6a21\u7248\u6570\u636eid\u4e0d\u80fd\u4e3a\u7a7a");
        SupplierChangeSheet supplierChangeSheet = this.queryObjById(id);
        if (supplierChangeSheet.getApproveStatus().intValue() == ApproveStatus.TOAUDIT.getCode() || supplierChangeSheet.getApproveStatus().intValue() == ApproveStatus.AUDITED.getCode()) {
            throw new CommonException("\u6b64\u5355\u636e\u5df2\u6b63\u5728\u5ba1\u6279\u6216\u5df2\u5ba1\u6279\u901a\u8fc7\uff0c\u4e0d\u80fd\u518d\u6267\u884c\u9001\u5ba1\u64cd\u4f5c");
        }
        ProcessStartVO vo = ProcessStartVO.newInstance("cgb", supplierChangeSheet.getChangeBillNo(), supplierChangeSheet.getId(), "informationChangeRequest?id=" + supplierChangeSheet.getId());
        vo.setListenerClass(this.getClass());
        ProcessInstance startProcess = this.workFlowService.startProcess(vo);
        if (startProcess != null) {
            supplierChangeSheet.setUpdateTime(new Date());
            supplierChangeSheet.setApproveStatus(ApproveStatus.TOAUDIT.getCode());
            this.supplierChangeSheetMapper.updateByPrimaryKeySelective(supplierChangeSheet);
        }
    }

    @Override
    @CacheEvict(value={"supplierChangeSheet"}, allEntries=true)
    public void listen(TaskOperateEvent event) {
        if (event == null) {
            this.logger.info("\u76d1\u542c\u4efb\u52a1\u4e3a\u7a7a-----");
            return;
        }
        String businessId = event.getBusinessId();
        this.logger.info("\u83b7\u53d6\u4e1a\u52a1ID-----");
        if (StringUtils.isBlank((String)businessId)) {
            this.logger.info("\u83b7\u53d6\u4e1a\u52a1ID\u4e3a\u7a7a-----");
            return;
        }
        SupplierChangeSheet supplierChangeSheet = this.queryObjById(businessId);
        String assignee = StringUtils.defaultIfBlank((String)event.getAssignee(), (String)"");
        String fullMessage = StringUtils.defaultIfBlank((String)event.getApproveDesc(), (String)"");
        String result = "\u5ba1\u6279\u4eba\uff1a" + assignee + "\uff0c\u5ba1\u6279\u610f\u89c1\uff1a" + fullMessage + " ; ";
        this.logger.info("\u8bbe\u7f6e\u5ba1\u6279\u4eba\u548c\u5ba1\u6279\u610f\u89c1-----");
        if (event.isFinished() && event.isPass()) {
            this.logger.info("\u8fdb\u5165\u5230\u5ba1\u6279\u6d41\u5b8c\u6210\u800c\u4e14\u901a\u8fc7-----");
            supplierChangeSheet.setUpdateTime(new Date());
            supplierChangeSheet.setApproveStatus(ApproveStatus.AUDITED.getCode());
            supplierChangeSheet.setApproveResult(result);
            supplierChangeSheet.setApproveTime(new Date());
            supplierChangeSheet.setApproveUserName(event.getAssignee());
            this.logger.info("\u8bbe\u7f6e\u5ba1\u6279\u72b6\u6001\u548c\u5ba1\u6279\u7ed3\u679c\u5b8c\u6210-----");
            this.supplierChangeSheetMapper.updateByPrimaryKeySelective(supplierChangeSheet);
            this.logger.info("\u8ddf\u65b0\u53d8\u66f4\u5355-----");
        } else if (event.isFinished() && !event.isPass()) {
            this.logger.info("\u8fdb\u5165\u5230\u5ba1\u6279\u6d41\u5b8c\u6210\u4f46\u672a\u901a\u8fc7-----");
            supplierChangeSheet.setUpdateTime(new Date());
            supplierChangeSheet.setApproveStatus(ApproveStatus.REFUSED.getCode());
            supplierChangeSheet.setApproveResult(result);
            supplierChangeSheet.setApproveTime(new Date());
            supplierChangeSheet.setApproveUserName(event.getAssignee());
            this.logger.info("\u8bbe\u7f6e\u5ba1\u6279\u72b6\u6001\u548c\u5ba1\u6279\u7ed3\u679c\u5b8c\u6210-----");
            this.supplierChangeSheetMapper.updateByPrimaryKeySelective(supplierChangeSheet);
            this.logger.info("\u8ddf\u65b0\u53d8\u66f4\u5355-----");
        }
    }
}

