/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.technology.service.impl;

import com.els.base.certification.technology.dao.CompanyTechnologyMapper;
import com.els.base.certification.technology.entity.CompanyTechnology;
import com.els.base.certification.technology.entity.CompanyTechnologyExample;
import com.els.base.certification.technology.service.CompanyTechnologyService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultCompanyTechnologyService")
public class CompanyTechnologyServiceImpl
implements CompanyTechnologyService {
    @Resource
    protected CompanyTechnologyMapper companyTechnologyMapper;

    @Override
    @Cacheable(value={"companyTechnology"}, keyGenerator="redisKeyGenerator")
    public Integer isFinish(Project project, Company company) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(Constant.NO_INT);
        CompanyTechnologyExample companySupplyRelationExample = new CompanyTechnologyExample();
        companySupplyRelationExample.createCriteria().andProjectIdEqualTo(project.getId()).andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
        int count = this.companyTechnologyMapper.countByExample(companySupplyRelationExample);
        if (count <= 0) {
            return 0;
        }
        companySupplyRelationExample.clear();
        companySupplyRelationExample.createCriteria().andProjectIdEqualTo(project.getId()).andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT).andFinishFlagIn(list);
        int finishCount = this.companyTechnologyMapper.countByExample(companySupplyRelationExample);
        if (finishCount > 0) {
            return 0;
        }
        return 1;
    }

    @Override
    @CacheEvict(value={"companyTechnology"}, allEntries=true)
    public void addObj(CompanyTechnology t) {
        this.companyTechnologyMapper.insertSelective(t);
    }

    @Override
    @CacheEvict(value={"companyTechnology"}, allEntries=true)
    public void deleteObjById(String id) {
        this.companyTechnologyMapper.deleteByPrimaryKey(id);
    }

    @Override
    @CacheEvict(value={"companyTechnology"}, allEntries=true)
    public void modifyObj(CompanyTechnology t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.companyTechnologyMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @Cacheable(value={"companyTechnology"}, keyGenerator="redisKeyGenerator")
    public CompanyTechnology queryObjById(String id) {
        return this.companyTechnologyMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"companyTechnology"}, keyGenerator="redisKeyGenerator")
    public List<CompanyTechnology> queryAllObjByExample(CompanyTechnologyExample example) {
        return this.companyTechnologyMapper.selectByExample(example);
    }

    @Override
    @Cacheable(value={"companyTechnology"}, keyGenerator="redisKeyGenerator")
    public PageView<CompanyTechnology> queryObjByPage(CompanyTechnologyExample example) {
        PageView<CompanyTechnology> pageView = example.getPageView();
        pageView.setQueryResult(this.companyTechnologyMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Transactional
    @CacheEvict(value={"companyTechnology"}, allEntries=true)
    public Integer batchInsert(String projectId, Company supCompany, Company purCompany, List<CompanyTechnology> technologyList) {
        if (CollectionUtils.isEmpty(technologyList)) {
            throw new CommonException("\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        CompanyTechnologyExample example = new CompanyTechnologyExample();
        example.createCriteria().andProjectIdEqualTo(projectId).andSupCompanyIdEqualTo(supCompany.getId()).andIsEnableEqualTo(Constant.YES_INT);
        CompanyTechnology technology = new CompanyTechnology();
        technology.setIsEnable(Constant.NO_INT);
        this.companyTechnologyMapper.updateByExampleSelective(technology, example);
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (CompanyTechnology companyTechnology : technologyList) {
            companyTechnology.setId(null);
            companyTechnology.setProjectId(projectId);
            companyTechnology.setPurCompanyId(purCompany.getId());
            companyTechnology.setPurCompanySrmCode(purCompany.getCompanyCode());
            companyTechnology.setPurCompanyName(purCompany.getCompanyName());
            companyTechnology.setSupCompanyId(supCompany.getId());
            companyTechnology.setSupCompanySrmCode(supCompany.getCompanyCode());
            companyTechnology.setSupCompanyName(supCompany.getCompanyName());
            companyTechnology.setIsEnable(Constant.YES_INT);
            companyTechnology.setCreateTime(new Date());
            companyTechnology.setUpdateTime(new Date());
            companyTechnology.setFinishFlag(Constant.NO_INT);
            Integer finishFlag = companyTechnology.getFinishFlag();
            companyTechnology.setFinishFlag(finishFlag);
            this.addObj(companyTechnology);
            list.add(finishFlag);
        }
        if (list.contains(Constant.NO_INT)) {
            return 0;
        }
        return 1;
    }

    @Override
    @Transactional
    @CacheEvict(value={"companyTechnology"}, allEntries=true)
    public void deleteObjByIds(String projectId, Company company, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u4f20\u9012\u7684id\u5217\u8868\u4e3a\u7a7a!");
        }
        CompanyTechnologyExample example = new CompanyTechnologyExample();
        example.createCriteria().andProjectIdEqualTo(projectId).andSupCompanyIdEqualTo(company.getId()).andIdIn((List)ids);
        CompanyTechnology technology = new CompanyTechnology();
        technology.setIsEnable(Constant.NO_INT);
        this.companyTechnologyMapper.updateByExampleSelective(technology, example);
    }
}

