
CREATE TABLE "T_BASE_COMPANY_FILE" (
  "ID" VARCHAR2(32 BYTE) NOT NULL ,
  "PROJECT_ID" VARCHAR2(32 BYTE) NULL ,
  "SUP_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
  "FINISH_FLAG" NUMBER(7) DEFAULT 0  NULL ,
  "IS_ENABLE" NUMBER(7) DEFAULT 1  NULL ,
  "FILE_NAME" VARCHAR2(255 BYTE) NULL ,
  "CREATE_TIME" DATE NULL ,
  "UPDATE_TIME" DATE NULL ,
  "REMARK" VARCHAR2(1000 BYTE) NULL ,
  "ATTACHMENT" VARCHAR2(1000 BYTE) NULL
);

COMMENT ON TABLE "T_BASE_COMPANY_FILE" IS '供应商附件信息';

COMMENT ON COLUMN "T_BASE_COMPANY_FILE"."ID" IS 'ID';
COMMENT ON COLUMN "T_BASE_COMPANY_FILE"."PROJECT_ID" IS '项目ID';
COMMENT ON COLUMN "T_BASE_COMPANY_FILE"."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN "T_BASE_COMPANY_FILE"."FINISH_FLAG" IS '完成标识符（0=未完成，1=已完成）';
COMMENT ON COLUMN "T_BASE_COMPANY_FILE"."IS_ENABLE" IS '记录是否可用（0=不可用，1=可用）';
COMMENT ON COLUMN "T_BASE_COMPANY_FILE"."FILE_NAME" IS '文件名称';
COMMENT ON COLUMN "T_BASE_COMPANY_FILE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_COMPANY_FILE"."UPDATE_TIME" IS '更新时间';
COMMENT ON COLUMN "T_BASE_COMPANY_FILE"."REMARK" IS '备注';
COMMENT ON COLUMN "T_BASE_COMPANY_FILE"."ATTACHMENT" IS '附件';


ALTER TABLE "T_BASE_COMPANY_FILE" ADD CHECK ("ID" IS NOT NULL);
ALTER TABLE "T_BASE_COMPANY_FILE" ADD PRIMARY KEY ("ID");
