CREATE TABLE T_BASE_COMPANY_CUSTOMER (
"ID" VARCHAR2(32 BYTE) NOT NULL ,
"PROJECT_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"PUR_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"PUR_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_ID" VARCHAR2(32 BYTE) NULL ,
"SUP_COMPANY_SRM_CODE" VARCHAR2(255 BYTE) NULL ,
"SUP_COMPANY_NAME" VARCHAR2(255 BYTE) NULL ,
"CUSTOMER_NAME" VARCHAR2(255 BYTE) NULL ,
"INDUSTRY" VARCHAR2(255 BYTE) NULL ,
"AREA" VARCHAR2(255 BYTE) NULL ,
"PRODUCT_SERVICE" VARCHAR2(255 BYTE) NULL ,
"TOTAL_SALE_PERCENT" NUMBER(20,2) NULL ,
"START_TIME" DATE NULL ,
"EXPLAINATION"  VARCHAR2(1000 BYTE) NULL ,
"CAR_INDUSTRY_PERCENT" NUMBER(20,2) NULL,
"IS_ENABLE" NUMBER(7,0) DEFAULT 1 NULL,
"FINISH_FLAG" NUMBER(7,0) DEFAULT 0 NULL,
"CREATE_TIME" DATE DEFAULT SYSDATE  NULL ,
"UPDATE_TIME" DATE NULL 
)
;

COMMENT ON TABLE T_BASE_COMPANY_CUSTOMER IS '供应商准入-主要客户';
COMMENT ON COLUMN T_BASE_COMPANY_CUSTOMER."ID" IS '主键';
COMMENT ON COLUMN T_BASE_COMPANY_CUSTOMER."PROJECT_ID" IS '项目ID';
COMMENT ON COLUMN T_BASE_COMPANY_CUSTOMER."PUR_COMPANY_ID" IS '采购商公司ID';
COMMENT ON COLUMN T_BASE_COMPANY_CUSTOMER."PUR_COMPANY_SRM_CODE" IS '采购商SRM编码';
COMMENT ON COLUMN T_BASE_COMPANY_CUSTOMER."PUR_COMPANY_NAME" IS '采购商名称';
COMMENT ON COLUMN T_BASE_COMPANY_CUSTOMER."SUP_COMPANY_ID" IS '供应商ID';
COMMENT ON COLUMN T_BASE_COMPANY_CUSTOMER."SUP_COMPANY_SRM_CODE" IS '供应商SRM编码';
COMMENT ON COLUMN T_BASE_COMPANY_CUSTOMER."SUP_COMPANY_NAME" IS '供应商名称';
COMMENT ON COLUMN T_BASE_COMPANY_CUSTOMER."CUSTOMER_NAME" IS '主要客户名';
COMMENT ON COLUMN T_BASE_COMPANY_CUSTOMER."INDUSTRY" IS '行业';
COMMENT ON COLUMN T_BASE_COMPANY_CUSTOMER."AREA" IS '地区';
COMMENT ON COLUMN T_BASE_COMPANY_CUSTOMER."PRODUCT_SERVICE" IS '销售给该地区/客户的主要产品/服务';
COMMENT ON COLUMN T_BASE_COMPANY_CUSTOMER."TOTAL_SALE_PERCENT" IS '该地区/客户占企业总销售额的百分比';
COMMENT ON COLUMN T_BASE_COMPANY_CUSTOMER."START_TIME" IS '业务开始的时间';
COMMENT ON COLUMN T_BASE_COMPANY_CUSTOMER."EXPLAINATION" IS '说明';
COMMENT ON COLUMN T_BASE_COMPANY_CUSTOMER."CAR_INDUSTRY_PERCENT" IS '汽车行业占比';
COMMENT ON COLUMN T_BASE_COMPANY_CUSTOMER."IS_ENABLE" IS '记录是否可用(0=不可用，1=可用)';
COMMENT ON COLUMN T_BASE_COMPANY_CUSTOMER."FINISH_FLAG" IS '完成标识符(0=未完成，1=已完成)';
COMMENT ON COLUMN T_BASE_COMPANY_CUSTOMER."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN T_BASE_COMPANY_CUSTOMER."UPDATE_TIME" IS '修改时间';


ALTER TABLE T_BASE_COMPANY_CUSTOMER ADD CHECK ("ID" IS NOT NULL);
ALTER TABLE T_BASE_COMPANY_CUSTOMER ADD PRIMARY KEY ("ID");
