package com.els.base.certification.agent.service.impl;

import com.els.base.certification.agent.dao.AgentMapper;
import com.els.base.certification.agent.entity.Agent;
import com.els.base.certification.agent.entity.AgentExample;
import com.els.base.certification.agent.service.AgentService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.uuid.UUIDGenerator;

import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service("defaultAgentService")
public class AgentServiceImpl implements AgentService {
    @Resource
    protected AgentMapper agentMapper;

    @CacheEvict(value={"agent"}, allEntries=true)
    @Override
    public void addObj(Agent t) {
        this.agentMapper.insertSelective(t);
    }
    
    @Transactional
    @CacheEvict(value={"agent"}, allEntries=true)
    @Override
	public void batchInserts(String projectId, Company company, List<Agent> agentList) {
    	if (CollectionUtils.isEmpty(agentList)) {
    		return;
    	}
    	// 先删除原来的数据，再添加新的数据进去
    	AgentExample agentExample = new AgentExample();
    	agentExample.createCriteria().andProjectIdEqualTo(projectId)
    								.andCompanyIdEqualTo(company.getId())
    								.andIsEnableEqualTo(Constant.YES_INT);
    	Agent agent = new Agent();
    	agent.setIsEnable(Constant.NO_INT);
    	this.agentMapper.updateByExampleSelective(agent, agentExample);
    	// 批量插入数据
    	agentList.stream().forEach(item->{
            if (StringUtils.isBlank(item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
            item.setProjectId(projectId);
            item.setCompanyId(company.getId());
            item.setCompanySrmCode(company.getCompanyCode());
            item.setIsEnable(Constant.YES_INT);
            item.setCreateTime(new Date());
        });
    	this.agentMapper.insertBatch(agentList);
		
	}

    @Transactional
    @CacheEvict(value={"agent"}, allEntries=true)
    @Override
    public void addAll(List<Agent> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item->{
            if (StringUtils.isBlank(item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.agentMapper.insertBatch(list);
    }

    @CacheEvict(value={"agent"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.agentMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"agent"}, allEntries=true)
    @Override
    public void deleteByExample(AgentExample example) {
        Assert.isNotNull(example, "参数不能为空");
        Assert.isNotEmpty(example.getOredCriteria(), "批量删除不能全表删除");
        this.agentMapper.deleteByExample(example);
    }

    @CacheEvict(value={"agent"}, allEntries=true)
    @Override
    public void modifyObj(Agent t) {
        Assert.isNotBlank(t.getId(), "id 为空，无法修改");
        this.agentMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="agent", keyGenerator="redisKeyGenerator")
    @Override
    public Agent queryObjById(String id) {
        return this.agentMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="agent", keyGenerator="redisKeyGenerator")
    @Override
    public List<Agent> queryAllObjByExample(AgentExample example) {
        return this.agentMapper.selectByExample(example);
    }

    @Cacheable(value="agent", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<Agent> queryObjByPage(AgentExample example) {
        PageView<Agent> pageView = example.getPageView();
        pageView.setQueryResult(this.agentMapper.selectByExampleByPage(example));
        return pageView;
    }

}