package com.els.base.certification.apply.web.controller;


import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.certification.apply.entity.Apply;
import com.els.base.certification.apply.entity.ApplyExample;
import com.els.base.certification.apply.service.ApplyService;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value = "潜在供应商转入申请表")
@Controller
@RequestMapping("apply")
public class ApplyController {
	@Resource
	protected ApplyService applyService;

	@Resource
	protected CompanyService companyService;
	
	@ApiOperation(httpMethod = "POST", value = "创建潜在供应商转入申请表")
	@RequestMapping("service/create")
	@ResponseBody
	public ResponseResult<String> create(@RequestBody Apply apply) {
		Assert.isNotBlank(apply.getSupCompanySrmCode(), "供应商编码不能为空");
		String[] companyCode = apply.getSupCompanySrmCode().split(",");
		if(companyCode.length >= 2){
			throw new CommonException("一次只能选择一个供应商编码");
		}
		Assert.isNotBlank(apply.getSecondCompanyType1(), "产品大类1不能为空");
		Assert.isNotBlank(apply.getSecondCompanyType2(), "产品大类2不能为空");
		Assert.isNotBlank(apply.getSecondCompanyType3(), "产品大类3不能为空");
		Assert.isNotBlank(apply.getSecondCompanyType4(), "产品大类4不能为空");
		Assert.isNotBlank(apply.getSecondCompanyType5(), "产品大类5不能为空");
		/*for (int i = 0; i < companyCode.length; i++) {
			if(StringUtils.isBlank(companyCode[i])){
				throw new CommonException("供应商编码为空，保存失败");
			}
			apply.setSupCompanySrmCode(companyCode[i]);
		}*/
		
		/*if(apply.getSecondCompanyType1().equals(apply.getSecondCompanyType2()) || apply.getSecondCompanyType1().equals(apply.getSecondCompanyType3()) || 
			apply.getSecondCompanyType1().equals(apply.getSecondCompanyType4()) || apply.getSecondCompanyType1().equals(apply.getSecondCompanyType5()) ||
			apply.getSecondCompanyType2().equals(apply.getSecondCompanyType3()) || apply.getSecondCompanyType2().equals(apply.getSecondCompanyType4()) ||
			apply.getSecondCompanyType2().equals(apply.getSecondCompanyType5()) || apply.getSecondCompanyType3().equals(apply.getSecondCompanyType4()) ||
			apply.getSecondCompanyType3().equals(apply.getSecondCompanyType5()) || apply.getSecondCompanyType4().equals(apply.getSecondCompanyType5())
			){
			throw new CommonException("不能选择相同的产品大类");
		}*/
		User user=SpringSecurityUtils.getLoginUser();
		this.applyService.insert(user,apply);
		return ResponseResult.success();
	}

	@ApiOperation(httpMethod = "POST", value = "编辑潜在供应商转入申请表")
	@RequestMapping("service/edit")
	@ResponseBody
	public ResponseResult<String> edit(@RequestBody Apply apply) {
		if (StringUtils.isBlank(apply.getId())) {
			throw new CommonException("id 为空，保存失败");
		}
		this.applyService.modifyObj(apply);
		return ResponseResult.success();
	}

	@ApiOperation(httpMethod = "POST", value = "删除潜在供应商转入申请表信息")
	@RequestMapping("service/deleteByIds")
	@ResponseBody
	public ResponseResult<String> deleteByIds(@RequestBody List<Apply> supApply) {
		if(CollectionUtils.isEmpty(supApply)){
			throw new CommonException("删除失败,数据不能为空");
		}
			this.applyService.deleteObjByIds(supApply);
		
		return ResponseResult.success();
	}

	@ApiOperation(httpMethod = "POST", value = "作废潜在供应商转入申请表信息")
	@RequestMapping("service/invalidDocument")
	@ResponseBody
	public ResponseResult<String> invalidDocument(@RequestBody List<Apply> supApply) {
		if(CollectionUtils.isEmpty(supApply)){
			throw new CommonException("操作失败，数据不能为空");
		}
			this.applyService.updateIsInvalid(supApply);
		
		return ResponseResult.success();
	}

	@ApiOperation(httpMethod = "POST", value = "查询潜在供应商转入申请表")
	@ApiImplicitParams({ @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"), @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"), @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 Apply", paramType = "body", dataType = "QueryParamWapper") })
	@RequestMapping("service/findByPage")
	@ResponseBody
	public ResponseResult<PageView<Apply>> findByPage(@RequestParam(defaultValue = "0") int pageNo, @RequestParam(defaultValue = "10") int pageSize, @RequestBody(required = false) QueryParamWapper wapper) {
		ApplyExample example = new ApplyExample();
		example.setPageView(new PageView<Apply>(pageNo, pageSize));
		example.setOrderByClause("CREATE_TIME DESC");
		ApplyExample.Criteria criteria = example.createCriteria();
		

		if (wapper != null) {
			CriteriaUtils.addCriterion(criteria, wapper);
		}

		PageView<Apply> pageData = this.applyService.queryObjByPage(example);
		return ResponseResult.success(pageData);
	}
	
	@ApiOperation(httpMethod="POST", value="根据ID查看潜在供应商导入分析表单据详情")
	@RequestMapping("service/findDetailById")
	@ResponseBody
	public ResponseResult<Apply> findDetailById(@RequestParam(required=true) String id){
		Assert.isNotBlank(id, "单据的ID不能为空");
		Apply apply =this.applyService.queryObjById(id);
		return ResponseResult.success(apply);
	}
	
	@ApiOperation(httpMethod = "POST", value = "发送审批")
	@RequestMapping("service/sendApproval")
	@ResponseBody
	public ResponseResult<String> sendApproal(@RequestBody List<String> ids){
		if(CollectionUtils.isEmpty(ids)){
			throw new CommonException("发送失败，数据不能为空");
		}
		
		this.applyService.sendToApprove(ids);
		return ResponseResult.success();
	}
	
	@ApiOperation(httpMethod = "POST",value="潜在供应商导入分析表打印")
	@RequestMapping("service/print")
	@ResponseBody
	public ResponseResult<FileData> print(@RequestBody(required=true) List<Apply> data){
		Assert.isNotEmpty(data, "传输的数据为空");
		FileData fileData=this.applyService.print(ProjectUtils.getProjectId(),CompanyUtils.currentCompanyId(),data);
		return ResponseResult.success(fileData);
	}
	
	/*@ApiOperation(httpMethod = "POST" , value="陌生供应商转变为潜在供应商")
	@RequestMapping("service/strangeTurnPotential")
	@ResponseBody
	public ResponseResult<String> strangeTurnPotential(@RequestBody(required=true) List<String> ids ){
		Assert.isNotEmpty(ids, "传入的陌生供应商ID为空");
		this.applyService.changeToPotential(ids);
		return ResponseResult.success();
	}*/
}