package com.els.base.certification.auth.service;

import com.els.base.certification.auth.entity.CompanyAuth;
import com.els.base.certification.auth.entity.CompanyAuthExample;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.project.Project;
import com.els.base.core.service.BaseService;

import java.util.List;

public interface CompanyAuthService extends BaseService<CompanyAuth, CompanyAuthExample, String> {

    /**
     * 批量创建企业通过的认证
     * @param projectId
     * @param company
     * @param companyAuthList
     */
    Integer batchInsert(String projectId, Company company, List<CompanyAuth> companyAuthList);

    /**
     * 批量软删除
     * @param projectId
     * @param company
     * @param ids
     */
    void deleteObjByIds(String projectId, Company company, List<String> ids);

    /**
     * 判断是否已经填完资料
     * @param project
     * @param company
     * @return
     */
    Integer isFinish(Project project, Company company);
}