package com.els.base.certification.auth.web.controller;

import com.els.base.certification.auth.entity.CompanyAuth;
import com.els.base.certification.auth.entity.CompanyAuthExample;
import com.els.base.certification.auth.service.CompanyAuthService;
import com.els.base.certification.common.CompanyFinishFlag;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.utils.json.JsonUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Api(value="供应商准入-企业通过的认证")
@Controller
@RequestMapping("companyAuth")
public class CompanyAuthController {

    @Resource
    private CompanyAuthService companyAuthService;
    @Resource
    private CompanyService companyService;

   /* @ApiOperation(httpMethod="POST", value="查询企业通过的认证")
    public  ResponseResult<CompanyAuth>  queryObjById(@RequestParam(required=true)String id) {
        CompanyAuth companyAuth =this.companyAuthService.queryObjById(id);
        return ResponseResult.success(companyAuth);
    }*/

    @ApiOperation(httpMethod="POST", value="批量创建企业通过的认证")
    @RequestMapping("service/batchInsert")
    @ResponseBody
    public ResponseResult<Map<String, Integer>> batchInsert(@RequestBody List<CompanyAuth> companyAuthList) {
        CompanyFinishFlag companyFinishFlag =new CompanyFinishFlag();
        if (CollectionUtils.isEmpty(companyAuthList)) {
            throw new CommonException("数据不能为空", "base_canot_be_null", "操作失败，数据");
        }
        Integer auth = this.companyAuthService.batchInsert(ProjectUtils.getProjectId(), CompanyUtils.currentCompany(), companyAuthList);
        companyFinishFlag.setThroughAuthentication(auth);
        
        Map<String, Integer> map = new HashMap<>();
        map.put("throughAuthentication", auth);
        return ResponseResult.success(map);
    }

   /* @ApiOperation(httpMethod="POST", value="创建企业通过的认证")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody CompanyAuth companyAuth) {
        this.companyAuthService.addObj(companyAuth);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑企业通过的认证")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody CompanyAuth companyAuth) {
        if (StringUtils.isBlank(companyAuth.getId())) {
            throw new CommonException("id 为空，保存失败");
        }
        this.companyAuthService.modifyObj(companyAuth);
        return ResponseResult.success();
    }*/

   /* @ApiOperation(httpMethod="POST", value="删除企业通过的认证")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank(id)) {
            throw new CommonException("删除失败,id不能为空");
        }
        List<String> ids = new ArrayList<String>();
        ids.add(id);
        this.companyAuthService.deleteObjByIds(ProjectUtils.getProjectId(), CompanyUtils.currentCompany(),ids);
        return ResponseResult.success();
    }*/


    @ApiOperation(httpMethod="POST", value="批量删除企业通过的认证")
    @RequestMapping("service/deleteByIds")
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("删除失败,id不能为空");
        }
        this.companyAuthService.deleteObjByIds(ProjectUtils.getProjectId(), CompanyUtils.currentCompany(),ids);
        return ResponseResult.success();
    }


    @ApiOperation(httpMethod="POST", value="分页查询企业通过的认证")
    @ApiImplicitParams({
            @ApiImplicitParam( name = "supCompanySrmCode", required = false, value = "供应商SRM编码", paramType = "query", dataType = "String"),
         @ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),
         @ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),
         @ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 CompanyAuth", paramType = "body", dataType = "QueryParamWapper" )
    })
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<CompanyAuth>> findByPage(
            @RequestParam(required=false) String supCompanySrmCode,
         @RequestParam(defaultValue="0") int pageNo,
         @RequestParam(defaultValue="10") int pageSize,
         @RequestBody(required=false) QueryParamWapper wapper) throws IOException {

        CompanyAuthExample example = new CompanyAuthExample();
        example.setPageView(new PageView<CompanyAuth>(pageNo, pageSize));
        CompanyAuthExample.Criteria criteria = example.createCriteria();

        if(StringUtils.isBlank(supCompanySrmCode)){
            //添加查询条件
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId())
                    .andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId())
                    .andIsEnableEqualTo(Constant.YES_INT);
        }else{
            //否则则按照该编码进行查询
            Company company = companyService.queryCompanyByCode(supCompanySrmCode);
            if(company==null){
                throw new CommonException("公司不存在，请检查");
            }
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId())
                    .andSupCompanyIdEqualTo(company.getId())
                    .andIsEnableEqualTo(Constant.YES_INT);
        }

        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        
        PageView<CompanyAuth> pageData = this.companyAuthService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }


    @ApiOperation(httpMethod="POST", value="查询全部企业通过的认证")
    @ApiImplicitParams({
            @ApiImplicitParam( name = "supCompanySrmCode", required = false, value = "供应商SRM编码", paramType = "query", dataType = "String"),
            @ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 CompanyAuth", paramType = "body", dataType = "QueryParamWapper" )
    })
    @RequestMapping("service/findAll")
    @ResponseBody
    public ResponseResult<List<CompanyAuth>> findAll(
            @RequestParam(required=false) String supCompanySrmCode,
            @RequestBody(required=false) QueryParamWapper wapper) throws IOException {

        CompanyAuthExample example = new CompanyAuthExample();
        CompanyAuthExample.Criteria criteria = example.createCriteria();

        if(StringUtils.isBlank(supCompanySrmCode)){
            //添加查询条件
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId())
                    .andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId())
                    .andIsEnableEqualTo(Constant.YES_INT);
        }else{
            //否则则按照该编码进行查询
            Company company = companyService.queryCompanyByCode(supCompanySrmCode);
            if(company==null){
                throw new CommonException("公司不存在，请检查");
            }
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId())
                    .andSupCompanyIdEqualTo(company.getId())
                    .andIsEnableEqualTo(Constant.YES_INT);
        }

        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }

        List<CompanyAuth> companyAuthList = this.companyAuthService.queryAllObjByExample(example);
        return ResponseResult.success(companyAuthList);
    }

}