package com.els.base.certification.business.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;

@ApiModel(value="供应商准入基础资料-供应商经营产品")
public class Business implements Serializable {
    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("供应商ID")
    private String supCompanyId;

    @ApiModelProperty("承制产品名称")
    private String bearingProductsName;

    @ApiModelProperty("规格、型号或图号")
    private String specificationModel;

    @ApiModelProperty("产品重要等级(A,B,C)")
    private String productGrade;

    @ApiModelProperty("是否可用（1可用，0不可用）")
    private Integer isEnable;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getSupCompanyId() {
        return supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    public String getBearingProductsName() {
        return bearingProductsName;
    }

    public void setBearingProductsName(String bearingProductsName) {
        this.bearingProductsName = bearingProductsName == null ? null : bearingProductsName.trim();
    }

    public String getSpecificationModel() {
        return specificationModel;
    }

    public void setSpecificationModel(String specificationModel) {
        this.specificationModel = specificationModel == null ? null : specificationModel.trim();
    }

    public String getProductGrade() {
        return productGrade;
    }

    public void setProductGrade(String productGrade) {
        this.productGrade = productGrade == null ? null : productGrade.trim();
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }
}