package com.els.base.certification.business.web.controller;

import com.els.base.certification.business.entity.Business;
import com.els.base.certification.business.entity.BusinessExample;
import com.els.base.certification.business.service.BusinessService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.ResponseCode;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="供应商准入基础资料-供应商经营产品")
@Controller
@RequestMapping("business")
public class BusinessController {
    @Resource
    protected BusinessService businessService;
    
    @ApiOperation(httpMethod="POST", value="批量创建供应商准入基础资料-供应商经营产品")
    @RequestMapping("service/insert")
    @ResponseBody
    public ResponseResult<String> insert(@RequestBody List<Business> businessList) {
    	Assert.isNotEmpty(businessList, "传入的数据不能为空");
    	this.businessService.insertObj(CompanyUtils.currentCompany(),businessList);
    	return ResponseResult.success();
    }
    
    @ApiOperation(httpMethod="POST", value="批量删除供应商准入基础资料-供应商经营产品")
    @RequestMapping("service/deleteByIds")
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestParam(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, "数据ID不能为空");
        this.businessService.deleteObjByIds(CompanyUtils.currentCompanyId(),ids);
        return ResponseResult.success();
    }

//    @ApiOperation(httpMethod="POST", value="创建供应商准入基础资料-供应商经营产品")
//    @RequestMapping("service/create")
//    @ResponseBody
//    public ResponseResult<String> create(@RequestBody Business business) {
//        this.businessService.addObj(business);
//        return ResponseResult.success();
//    }
    

//    @ApiOperation(httpMethod="POST", value="编辑供应商准入基础资料-供应商经营产品")
//    @RequestMapping("service/edit")
//    @ResponseBody
//    public ResponseResult<String> edit(@RequestBody Business business) {
//        Assert.isNotBlank(business.getId(), "id 为空，保存失败");
//        this.businessService.modifyObj(business);
//        return ResponseResult.success();
//    }
//
//    @ApiOperation(httpMethod="POST", value="删除供应商准入基础资料-供应商经营产品")
//    @RequestMapping("service/deleteById")
//    @ResponseBody
//    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
//        Assert.isNotBlank(id, "删除失败,id不能为空");
//        this.businessService.deleteObjById(id);
//        return ResponseResult.success();
//    }

    @ApiOperation(httpMethod="POST", value="查询供应商准入基础资料-供应商经营产品")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 Business", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<Business>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        BusinessExample example = new BusinessExample();
        example.setPageView(new PageView<Business>(pageNo, pageSize));
        
        BusinessExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<Business> pageData = this.businessService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}