package com.els.base.certification.certificate.service.impl;

import com.els.base.certification.certificate.dao.CertificateExpiryMapper;
import com.els.base.certification.certificate.entity.CertificateExpiry;
import com.els.base.certification.certificate.entity.CertificateExpiryExample;
import com.els.base.certification.certificate.service.CertificateExpiryService;
import com.els.base.certification.common.CertificateTypeCodeEnum;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;

import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service("defaultCertificateExpiryService")
public class CertificateExpiryServiceImpl implements CertificateExpiryService {
    @Resource
    protected CertificateExpiryMapper certificateExpiryMapper;
    
    @CacheEvict(value={"certificateExpiry"}, allEntries=true)
    @Override
	public void insert(Company purCompany, User loginUser, CertificateExpiry certificateExpiry) {
    	Assert.isNotBlank(certificateExpiry.getClassificationCode(), "分类编码不能为空");
		Assert.isNotBlank(certificateExpiry.getClassificationName(), "分类名称不能为空");
		if (Constant.YES_INT == certificateExpiry.getIsEnableReminders()) {
			Assert.isNotNull(certificateExpiry.getAdvanceReminderDays(), "提前提醒天数不能为空");
		}
    	CertificateExpiryExample example = new CertificateExpiryExample();
    	example.createCriteria().andClassificationNameEqualTo(certificateExpiry.getClassificationName())
    		.andIsEnableEqualTo(Constant.YES_INT);
    	if (this.certificateExpiryMapper.countByExample(example) > 0) {
    		throw new CommonException("分类名称"+ CertificateTypeCodeEnum.getDesc(certificateExpiry.getClassificationName()) + "已存在，不能再创建");
    	}
    	example.clear();
    	example.createCriteria()
    		.andClassificationCodeEqualTo(certificateExpiry.getClassificationCode())
    		.andIsEnableEqualTo(Constant.YES_INT);
    	if (this.certificateExpiryMapper.countByExample(example) > 0) {
    		throw new CommonException("分类编码" +certificateExpiry.getClassificationCode()+"已存在，不能再创建");
    	}
    	
    	// 设置采购商信息
    	this.setPurCompanyInfo(purCompany,loginUser,certificateExpiry);
		
    	certificateExpiry.setCreateTime(new Date());
    	this.certificateExpiryMapper.insertSelective(certificateExpiry);
	}
    
    /**
     * 设置采购商信息
     * @param purCompany
     * @param loginUser
     * @param certificateExpiry
     */
    private void setPurCompanyInfo(Company purCompany, User loginUser, CertificateExpiry certificateExpiry) {
		// 设置采购商信息
		certificateExpiry.setPurCompanyId(purCompany.getId());
		certificateExpiry.setPurCompanyName(purCompany.getCompanyName());
		certificateExpiry.setPurCompanySrmCode(purCompany.getCompanyCode());
		certificateExpiry.setPurUserId(loginUser.getId());
		// 创建人
		certificateExpiry.setFounder(loginUser.getNickName());
		// 是否可用
		certificateExpiry.setIsEnable(Constant.YES_INT);
		
	}
    
    @CacheEvict(value={"certificateExpiry"}, allEntries=true)
    @Override
	public void updateObj(Company purCompany, User loginUser, CertificateExpiry certificateExpiry) {
    	// 判断分类名称是否改变
    	CertificateExpiry certificate = this.queryObjById(certificateExpiry.getId());
    	CertificateExpiryExample example = new CertificateExpiryExample();
    	if (!certificate.getClassificationName().equals(certificateExpiry.getClassificationName())) {
    		example.createCriteria().andClassificationNameEqualTo(certificateExpiry.getClassificationName())
    			.andIsEnableEqualTo(Constant.YES_INT);
    		if (this.certificateExpiryMapper.countByExample(example) > 0) {
    			throw new CommonException("此分类名称已存在，不能改成：" + certificateExpiry.getClassificationName());
    		}
    	} 
    	example.clear();
    	// 如果修改了分类编码，判断此编码是否已创建单据
    	if (!certificate.getClassificationCode().equals(certificateExpiry.getClassificationCode())) {
    		example.createCriteria()
    			.andClassificationCodeEqualTo(certificateExpiry.getClassificationCode())
    			.andIsEnableEqualTo(Constant.YES_INT);
    		if (this.certificateExpiryMapper.countByExample(example) > 0) {
    			throw new CommonException("分类编码："+ certificateExpiry.getClassificationCode() +"已存在，不能再使用此编码创建单据");
    		}
    	}
    	
    	// 设置采购商信息
    	this.setPurCompanyInfo(purCompany, loginUser, certificateExpiry);
    	certificateExpiry.setUpdateTime(new Date());
    	this.certificateExpiryMapper.updateByPrimaryKeySelective(certificateExpiry);
		
	}

	@CacheEvict(value={"certificateExpiry"}, allEntries=true)
    @Override
	public void deleteObjByIds(List<String> ids) {
    	CertificateExpiryExample example = new CertificateExpiryExample();
    	example.createCriteria().andIdIn(ids).andIsEnableEqualTo(Constant.YES_INT);
    	CertificateExpiry certificateExpiry = new CertificateExpiry();
    	certificateExpiry.setIsEnable(Constant.NO_INT);
    	this.certificateExpiryMapper.updateByExampleSelective(certificateExpiry, example);
		
	}


    @CacheEvict(value={"certificateExpiry"}, allEntries=true)
    @Override
    public void addObj(CertificateExpiry t) {
        this.certificateExpiryMapper.insertSelective(t);
    }

    @CacheEvict(value={"certificateExpiry"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.certificateExpiryMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"certificateExpiry"}, allEntries=true)
    @Override
    public void modifyObj(CertificateExpiry t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.certificateExpiryMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="certificateExpiry", keyGenerator="redisKeyGenerator")
    @Override
    public CertificateExpiry queryObjById(String id) {
        return this.certificateExpiryMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="certificateExpiry", keyGenerator="redisKeyGenerator")
    @Override
    public List<CertificateExpiry> queryAllObjByExample(CertificateExpiryExample example) {
        return this.certificateExpiryMapper.selectByExample(example);
    }

    @Cacheable(value="certificateExpiry", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<CertificateExpiry> queryObjByPage(CertificateExpiryExample example) {
        PageView<CertificateExpiry> pageView = example.getPageView();
        pageView.setQueryResult(this.certificateExpiryMapper.selectByExampleByPage(example));
        return pageView;
    }

}