package com.els.base.certification.certificate.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.certification.certificate.entity.CertificateExpiry;
import com.els.base.certification.certificate.entity.CertificateExpiryExample;
import com.els.base.certification.certificate.service.CertificateExpiryService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="供应商准入-证书到期提醒")
@Controller
@RequestMapping("certificateExpiry")
public class CertificateExpiryController {
    @Resource
    protected CertificateExpiryService certificateExpiryService;
    
    @ApiOperation(httpMethod="POST", value="创建供应商准入-证书到期提醒")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody CertificateExpiry certificateExpiry) {
        Assert.isNotNull(certificateExpiry, "保存的数据不能为空");
    	this.certificateExpiryService.insert(CompanyUtils.currentCompany(),SpringSecurityUtils.getLoginUser(),certificateExpiry);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑供应商准入-证书到期提醒")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody CertificateExpiry certificateExpiry) {
        Assert.isNotBlank(certificateExpiry.getId(), "id 为空，保存失败");
        this.certificateExpiryService.updateObj(CompanyUtils.currentCompany(),SpringSecurityUtils.getLoginUser(),certificateExpiry);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除供应商准入-证书到期提醒")
    @RequestMapping("service/deleteByIds")
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, "删除失败,id不能为空");
        this.certificateExpiryService.deleteObjByIds(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询供应商准入-证书到期提醒")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 CertificateExpiry", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<CertificateExpiry>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        CertificateExpiryExample example = new CertificateExpiryExample();
        example.setPageView(new PageView<CertificateExpiry>(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        
        CertificateExpiryExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        //填写具体的查询条件，例如
        //criteria.andIdEqualTo("1");
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<CertificateExpiry> pageData = this.certificateExpiryService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}