package com.els.base.certification.common;

import org.apache.commons.lang3.StringUtils;

/**
 * 证书类型枚举
 */
public enum CertificateTypeCodeEnum {

    IOS9001("ios9001","ISO9001体系证书"),
    IATF16949("iatf16949","IATF16949体系证书"),
    IOS14000("ios14000","ISO14000证书"),
    LICENSE("license","营业执照/登记证书"),
    PROXY_CARD("proxyCard","代理证/授权书"),
    CERTIFICATE_15085("15085","15085证书"),
    ISOTS_22163("iso22163","ISO/TS 22163证书"),
    OTHER("other","其它证书") ,
	PATENT("patent","专利/许可"),
	AGENT("agent","代理证书"),
	QUALITY("quality","生产商质量证书");

    private  String code;
    private  String desc;

    CertificateTypeCodeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
    
    public static String getDesc(String code) {
    	if (StringUtils.isBlank(code)) {
    		return null;
    	}
    	switch(code) {
    	case "ios9001":
    		return CertificateTypeCodeEnum.IOS9001.getDesc();
    	case "iatf16949":
    		return CertificateTypeCodeEnum.IATF16949.getDesc();
    	case "ios14000":
    		return CertificateTypeCodeEnum.IOS14000.getDesc();
    	case "license":
    		return CertificateTypeCodeEnum.LICENSE.getDesc();
    	case "proxyCard":
    		return CertificateTypeCodeEnum.PROXY_CARD.getDesc();
    	case "15085":
    		return CertificateTypeCodeEnum.CERTIFICATE_15085.getDesc();
    	case "iso22163":
    		return CertificateTypeCodeEnum.ISOTS_22163.getDesc();
    	case "other":
    		return CertificateTypeCodeEnum.OTHER.getDesc();
    	case "patent":
    		return CertificateTypeCodeEnum.PATENT.getDesc();
    	case "agent":
    		return CertificateTypeCodeEnum.AGENT.getDesc();
    	case "quality":
    		return CertificateTypeCodeEnum.QUALITY.getDesc();
    	default : break;	
    	}
    	return null;
    }


}
