package com.els.base.certification.company.service;

import java.util.List;

import com.els.base.auth.entity.User;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.project.Project;
import com.els.base.file.entity.FileData;
import com.els.base.utils.excel.TitleAndModelKey;


public interface SupplierService {

    /**
     * 提交资料接口
     * @param project
     * @param company
     * @param loginUser
     */
    void audit(Project project, Company company, User loginUser);
    
    /**
     * 供应商基础资料打印
     * @param projectId
     * @param currentCompanyId
     * @param company
     * @return
     */
	FileData print(String projectId, String companyId, List<Company> companys);
	
	/**
	 * 创建要到处的头
	 * @return
	 */
	List<TitleAndModelKey> createExcelHeaderForPur();
}
