package com.els.base.certification.company.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.auth.entity.User;
import com.els.base.certification.auth.entity.CompanyAuth;
import com.els.base.certification.auth.entity.CompanyAuthExample;
import com.els.base.certification.auth.service.CompanyAuthService;
import com.els.base.certification.company.service.SupplierService;
import com.els.base.certification.company.util.CompanyInfoUtils;
import com.els.base.certification.contacts.entity.Contacts;
import com.els.base.certification.contacts.entity.ContactsExample;
import com.els.base.certification.contacts.service.ContactsService;
import com.els.base.certification.contrast.utils.CompanyContrastApproveEnum;
import com.els.base.certification.customer.entity.CompanyCustomer;
import com.els.base.certification.customer.entity.CompanyCustomerExample;
import com.els.base.certification.customer.service.CompanyCustomerService;
import com.els.base.certification.device.entity.CompanyProductDevice;
import com.els.base.certification.device.entity.CompanyProductDeviceExample;
import com.els.base.certification.device.service.CompanyProductDeviceService;
import com.els.base.certification.equipment.entity.CompanyEquipment;
import com.els.base.certification.equipment.entity.CompanyEquipmentExample;
import com.els.base.certification.equipment.service.CompanyEquipmentService;
import com.els.base.certification.file.service.CompanyFileService;
import com.els.base.certification.finance.entity.CompanyFinance;
import com.els.base.certification.finance.entity.CompanyFinanceExample;
import com.els.base.certification.finance.service.CompanyFinanceService;
import com.els.base.certification.patents.entity.CompanyPatents;
import com.els.base.certification.patents.entity.CompanyPatentsExample;
import com.els.base.certification.patents.service.CompanyPatentsService;
import com.els.base.certification.productservice.entity.CompanyProductService;
import com.els.base.certification.productservice.entity.CompanyProductServiceExample;
import com.els.base.certification.productservice.service.CompanyProductServiceService;
import com.els.base.certification.rawmaterial.entity.CompanyRawMaterial;
import com.els.base.certification.rawmaterial.entity.CompanyRawMaterialExample;
import com.els.base.certification.rawmaterial.service.CompanyRawMaterialService;
import com.els.base.certification.relation.entity.CompanySupplyRelation;
import com.els.base.certification.relation.entity.CompanySupplyRelationExample;
import com.els.base.certification.relation.service.CompanySupplyRelationService;
import com.els.base.certification.technology.entity.CompanyTechnology;
import com.els.base.certification.technology.entity.CompanyTechnologyExample;
import com.els.base.certification.technology.service.CompanyTechnologyService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.project.Project;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.file.entity.FileData;
import com.els.base.utils.excel.DateConverter;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;


@Service("defaultSupplierCompanyService")
public class SupplierServiceImpl implements SupplierService {

    @Resource
    private CompanyService companyService;
    @Resource
    private CompanyAuthService companyAuthService;
    @Resource
    private CompanyPatentsService companyPatentsService;
    @Resource
    private CompanyFinanceService companyFinanceService;
    @Resource
    private CompanySupplyRelationService companySupplyRelationService;
    @Resource
    private CompanyFileService companyFileService;
    @Resource
    private CompanyEquipmentService companyEquipmentService;
    @Resource
    private CompanyProductDeviceService companyProductDeviceService;
    @Resource
    private CompanyTechnologyService companyTechnologyService;
    @Resource
    private CompanyRawMaterialService companyRawMaterialService;
    @Resource
    private CompanyCustomerService companyCustomerService;
    @Resource
    private CompanyProductServiceService companyProductServiceService;
    @Resource
    private ContactsService contactsService;

    @Transactional
    @Override
    public void audit(Project project, Company company, User loginUser) {
        List<Integer> finish = getFinishStatus(project,company);

        //校验是否已经填写完整
        if(CollectionUtils.isEmpty(finish)){
            throw new CommonException("资料完成状态不能为空!");
        }
        if(finish.contains(Constant.NO_INT)){
            throw new CommonException("有资料还没有填写完，提交审核失败。请重新检查资料是否已经填写完整，谢谢!");
        }

        //更新为已审核的状态
        company.setApproveStatus(CompanyContrastApproveEnum.STATUS_APPROVING.getStatus());
        company.setApproveTime(new Date());
        company.setApproveUserName(loginUser.getNickName());

        this.companyService.modifyObj(company);

    }

    /**
     * 获取资料是否填写完成的状态
     * @param project
     * @param company
     * @return
     */
    private List<Integer> getFinishStatus(Project project, Company company) {
        List<Integer> finish = new ArrayList<>();

        //企业基本信息
        finish.add(companyService.isFinish(company));

        //联系人信息
        finish.add(contactsService.isFinish(project,company));

        //主要产品/服务
        finish.add(companyProductServiceService.isFinish(project,company));

        //主要客户
        finish.add(companyCustomerService.isFinish(project,company));

        //主要供应商/原材料
        finish.add(companyRawMaterialService.isFinish(project,company));

        //主要技术
        finish.add(companyTechnologyService.isFinish(project,company));

        //关键生产设备
        finish.add(companyProductDeviceService.isFinish(project,company));

        //关键试验/检测设备
        finish.add(companyEquipmentService.isFinish(project,company));

        //企业通过的认证
        finish.add(companyAuthService.isFinish(project,company));

        //专利/专有技术/许可
        finish.add(companyPatentsService.isFinish(project,company));

        //财务信息
        finish.add(companyFinanceService.isFinish(project,company));

        //员工供货关系
        finish.add(companySupplyRelationService.isFinish(project,company));

        //附件
        finish.add(companyFileService.isFinish(project,company));

        return finish;
    }
    
    @CacheEvict(value={"supplier"}, allEntries=true)
	@Override
	public FileData print(String projectId, String companyId, List<Company> companyList) {
		Assert.isNotEmpty(companyList, "传输的数据为空，不能打印");
		// 创建文件信息
		FileData fileData = null;
		for (Company com : companyList) {

			Assert.isNotBlank(com.getCompanyCode(), "供应商编码为空");
			// 根据ID查询供应商数据
			Company company = this.companyService.queryCompanyByCode(com.getCompanyCode());
			Assert.isNotNull(company, "根据供应商编码查询的数据为空，无法打印");

			// 根据供应商ID查询联系人信息
			ContactsExample contactsExample = new ContactsExample();
			contactsExample.createCriteria().andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
			List<Contacts> contactsList = this.contactsService.queryAllObjByExample(contactsExample);
//			Assert.isNotEmpty(contactsList, "根据供应商ID查询的联系人信息为空");
			// 根据供应商ID查询主要产品/服务信息
			CompanyProductServiceExample productServiceExample = new CompanyProductServiceExample();
			productServiceExample.createCriteria().andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
			List<CompanyProductService> productList = this.companyProductServiceService.queryAllObjByExample(productServiceExample);
//			Assert.isNotEmpty(productList, "根据供应商ID查询的主要产品/服务信息为空");
			// 根据供应商ID查询主要客户信息
			CompanyCustomerExample customerExample = new CompanyCustomerExample();
			customerExample.createCriteria().andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
			List<CompanyCustomer> customerList = this.companyCustomerService.queryAllObjByExample(customerExample);
//			Assert.isNotEmpty(customerList, "根据供应商ID查询的主要客户信息为空");
			// 根据供应商ID查询主要供应商/原材料信息
			CompanyRawMaterialExample rawMaterialExample = new CompanyRawMaterialExample();
			rawMaterialExample.createCriteria().andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
			List<CompanyRawMaterial> rawMaterialList = this.companyRawMaterialService.queryAllObjByExample(rawMaterialExample);
//			Assert.isNotEmpty(rawMaterialList, "根据供应商ID查询的主要供应商/原材料信息为空");
			// 根据供应商ID查询主要技术信息
			CompanyTechnologyExample technologyExample = new CompanyTechnologyExample();
			technologyExample.createCriteria().andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
			List<CompanyTechnology> technologyList = this.companyTechnologyService.queryAllObjByExample(technologyExample);
//			Assert.isNotEmpty(technologyList, "根据供应商ID查询的主要技术信息为空");
			// 根据供应商ID查询关键生产设备信息
			CompanyProductDeviceExample deviceExample = new CompanyProductDeviceExample();
			deviceExample.createCriteria().andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
			List<CompanyProductDevice> deviceList = this.companyProductDeviceService.queryAllObjByExample(deviceExample);
//			Assert.isNotEmpty(deviceList, "根据供应商ID查询的关键生产设备信息为空");
			// 根据供应商ID查询关键试验/检测设备信息
			CompanyEquipmentExample equipmentExample = new CompanyEquipmentExample();
			equipmentExample.createCriteria().andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
			List<CompanyEquipment> equipmentList = this.companyEquipmentService.queryAllObjByExample(equipmentExample);
//			Assert.isNotEmpty(equipmentList, "根据供应商ID查询的关键试验/检测设备信息为空");
			// 根据供应商ID查询企业通过的认证信息
			CompanyAuthExample authExample = new CompanyAuthExample();
			authExample.createCriteria().andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
			List<CompanyAuth> authList = this.companyAuthService.queryAllObjByExample(authExample);
//			Assert.isNotEmpty(authList, "根据供应商ID查询的企业通过的认证信息为空");
			// 根据供应商ID查询专利/专有技术/许可信息
			CompanyPatentsExample patentsExample = new CompanyPatentsExample();
			patentsExample.createCriteria().andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
			List<CompanyPatents> patentsList = this.companyPatentsService.queryAllObjByExample(patentsExample);
//			Assert.isNotEmpty(patentsList, "根据供应商ID查询的专利/专有技术/许可信息为空");
			// 根据供应商ID查询财务信息
			CompanyFinanceExample financeExample = new CompanyFinanceExample();
			financeExample.createCriteria().andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
			List<CompanyFinance> financeList = this.companyFinanceService.queryAllObjByExample(financeExample);
//			Assert.isNotEmpty(financeList, "根据供应商ID查询的财务信息为空");
			// 根据供应商ID查询员工供货关系信息
			CompanySupplyRelationExample supplyExample = new CompanySupplyRelationExample();
			supplyExample.createCriteria().andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
			List<CompanySupplyRelation> supplyList = this.companySupplyRelationService.queryAllObjByExample(supplyExample);
//			Assert.isNotEmpty(supplyList, "根据供应商ID查询的员工供货关系信息为空");
			// 创建打印数据
			Map<String, Object> params = new HashMap<String, Object>();
			params.put("company", company);
			params.put("contacts", contactsList);
			params.put("productList", productList);
			params.put("customerList", customerList);
			params.put("rawMaterialList", rawMaterialList);
			params.put("technologyList", technologyList);
			params.put("deviceList", deviceList);
			params.put("equipmentList", equipmentList);
			params.put("authList", authList);
			params.put("patentsList", patentsList);
			params.put("financeList", financeList);
			params.put("supplyList", supplyList);
			
			try {
				fileData = CompanyInfoUtils.generatePdf(projectId, companyId, params, "A4");
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return fileData;
	}
    
    @CacheEvict(value={"supplier"}, allEntries=true)
	@Override
	public List<TitleAndModelKey> createExcelHeaderForPur() {
    	DateConverter dateConverter =new DateConverter();
		dateConverter.setDateFormat("yyyy-MM-dd");
    	List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
    	titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("SRM供应商编码", "companyCode"));
    	titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("SAP供应商编码", "companySapCode"));
    	titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("简称", "companyName"));
    	titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("产品大类1", "secondCompanyTypeDesc1"));
    	titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("产品大类2", "secondCompanyTypeDesc2"));
    	titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("产品大类3", "secondCompanyTypeDesc3"));
    	titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("产品大类4", "secondCompanyTypeDesc4"));
    	titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("产品大类5", "secondCompanyTypeDesc5"));
    	titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商服务类", "firstCompanyTypeDesc"));
    	titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商风险类", "businessTypeDesc"));
    	titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商资查类", "classificationThreeDesc"));
    	titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("英文简称", "companyEnglishAbbreviation"));
    	titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商全称", "companyFullName"));
    	titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("英文全称", "englishCompanyName"));
    	titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("代理品牌", "actingBrand"));
    	
    	titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("ISO9001体系证书", "ISO9001FileName"));
    	TitleAndModelKey ISO9001EndTime=ExcelUtils.createTitleAndModelKey("ISO9001体系证书有效期", "ISO9001EndTime");
    	ISO9001EndTime.setToObjConverter(dateConverter);
    	ISO9001EndTime.setToStrConverter(dateConverter);
    	titleAndModelKeys.add(ISO9001EndTime);
    	
    	titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("IATF16949体系证书", "IATF16949FileName"));
    	TitleAndModelKey IATF16949EndTime=ExcelUtils.createTitleAndModelKey("IATF16949体系证书有效期", "IATF16949EndTime");
    	IATF16949EndTime.setToObjConverter(dateConverter);
    	IATF16949EndTime.setToStrConverter(dateConverter);
    	titleAndModelKeys.add(IATF16949EndTime);
    	
    	titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("ISO14000体系证书", "ISO14000FileName"));
    	TitleAndModelKey ISO14000EndTime=ExcelUtils.createTitleAndModelKey("ISO14000证书有效期", "ISO14000EndTime");
    	ISO14000EndTime.setToObjConverter(dateConverter);
    	ISO14000EndTime.setToStrConverter(dateConverter);
    	titleAndModelKeys.add(ISO14000EndTime);
    	
    	titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("负责人", "contacts"));
    	titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("E-MAIL", "email"));
    	titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("TEL(一)", "telephone"));
    	titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("FAXNO", "fax"));
    	titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("联系地址(中文)", "address"));
    	titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("英文地址", "englishAddress"));
    	titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("经营范围", "businessScope"));
    	
    	TitleAndModelKey createTime=ExcelUtils.createTitleAndModelKey("注册时间", "createTime");
    	createTime.setToObjConverter(dateConverter);
    	createTime.setToStrConverter(dateConverter);
    	titleAndModelKeys.add(createTime);
    	
		return titleAndModelKeys;
	}
}
