package com.els.base.certification.company.web.controller;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.certification.auth.entity.CompanyAuth;
import com.els.base.certification.auth.entity.CompanyAuthExample;
import com.els.base.certification.auth.service.CompanyAuthService;
import com.els.base.certification.common.CertificateTypeCodeEnum;
import com.els.base.certification.common.CompanyFinishFlag;
import com.els.base.certification.company.entity.Supplier;
import com.els.base.certification.company.service.SupplierService;
import com.els.base.certification.company.util.ClassificationThreeEnum;
import com.els.base.certification.company.util.ExcelFileData;
import com.els.base.certification.contacts.service.ContactsService;
import com.els.base.certification.customer.service.CompanyCustomerService;
import com.els.base.certification.device.service.CompanyProductDeviceService;
import com.els.base.certification.equipment.service.CompanyEquipmentService;
import com.els.base.certification.file.service.CompanyFileService;
import com.els.base.certification.finance.service.CompanyFinanceService;
import com.els.base.certification.patents.service.CompanyPatentsService;
import com.els.base.certification.process.entity.Process;
import com.els.base.certification.process.entity.ProcessExample;
import com.els.base.certification.process.service.ProcessService;
import com.els.base.certification.productservice.service.CompanyProductServiceService;
import com.els.base.certification.rawmaterial.service.CompanyRawMaterialService;
import com.els.base.certification.relation.service.CompanySupplyRelationService;
import com.els.base.certification.technology.service.CompanyTechnologyService;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.company.utils.PartnerRoleEnum;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.dictionary.DicGroupItem;
import com.els.base.core.entity.project.Project;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.dictionary.DicGroupItemService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.utils.excel.TitleAndModelKey;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import jxl.write.WriteException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

@Api(value = "供应商准入-查询供应商信息")
@Controller("defaultSupplierCompanyController")
@RequestMapping("supplier")
public class SupplierController {

	@Resource
	private CompanyService companyService;
	@Resource
	private CompanyAuthService companyAuthService;
	@Resource
	private CompanyPatentsService companyPatentsService;
	@Resource
	private CompanyFinanceService companyFinanceService;
	@Resource
	private CompanySupplyRelationService companySupplyRelationService;
	@Resource
	private CompanyFileService companyFileService;
	@Resource
	private CompanyEquipmentService companyEquipmentService;
	@Resource
	private CompanyProductDeviceService companyProductDeviceService;
	@Resource
	private CompanyTechnologyService companyTechnologyService;
	@Resource
	private CompanyRawMaterialService companyRawMaterialService;
	@Resource
	private CompanyCustomerService companyCustomerService;
	@Resource
	private CompanyProductServiceService companyProductServiceService;
	@Resource
	private ContactsService contactsService;
	@Resource
	private SupplierService supplierService;
	@Resource
	private CompanyPurRefService companyPurRefService;
	@Resource
	private DicGroupItemService dicGroupItemService ;
	@Resource
	private ProcessService processService;

	@ApiOperation(httpMethod = "POST", value = "供应商准入-提交审核资料")
	@RequestMapping("service/audit")
	@ResponseBody
	public ResponseResult<String> audit() {

		this.supplierService.audit(ProjectUtils.getProject(), CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser());

		return ResponseResult.success();
	}

	@ApiOperation(httpMethod = "POST", value = "供应商准入-查询各个供应商资料是否填写完成")
	@ApiImplicitParams({@ApiImplicitParam(name = "supCompanySrmCode", required = false, value = "供应商SRM编码", paramType = "query", dataType = "String")})
	@RequestMapping("service/findIsFinish")
	@ResponseBody
	public ResponseResult<CompanyFinishFlag> findIsFinish(@RequestParam(required = false) String supCompanySrmCode) {
		CompanyFinishFlag companyFinishFlag = new CompanyFinishFlag();
		Project project = ProjectUtils.getProject();
		Company company=null;
		if(StringUtils.isBlank(supCompanySrmCode)){
			 company = CompanyUtils.currentCompany();
		}else{
			company=this.companyService.queryCompanyByCode(supCompanySrmCode);
		}

		// 企业基本信息
		companyFinishFlag.setEnterpriseBaseInfo(companyService.isFinish(company));

		// 联系人信息
		companyFinishFlag.setContactInfo(contactsService.isFinish(project, company));

		// 主要产品/服务
		companyFinishFlag.setProductOrService(companyProductServiceService.isFinish(project, company));

		// 主要客户
		companyFinishFlag.setMainCustomer(companyCustomerService.isFinish(project, company));

		// 主要供应商/原材料
		companyFinishFlag.setMainSupOrMaterials(companyRawMaterialService.isFinish(project, company));

		// 主要技术
		companyFinishFlag.setMainTechnology(companyTechnologyService.isFinish(project, company));

		// 关键生产设备
		companyFinishFlag.setMainProductDevice(companyProductDeviceService.isFinish(project, company));

		// 关键试验/检测设备
		companyFinishFlag.setMainTestEquipment(companyEquipmentService.isFinish(project, company));

		// 企业通过的认证
		companyFinishFlag.setThroughAuthentication(companyAuthService.isFinish(project, company));

		// 专利/专有技术/许可
		companyFinishFlag.setProprietaryTechnology(companyPatentsService.isFinish(project, company));

		// 财务信息
		companyFinishFlag.setFinanceInfo(companyFinanceService.isFinish(project, company));

		// 员工供货关系
		companyFinishFlag.setEmployeeSupplyRelationship(companySupplyRelationService.isFinish(project, company));

		// 附件
		companyFinishFlag.setEnclosureList(companyFileService.isFinish(project, company));

		return ResponseResult.success(companyFinishFlag);
	}

	@ApiOperation(httpMethod = "POST", value = "查询陌生供应商，潜在供应商，合格供应商列表")
	@ApiImplicitParams({ @ApiImplicitParam(name = "roleEnum", required = false, value = "陌生供应商，潜在供应商，合格供应商（stranger/potenial/qualified）", paramType = "query", dataType = "String", defaultValue = "stranger"), @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"), @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"), @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 Supplier", paramType = "body", dataType = "QueryParamWapper") })
	@RequestMapping("service/findByPage")
	@ResponseBody
	public ResponseResult<PageView<Supplier>> findByPage(@RequestParam(defaultValue = "stranger") String roleEnum, @RequestParam(defaultValue = "0") int pageNo, @RequestParam(defaultValue = "10") int pageSize, @RequestBody(required = false) QueryParamWapper wapper) throws Exception {

		// 1.加入供应商查询条件
		CompanyExample companyExample = new CompanyExample();
		companyExample.setPageView(new PageView<Company>(pageNo, pageSize));
		companyExample.setOrderByClause("CREATE_TIME DESC");
		CompanyExample.Criteria criteria = companyExample.createCriteria();
		criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andIsEnableEqualTo(Constant.YES_INT);
		if (wapper != null) {
			CriteriaUtils.addCriterion(criteria, wapper);
		}

		// 判断传的角色是否对
		List<String> roleEnumList = new ArrayList<>();
		roleEnumList.add(PartnerRoleEnum.STRANGER.getCode());
		roleEnumList.add(PartnerRoleEnum.QUALIFIED.getCode());
		roleEnumList.add(PartnerRoleEnum.POTENIAL.getCode());
		roleEnumList.add(PartnerRoleEnum.ELIMINATE.getCode());
		if (!roleEnumList.contains(roleEnum)) {
			throw new CommonException("不支持该角色查询条件，请检查!");
		}

		// 获取采购商ID
		String purCompanyId = ProjectUtils.getProject().getCompanyId();
		PageView<Company> companyPageView = companyService.querySupplerCompanies(purCompanyId, companyExample, roleEnum);

		// 2.根据这些供应商ID去查询其基本信息
		List<Company> result = companyPageView.getQueryResult();
		PageView<Supplier> supplierPageView = new PageView<Supplier>(pageNo, pageSize);
		supplierPageView.setRowCount(companyPageView.getRowCount());
		if (CollectionUtils.isEmpty(result)) {
			return ResponseResult.success(supplierPageView);
		}

		// 3.封装供应商其他信息
		List<Supplier> list = getSuppliers(result);
		supplierPageView.setQueryResult(list);
		return ResponseResult.success(supplierPageView);
	}
	
	@ApiOperation(httpMethod = "POST", value = "查询陌生供应商，潜在供应商，合格供应商列表")
	@ApiImplicitParams({ @ApiImplicitParam(name = "roleEnum", required = false, value = "陌生供应商，潜在供应商，合格供应商（stranger/potenial/qualified）", paramType = "query", dataType = "String", defaultValue = "stranger"), @ApiImplicitParam(name = "pageNo", required = false, value = "所在页", paramType = "query", dataType = "String", defaultValue = "0"), @ApiImplicitParam(name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10"), @ApiImplicitParam(name = "wapper", required = false, value = "查询条件,属性名请参考 Supplier", paramType = "body", dataType = "QueryParamWapper") })
	@RequestMapping("service/findByPageForApply")
	@ResponseBody
	public ResponseResult<PageView<Supplier>> findByPageForApply(@RequestParam(defaultValue = "stranger") String roleEnum, @RequestParam(defaultValue = "0") int pageNo, @RequestParam(defaultValue = "10") int pageSize, @RequestBody(required = false) QueryParamWapper wapper) throws Exception {

		// 1.加入供应商查询条件
		CompanyExample companyExample = new CompanyExample();
		companyExample.setPageView(new PageView<Company>(pageNo, pageSize));
		companyExample.setOrderByClause("CREATE_TIME DESC");
		CompanyExample.Criteria criteria = companyExample.createCriteria();
		criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andIsEnableEqualTo(Constant.YES_INT);
		if (wapper != null) {
			CriteriaUtils.addCriterion(criteria, wapper);
		}

		// 判断传的角色是否对
		List<String> roleEnumList = new ArrayList<>();
		roleEnumList.add(PartnerRoleEnum.STRANGER.getCode());
		roleEnumList.add(PartnerRoleEnum.QUALIFIED.getCode());
		roleEnumList.add(PartnerRoleEnum.POTENIAL.getCode());
		roleEnumList.add(PartnerRoleEnum.ELIMINATE.getCode());
		if (!roleEnumList.contains(roleEnum)) {
			throw new CommonException("不支持该角色查询条件，请检查!");
		}

		// 获取采购商ID
		String purCompanyId = ProjectUtils.getProject().getCompanyId();
		PageView<Company> companyPageView = companyService.querySupplerCompaniesForApply(purCompanyId, companyExample, roleEnum);

		// 2.根据这些供应商ID去查询其基本信息
		List<Company> result = companyPageView.getQueryResult();
		PageView<Supplier> supplierPageView = new PageView<Supplier>(pageNo, pageSize);
		supplierPageView.setRowCount(companyPageView.getRowCount());
		if (CollectionUtils.isEmpty(result)) {
			return ResponseResult.success(supplierPageView);
		}

		// 3.封装供应商其他信息
		List<Supplier> list = getSuppliers(result);
		supplierPageView.setQueryResult(list);
		return ResponseResult.success(supplierPageView);
	}

	/**
	 * 获取供应商
	 * 
	 * @param result
	 * @return
	 */
	private List<Supplier> getSuppliers(List<Company> result) throws Exception {
		List<Supplier> list = new ArrayList<Supplier>();
		for (Company company : result) {
			// 基本信息的封装
			Supplier supplier = new Supplier();
			BeanUtils.copyProperties(company, supplier);

			// 不知道产品为什么要以这种命名。。。。。。

			// 设置分类1-分类4
			this.setFirstCompanyType(company, supplier);

			// 设置大类1-大类5
			// 解析大类 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,23,20,21,22,24,25,26,27,28
			this.setSecondCompanyType(company, supplier);

			// 设置供应商证书信息
			this.setSupplierCertification(ProjectUtils.getProject(), supplier);
			
			//根据供应商ID查询出准入流程
			ProcessExample processExample = new ProcessExample();
			processExample.createCriteria().andCompanyIdEqualTo(company.getId());
			List<Process> processList = processService.queryAllObjByExample(processExample);
			if(CollectionUtils.isNotEmpty(processList)){
				supplier.setProcess(processList.get(0));
			}

			list.add(supplier);
		}
		return list;
	}

	/**
	 * 设置大类1-大类5
	 * 
	 * @param company
	 * @param supplier
	 */
	private void setSecondCompanyType(Company company, Supplier supplier) {
		String secondCompanyType = company.getSecondCompanyType();
		if (StringUtils.isNotBlank(secondCompanyType)) {
			String[] secondCompanyTypeStr = secondCompanyType.split(",");
			if (ArrayUtils.isNotEmpty(secondCompanyTypeStr)) {

				// 只要前5个
				if (secondCompanyTypeStr.length > 5) {
					supplier.setSecondCompanyType1(secondCompanyTypeStr[0]);
					DicGroupItem dicItem1 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", secondCompanyTypeStr[0]);
					if(dicItem1 !=null){
						supplier.setSecondCompanyTypeDesc1(dicItem1.getName());
					}else{
						supplier.setSecondCompanyTypeDesc1("");
					}
					
					supplier.setSecondCompanyType2(secondCompanyTypeStr[1]);
					DicGroupItem dicItem2 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", secondCompanyTypeStr[1]);
					if(dicItem2 !=null){
						supplier.setSecondCompanyTypeDesc2(dicItem2.getName());
					}else{
						supplier.setSecondCompanyTypeDesc2("");
					}
					
					supplier.setSecondCompanyType3(secondCompanyTypeStr[2]);
					DicGroupItem dicItem3 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", secondCompanyTypeStr[2]);
					if(dicItem3 !=null){
						supplier.setSecondCompanyTypeDesc3(dicItem3.getName());
					}else{
						supplier.setSecondCompanyTypeDesc3("");
					}
					
					supplier.setSecondCompanyType4(secondCompanyTypeStr[3]);
					DicGroupItem dicItem4 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", secondCompanyTypeStr[3]);
					if(dicItem4 !=null){
						supplier.setSecondCompanyTypeDesc4(dicItem4.getName());
					}else{
						supplier.setSecondCompanyTypeDesc4("");
					};
					
					supplier.setSecondCompanyType5(secondCompanyTypeStr[4]);
					DicGroupItem dicItem5 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", secondCompanyTypeStr[4]);
					if(dicItem5 !=null){
						supplier.setSecondCompanyTypeDesc5(dicItem5.getName());
					}else{
						supplier.setSecondCompanyTypeDesc5("");
					}
				} else {
					for (int i = 1; i <= secondCompanyTypeStr.length; i++) {

						if (i == 1) {
							supplier.setSecondCompanyType1(secondCompanyTypeStr[0]);
							DicGroupItem dicItem1 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", secondCompanyTypeStr[0]);
							if(dicItem1 !=null){
								supplier.setSecondCompanyTypeDesc1(dicItem1.getName());
							}else{
								supplier.setSecondCompanyTypeDesc1("");
							}
						} else if (i == 2) {
							supplier.setSecondCompanyType2(secondCompanyTypeStr[1]);
							DicGroupItem dicItem2 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", secondCompanyTypeStr[1]);
							if(dicItem2 != null){
								supplier.setSecondCompanyTypeDesc2(dicItem2.getName());
							}else{
								supplier.setSecondCompanyTypeDesc2("");
							}
						} else if (i == 3) {
							supplier.setSecondCompanyType3(secondCompanyTypeStr[2]);
							DicGroupItem dicItem3 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", secondCompanyTypeStr[2]);
							if(dicItem3 != null){
								supplier.setSecondCompanyTypeDesc3(dicItem3.getName());
							}else{
								supplier.setSecondCompanyTypeDesc3("");
							}
						} else if (i == 4) {
							supplier.setSecondCompanyType4(secondCompanyTypeStr[3]);
							DicGroupItem dicItem4 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", secondCompanyTypeStr[3]);
							if(dicItem4 != null){
								supplier.setSecondCompanyTypeDesc4(dicItem4.getName());
							}else{
								supplier.setSecondCompanyTypeDesc4("");
							}
						} else if (i == 5) {
							supplier.setSecondCompanyType5(secondCompanyTypeStr[4]);
							DicGroupItem dicItem5 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", secondCompanyTypeStr[4]);
							if(dicItem5 != null){
								supplier.setSecondCompanyTypeDesc5(dicItem5.getName());
							}else{
								supplier.setSecondCompanyTypeDesc5("");
							}
						} else {

						}

					}
				}

			}
		}
	}

	/**
	 * 设置分类1-分类4
	 * 
	 * @param company
	 * @param supplier
	 */
	private void setFirstCompanyType(Company company, Supplier supplier) {
		supplier.setFirstCompanyType2(company.getBusinessType());
		supplier.setFirstCompanyType3(company.getClassificationThree());
		if (StringUtils.isNotBlank(company.getFirstCompanyType())) {
			/*if (CompanyTypeEnum.MANUFACTURER.getCode().equals(company.getFirstCompanyType()) || CompanyTypeEnum.AGENT.getCode().equals(company.getFirstCompanyType())) {
				supplier.setFirstCompanyType1(company.getFirstCompanyType());
				supplier.setFirstCompanyType4(company.getFirstCompanyType());
			} else if (CompanyTypeEnum.CUSTOM_PARTS.getCode().equals(company.getFirstCompanyType())) {
				supplier.setFirstCompanyType1(company.getFirstCompanyType());
				supplier.setFirstCompanyType4(company.getFirstCompanyType());
			} else {

			}*/
			DicGroupItem dicItem = this.dicGroupItemService.queryItems("zr_gongsizhuyingyilei", company.getFirstCompanyType());
			supplier.setFirstCompanyTypeDesc(dicItem.getName());
			supplier.setFirstCompanyType1(company.getFirstCompanyType());
			supplier.setFirstCompanyType4(company.getFirstCompanyType());
		}
		//在数据字典取供应商风险类、供应商资查类的描述
		if(StringUtils.isNotEmpty(company.getBusinessType())){
			DicGroupItem dicItem = this.dicGroupItemService.queryItems("sap_business_type", company.getBusinessType());
			if(dicItem != null){
				supplier.setBusinessTypeDesc(dicItem.getName());
			}else{
				supplier.setBusinessTypeDesc("");
			}
		}
		if(StringUtils.isNotEmpty(company.getClassificationThree())){
			if(company.getClassificationThree().equals(ClassificationThreeEnum.ONE.getCode())){
				supplier.setClassificationThreeDesc(ClassificationThreeEnum.ONE.getValue());
			}else if(company.getClassificationThree().equals(ClassificationThreeEnum.TWO.getCode())){
				supplier.setClassificationThreeDesc(ClassificationThreeEnum.TWO.getValue());
			}else if(company.getClassificationThree().equals(ClassificationThreeEnum.THREE.getCode())){
				supplier.setClassificationThreeDesc(ClassificationThreeEnum.THREE.getValue());
			}else if(company.getClassificationThree().equals(ClassificationThreeEnum.FOUR.getCode())){
				supplier.setClassificationThreeDesc(ClassificationThreeEnum.FOUR.getValue());
			}else{
				supplier.setClassificationThreeDesc("");
			}
		}
	}

	/**
	 * 设置证书信息
	 * 
	 * @param supplier
	 */
	private void setSupplierCertification(Project project, Supplier supplier) throws ParseException {

		// 1.设置IATF16949证书信息
		CompanyAuthExample companyAuthExample = new CompanyAuthExample();
		companyAuthExample.clear();
		companyAuthExample.createCriteria().andProjectIdEqualTo(project.getId()).andSupCompanyIdEqualTo(supplier.getId()).andIsEnableEqualTo(Constant.YES_INT).andCertificateTypeCodeEqualTo(CertificateTypeCodeEnum.IATF16949.getCode());
		List<CompanyAuth> companyAuthList = companyAuthService.queryAllObjByExample(companyAuthExample);
		if (CollectionUtils.isNotEmpty(companyAuthList)) {
			CompanyAuth companyAuth1 = companyAuthList.get(0);
			String str="";
			if(StringUtils.isNotEmpty(companyAuth1.getCertificateFile())){
				JSONArray json = JSONArray.fromObject(companyAuth1.getCertificateFile());
				if(json.size()>0){
					JSONObject job = json.getJSONObject(0);
					str=(String) job.get("name");
				}
			}
			supplier.setIATF16949FileName(str);
			supplier.setIATF16949Name(companyAuth1.getCertificateFile());
			supplier.setIATF16949EndTime(companyAuth1.getEndTime());
		}

		// 2.设置IOS9001证书信息
		companyAuthExample.clear();
		companyAuthExample.createCriteria().andProjectIdEqualTo(project.getId()).andSupCompanyIdEqualTo(supplier.getId()).andIsEnableEqualTo(Constant.YES_INT).andCertificateTypeCodeEqualTo(CertificateTypeCodeEnum.IOS9001.getCode());
		List<CompanyAuth> companyAuthList2 = companyAuthService.queryAllObjByExample(companyAuthExample);
		if (CollectionUtils.isNotEmpty(companyAuthList2)) {
			CompanyAuth companyAuth2 = companyAuthList2.get(0);
			String str="";
			if(StringUtils.isNotEmpty(companyAuth2.getCertificateFile())){
				JSONArray json = JSONArray.fromObject(companyAuth2.getCertificateFile());
				if(json.size()>0){
					JSONObject job = json.getJSONObject(0);
					str=(String) job.get("name");
				}
			}
			supplier.setISO9001FileName(str);
			supplier.setISO9001Name(companyAuth2.getCertificateFile());
			supplier.setISO9001EndTime(companyAuth2.getEndTime());
		}

		// 3.设置IOS14000证书基本信息
		companyAuthExample.clear();
		companyAuthExample.createCriteria().andProjectIdEqualTo(project.getId()).andSupCompanyIdEqualTo(supplier.getId()).andIsEnableEqualTo(Constant.YES_INT).andCertificateTypeCodeEqualTo(CertificateTypeCodeEnum.IOS14000.getCode());
		List<CompanyAuth> companyAuthList3 = companyAuthService.queryAllObjByExample(companyAuthExample);
		if (CollectionUtils.isNotEmpty(companyAuthList3)) {
			CompanyAuth companyAuth3 = companyAuthList3.get(0);
			String str="";
			if(StringUtils.isNotEmpty(companyAuth3.getCertificateFile())){
				JSONArray json = JSONArray.fromObject(companyAuth3.getCertificateFile());
				if(json.size()>0){
					JSONObject job = json.getJSONObject(0);
					str=(String) job.get("name");
				}
			}
			supplier.setISO14000FileName(str);
			supplier.setISO14000Name(companyAuth3.getCertificateFile());
			supplier.setISO14000EndTime(companyAuth3.getEndTime());
		}
	}
	
	@ApiOperation(httpMethod="POST",value="供应商基础资料打印")
    @RequestMapping("service/print")
    @ResponseBody
    public ResponseResult<FileData> print(@RequestBody(required=true) List<Company> companyList){
    	Assert.isNotEmpty(companyList, "传输的数据为空");
    	FileData fileData=this.supplierService.print(ProjectUtils.getProjectId(),CompanyUtils.currentCompanyId(),companyList);
    	return ResponseResult.success(fileData);
    }
	
	@ApiOperation(httpMethod="POST" ,value="合格供应商清单,导出Excel")
	@RequestMapping("service/downloadExcelForPur")
	@ResponseBody
	public ResponseResult<FileData> downloadExcelForPur(@RequestBody(required=true) List<Company> companyList)
            throws IOException, ParseException, WriteException, Exception {
		Assert.isNotEmpty(companyList, "供应商信息为空");
		//查询当前采购员所管理的供应商
		List<String> srmCompanyList = new ArrayList<>();
		for (Company company : companyList) {
			srmCompanyList.add(company.getCompanyCode());
		}
		// 查询供应商的信息
		CompanyExample companyExample = new CompanyExample();
		CompanyExample.Criteria criteria=companyExample.createCriteria();
		criteria.andCompanyCodeIn(srmCompanyList)
				.andIsEnableEqualTo(Constant.YES_INT)
				.andProjectIdEqualTo(ProjectUtils.getProjectId());
		List<Company> companys=this.companyService.queryAllObjByExample(companyExample);
		//封装供应商信息
		List<Supplier> supplierList=getSuppliers(companys);
		//创建excel导出的头部信息
		List<TitleAndModelKey> titleAndModelKeys=this.supplierService.createExcelHeaderForPur();
		
		FileData fileData = ExcelFileData.createExcelFileOutputStream(titleAndModelKeys, supplierList, "合格供应商清单", "合格供应商清单", 0);
		return ResponseResult.success(fileData);
	}
}
