package com.els.base.certification.contrast.service;

import java.util.List;

import com.els.base.certification.contrast.entity.CompanyContrast;
import com.els.base.certification.contrast.entity.CompanyContrastExample;
import com.els.base.certification.contrast.entity.CompanyContrastItem;
import com.els.base.certification.contrast.vo.CompanyContrastVO;
import com.els.base.core.service.BaseService;
import com.els.base.file.entity.FileData;

public interface CompanyContrastService extends BaseService<CompanyContrast, CompanyContrastExample, String> {
	/**
	 * 生成对比数据
	 * @param supCompanyId
	 * @return
	 */
	public CompanyContrastItem generateCompanyContrastInfo(String supCompanyId,String materialType);
	
	/**
	 * 批量删除单据
	 * @param ids
	 */
	public void deleteByIds(List<String> ids);
	
	/**
	 * 批量作废单据
	 * @param ids
	 */
	public void abolishByIds(List<String> ids);
	
	/**
	 * 发送审批
	 * @param ids
	 */
	public void sendDataToApprove(List<String> ids);
	
	/**
	 * 设置建议引入的供应商
	 * @param companyContrast
	 */
	public void setSuggestedSupplier(CompanyContrast companyContrast);
	
	/**
	 * 设置审批意见
	 * @param companyContrast
	 */
	public void setApproveSuggestion(CompanyContrast companyContrast);
	
	/**
	 * 设置备注
	 * @param companyContrast
	 */
	public void setCompanyContrastRemark(CompanyContrast companyContrast);
	
	/**
	 * 保存数据
	 * @param companyContrast
	 */
	public void create(CompanyContrastVO vo);
	
	//public void approveSuccess(List<String> ids);
	
	public void modifyData(CompanyContrast companyContrast);
	
	/**
	 * 打印
	 * @param projectId
	 * @param companyId
	 * @param data
	 * @return
	 */
	FileData print(String projectId, String companyId,List<CompanyContrast> data);

}