package com.els.base.certification.contrast.service.impl;

import com.els.base.certification.contrast.dao.CompanyContrastItemMapper;
import com.els.base.certification.contrast.entity.CompanyContrastItem;
import com.els.base.certification.contrast.entity.CompanyContrastItemExample;
import com.els.base.certification.contrast.service.CompanyContrastItemService;
import com.els.base.core.entity.PageView;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service("defaultCompanyContrastItemService")
public class CompanyContrastItemServiceImpl implements CompanyContrastItemService {
    @Resource
    protected CompanyContrastItemMapper companyContrastItemMapper;

    @CacheEvict(value={"companyContrastItem"}, allEntries=true)
    @Override
    public void addObj(CompanyContrastItem t) {
        this.companyContrastItemMapper.insertSelective(t);
    }

    @CacheEvict(value={"companyContrastItem"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.companyContrastItemMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"companyContrastItem"}, allEntries=true)
    @Override
    public void modifyObj(CompanyContrastItem t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.companyContrastItemMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="companyContrastItem", keyGenerator="redisKeyGenerator")
    @Override
    public CompanyContrastItem queryObjById(String id) {
        return this.companyContrastItemMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="companyContrastItem", keyGenerator="redisKeyGenerator")
    @Override
    public List<CompanyContrastItem> queryAllObjByExample(CompanyContrastItemExample example) {
        return this.companyContrastItemMapper.selectByExample(example);
    }

    @Cacheable(value="companyContrastItem", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<CompanyContrastItem> queryObjByPage(CompanyContrastItemExample example) {
        PageView<CompanyContrastItem> pageView = example.getPageView();
        pageView.setQueryResult(this.companyContrastItemMapper.selectByExampleByPage(example));
        return pageView;
    }
}