package com.els.base.certification.contrast.web.controller;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.certification.contrast.entity.CompanyContrast;
import com.els.base.certification.contrast.entity.CompanyContrastExample;
import com.els.base.certification.contrast.entity.CompanyContrastExample.Criteria;
import com.els.base.certification.contrast.entity.CompanyContrastItem;
import com.els.base.certification.contrast.entity.CompanyContrastItemExample;
import com.els.base.certification.contrast.service.CompanyContrastItemService;
import com.els.base.certification.contrast.service.CompanyContrastService;
import com.els.base.certification.contrast.utils.CompanyContrastApproveEnum;
import com.els.base.certification.contrast.vo.CompanyContrastVO;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.utils.uuid.UUIDGenerator;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

@Api(value="潜在供应商对比表")
@Controller
@RequestMapping("companyContrast")
public class CompanyContrastController {
	private static final Logger logger = LoggerFactory.getLogger(CompanyContrastController.class);
	
    @Resource
    private CompanyContrastService companyContrastService;
    
    @Resource
    private CompanyContrastItemService companyContrastItemService;
    
    @Resource
    private GenerateCodeService generateCodeService;
    
    @Resource
    private CompanyService companyService;
    
    private static final String SUPPLIER_CONTRAST_BILL_NO = "SUPPLIER_CONTRAST_BILL_NO";
    
    @ApiOperation(httpMethod="POST", value="生成供应商对比单据信息")
    @RequestMapping("service/generateCompanyContrastInfo")
    @ResponseBody
    public ResponseResult<CompanyContrastVO> generateCompanyContrastInfo(@RequestBody List<Company> companyList,String materialType) {
        //materialType:  1=标准,3=定制
    	if(CollectionUtils.isEmpty(companyList)){
        	throw new CommonException("提交的信息为空!");
        }
        if(companyList.size() > 3){
        	throw new CommonException("对比的供应商数量不能大于3个!");
        }
        if(companyList.size() < 2){
        	throw new CommonException("对比的供应商数量不能少于2个!");
        }
        if(StringUtils.isEmpty(materialType)){
        	throw new CommonException("传递的定制件还是标准件的参数为空!");
        }
        List<CompanyContrastItem> list = new ArrayList<>();
        for(Company company : companyList){
        	if(StringUtils.isEmpty(company.getId())){
        		throw new CommonException("传递的参数中的供应商id为空!");
        	}
        	CompanyContrastItem item = this.companyContrastService.generateCompanyContrastInfo(company.getId(),materialType);
        	list.add(item);
        }
        
        //加进行项目
        CompanyContrastVO vo = new CompanyContrastVO();
        vo.setCompanyContrastItemList(list);
        vo.setMaterialType(materialType);
        
        //补全数据
        this.completeData(vo);
        
    	return ResponseResult.success(vo);
    }
    
    private void completeData(CompanyContrastVO vo){
//    	Company purCompany = CompanyUtils.getPurCompany();
    	Company purCompany = CompanyUtils.currentCompany();
    	User user = SpringSecurityUtils.getLoginUser();
    	String projectId = ProjectUtils.getProjectId();
		String id = UUIDGenerator.generateUUID();
    	
    	vo.setId(id);
    	vo.setProjectId(projectId);
    	vo.setPurCompanyId(purCompany.getId());
    	vo.setPurCompanySrmCode(purCompany.getCompanyCode());
    	vo.setPurCompanyName(purCompany.getCompanyFullName());
    	vo.setPurCompanyShortName(purCompany.getCompanyName());
    	
    	//生成单据号
    	String billNo = this.generateCodeService.getNextCode(SUPPLIER_CONTRAST_BILL_NO);
    	vo.setContrastBillNo(billNo);
    	
    	vo.setCreateBillUserName(user.getNickName());
    	vo.setCreateBillTime(new Date());
    	vo.setApproveStatus(CompanyContrastApproveEnum.STATUS_UN_APPROVE.getStatus());
    	vo.setConfirmStatus(0);
    	vo.setIsEnable(Constant.YES_INT);
    	vo.setCreateTime(new Date());
    	
    	this.completeItemData(vo);
    }
    
    private void completeItemData(CompanyContrastVO vo){
    	List<CompanyContrastItem> itemList = vo.getCompanyContrastItemList();
    	for(int i=1; i<=itemList.size(); i++){
    		CompanyContrastItem item = itemList.get(i-1);
    		if(i == 1){
    			vo.setFirstSupCompanyId(item.getSupCompanyId());
    			vo.setFirstSupCompanySrmCode(item.getSupCompanySrmCode());
    			vo.setFirstSupCompanyName(item.getSupCompanyName());
    			vo.setFirstSupCompanyShortName(item.getSupCompanyShortName());
    		}
    		if(i == 2){
    			vo.setSecondSupCompanyId(item.getSupCompanyId());
    			vo.setSecondSupCompanySrmCode(item.getSupCompanySrmCode());
    			vo.setSecondSupCompanyName(item.getSupCompanyName());
    			vo.setSecondSupCompanyShortName(item.getSupCompanyShortName());
    		}
    		if(i == 3){
    			vo.setThirdSupCompanyId(item.getSupCompanyId());
    			vo.setThirdSupCompanySrmCode(item.getSupCompanySrmCode());
    			vo.setThirdSupCompanyName(item.getSupCompanyName());
    			vo.setThirdSupCompanyShortName(item.getSupCompanyShortName());
    		}
    		item.setProjectId(vo.getProjectId());
			item.setContrastBillNo(vo.getContrastBillNo());
			item.setCompanyContrastId(vo.getId());
    	}
    }
    
    @ApiOperation(httpMethod="POST", value="保存对比表信息")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody CompanyContrastVO vo) {
        if(CollectionUtils.isEmpty(vo.getCompanyContrastItemList())){
        	throw new CommonException("单据行信息为空,保存失败");
        }
        this.companyContrastService.create(vo);
    	return ResponseResult.success();
    }
    
    
    @ApiOperation(httpMethod="POST", value="删除潜在供应商对比表数据")
    @RequestMapping("service/deleteByIds")
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody List<String> ids) {
    	logger.debug("【删除数据】传递的ids为{}",ids);
    	if(CollectionUtils.isEmpty(ids)){
    		throw new CommonException("操作失败，数据不能为空!");
    	}
    	this.companyContrastService.deleteByIds(ids);
    	return ResponseResult.success();
    }
    
    @ApiOperation(httpMethod="POST", value="打印对比表数据")
    @RequestMapping("service/print")
    @ResponseBody
    public ResponseResult<FileData> print(@RequestBody List<CompanyContrast> data) {
    	FileData fileData = this.companyContrastService.print(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), data);
    	return ResponseResult.success(fileData);
    }
    
    @ApiOperation(httpMethod="POST", value="作废潜在供应商对比表数据")
    @RequestMapping("service/abolishByIds")
    @ResponseBody
    public ResponseResult<String> abolishByIds(@RequestBody List<String> ids) {
    	logger.debug("【作废数据】传递的ids为{}",ids);
    	if(CollectionUtils.isEmpty(ids)){
    		throw new CommonException("操作失败，数据不能为空!");
    	}
    	this.companyContrastService.abolishByIds(ids);
    	return ResponseResult.success();
    }
    
    @ApiOperation(httpMethod="POST", value="发送审批")
    @RequestMapping("service/sendDataToApprove")
    @ResponseBody
    public ResponseResult<String> sendDataToApprove(@RequestBody List<String> ids) {
    	logger.debug("【发送审批】传递的ids为{}",ids);
    	if(CollectionUtils.isEmpty(ids)){
    		throw new CommonException("操作失败，数据不能为空!");
    	}
    	this.companyContrastService.sendDataToApprove(ids);
    	return ResponseResult.success();
    }
    
    @ApiOperation(httpMethod="POST", value="修改数据：仅修改物料编码,描述,备注,建议的供应商")
    @RequestMapping("service/modifyData")
    @ResponseBody
    public ResponseResult<String> modifyData(@RequestBody CompanyContrast companyContrast) {
    	this.companyContrastService.modifyData(companyContrast);
    	return ResponseResult.success(); 
    }
    
//    @ApiOperation(httpMethod="POST", value="设置建议引入的供应商")
//    @RequestMapping("service/setSuggestedSupplier")
//    @ResponseBody
//    public ResponseResult<String> setSuggestedSupplier(@RequestBody CompanyContrast companyContrast) {
//    	this.companyContrastService.setSuggestedSupplier(companyContrast);
//    	return ResponseResult.success(); 
//    }
    
//    @ApiOperation(httpMethod="POST", value="设置审批意见")
//    @RequestMapping("service/setApproveSuggestion")
//    @ResponseBody
//    public ResponseResult<String> setApproveSuggestion(@RequestBody CompanyContrast companyContrast) {
//    	this.companyContrastService.setApproveSuggestion(companyContrast);
//    	return ResponseResult.success(); 
//    }
    
//    @ApiOperation(httpMethod="POST", value="设置备注")
//    @RequestMapping("service/setCompanyContrastRemark")
//    @ResponseBody
//    public ResponseResult<String> setCompanyContrastRemark(@RequestBody CompanyContrast companyContrast) {
//    	this.companyContrastService.setCompanyContrastRemark(companyContrast);
//    	return ResponseResult.success();
//    }
    
    
//    @ApiOperation(httpMethod="POST", value="编辑潜在供应商导入表")
//    @RequestMapping("service/edit")
//    @ResponseBody
//    public ResponseResult<String> edit(@RequestBody CompanyContrast companyContrast) {
//        if (StringUtils.isBlank(companyContrast.getId())) {
//            throw new CommonException("id 为空，保存失败");
//        }
//        this.companyContrastService.modifyObj(companyContrast);
//        return ResponseResult.success();
//    }
//
//    @ApiOperation(httpMethod="POST", value="删除潜在供应商导入表")
//    @RequestMapping("service/deleteById")
//    @ResponseBody
//    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
//        if (StringUtils.isBlank(id)) {
//            throw new CommonException("删除失败,id不能为空");
//        }
//        this.companyContrastService.deleteObjById(id);
//        return ResponseResult.success();
//    }
    
    @ApiOperation(httpMethod="POST", value="根据id查询对比表详情")
    @RequestMapping("service/findDetailById")
    @ResponseBody
    public ResponseResult<CompanyContrastVO> findDetailById(@RequestParam(required=true) String id){
    	if(StringUtils.isEmpty(id)){
    		throw new CommonException("传递的id为空!");
    	}
    	CompanyContrast data = this.companyContrastService.queryObjById(id);
    	if(null == data){
    		throw new CommonException("根据id查找的单据不存在!");
    	}
    	CompanyContrastVO vo = new CompanyContrastVO();
    	//将对象的属性赋值给vo
    	BeanUtils.copyProperties(data, vo);
    	//查询行项数据
    	CompanyContrastItemExample example = new CompanyContrastItemExample();
    	example.createCriteria()
    		   .andCompanyContrastIdEqualTo(id);
    	
    	List<CompanyContrastItem> list = this.companyContrastItemService.queryAllObjByExample(example);
    	vo.setCompanyContrastItemList(list);
    	
    	return ResponseResult.success(vo);
    }
    
    @ApiOperation(httpMethod="POST", value="查询潜在供应商对表")
    @ApiImplicitParams({ 
	 @ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
	 @ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
	 @ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 CompanyContrast", paramType = "body", dataType = "QueryParamWapper" )  
}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<CompanyContrast>> findByPage( 
	 @RequestParam(defaultValue="0") int pageNo,  
	 @RequestParam(defaultValue="10") int pageSize, 
	 @RequestParam String companyShortName,
	 @RequestBody(required=false) QueryParamWapper wapper) {
        CompanyContrastExample example = new CompanyContrastExample();
        example.setPageView(new PageView<CompanyContrast>(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        
        CompanyContrastExample.Criteria criteria = example.createCriteria();
        
        if(StringUtils.isNotEmpty(companyShortName)){
        	//第一个公司
        	criteria.andIsEnableEqualTo(Constant.YES_INT)
        			.andFirstSupCompanyShortNameLike("%"+companyShortName+"%");
        	if (wapper != null) {
            	CriteriaUtils.addCriterion(criteria, wapper);
            }
        	//第二个公司;
        	Criteria criteria1 = example.or();
    		criteria1.andIsEnableEqualTo(Constant.YES_INT)
    		   		 .andSecondSupCompanyShortNameLike("%"+companyShortName+"%");
        	if (wapper != null) {
            	CriteriaUtils.addCriterion(criteria1, wapper);
            }
        	//第三个公司
        	Criteria criteria2 = example.or();
    		criteria2.andIsEnableEqualTo(Constant.YES_INT)
    				 .andThirdSupCompanyShortNameLike("%"+companyShortName+"%");
		 	if (wapper != null) {
		     	CriteriaUtils.addCriterion(criteria2, wapper);
		    }
        }else{
        	criteria.andIsEnableEqualTo(Constant.YES_INT);
        	if (wapper != null) {
		     	CriteriaUtils.addCriterion(criteria, wapper);
		    }
        }
        
        PageView<CompanyContrast> pageData = this.companyContrastService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}