package com.els.base.certification.customer.entity;

import com.els.base.core.entity.AbstractExample;
import com.els.base.core.entity.PageView;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CompanyCustomerExample extends AbstractExample<CompanyCustomer> implements Serializable {
    protected String orderByClause;

    protected boolean distinct;

    protected List<Criteria> oredCriteria;

    protected PageView<CompanyCustomer> pageView = new PageView<CompanyCustomer>(1, 10);

    private static final long serialVersionUID = 1L;

    public CompanyCustomerExample() {
        oredCriteria = new ArrayList<Criteria>();
    }

    public void setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
    }

    public String getOrderByClause() {
        return orderByClause;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public boolean isDistinct() {
        return distinct;
    }

    public List<Criteria> getOredCriteria() {
        return oredCriteria;
    }

    public void or(Criteria criteria) {
        oredCriteria.add(criteria);
    }

    public Criteria or() {
        Criteria criteria = createCriteriaInternal();
        oredCriteria.add(criteria);
        return criteria;
    }

    public Criteria createCriteria() {
        Criteria criteria = createCriteriaInternal();
        if (oredCriteria.size() == 0) {
            oredCriteria.add(criteria);
        }
        return criteria;
    }

    protected Criteria createCriteriaInternal() {
        Criteria criteria = new Criteria();
        return criteria;
    }

    public void clear() {
        oredCriteria.clear();
        orderByClause = null;
        distinct = false;
    }

    @Override
    public PageView<CompanyCustomer> getPageView() {
        return pageView;
    }

    @Override
    public void setPageView(PageView<CompanyCustomer> pageView) {
        this.pageView = pageView;
    }

    protected abstract static class GeneratedCriteria implements Serializable {
        protected List<Criterion> criteria;

        private static final long serialVersionUID = 1L;

        protected GeneratedCriteria() {
            super();
            criteria = new ArrayList<Criterion>();
        }

        public boolean isValid() {
            return criteria.size() > 0;
        }

        public List<Criterion> getAllCriteria() {
            return criteria;
        }

        public List<Criterion> getCriteria() {
            return criteria;
        }

        protected void addCriterion(String condition) {
            if (condition == null) {
                throw new RuntimeException("Value for condition cannot be null");
            }
            criteria.add(new Criterion(condition));
        }

        protected void addCriterion(String condition, Object value, String property) {
            if (value == null) {
                throw new RuntimeException("Value for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value));
        }

        protected void addCriterion(String condition, Object value1, Object value2, String property) {
            if (value1 == null || value2 == null) {
                throw new RuntimeException("Between values for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value1, value2));
        }

        public Criteria andIdIsNull() {
            addCriterion("ID is null");
            return (Criteria) this;
        }

        public Criteria andIdIsNotNull() {
            addCriterion("ID is not null");
            return (Criteria) this;
        }

        public Criteria andIdEqualTo(String value) {
            addCriterion("ID =", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotEqualTo(String value) {
            addCriterion("ID <>", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThan(String value) {
            addCriterion("ID >", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThanOrEqualTo(String value) {
            addCriterion("ID >=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThan(String value) {
            addCriterion("ID <", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThanOrEqualTo(String value) {
            addCriterion("ID <=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLike(String value) {
            addCriterion("ID like", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotLike(String value) {
            addCriterion("ID not like", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdIn(List<String> values) {
            addCriterion("ID in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotIn(List<String> values) {
            addCriterion("ID not in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdBetween(String value1, String value2) {
            addCriterion("ID between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotBetween(String value1, String value2) {
            addCriterion("ID not between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andProjectIdIsNull() {
            addCriterion("PROJECT_ID is null");
            return (Criteria) this;
        }

        public Criteria andProjectIdIsNotNull() {
            addCriterion("PROJECT_ID is not null");
            return (Criteria) this;
        }

        public Criteria andProjectIdEqualTo(String value) {
            addCriterion("PROJECT_ID =", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdNotEqualTo(String value) {
            addCriterion("PROJECT_ID <>", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdGreaterThan(String value) {
            addCriterion("PROJECT_ID >", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdGreaterThanOrEqualTo(String value) {
            addCriterion("PROJECT_ID >=", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdLessThan(String value) {
            addCriterion("PROJECT_ID <", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdLessThanOrEqualTo(String value) {
            addCriterion("PROJECT_ID <=", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdLike(String value) {
            addCriterion("PROJECT_ID like", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdNotLike(String value) {
            addCriterion("PROJECT_ID not like", value, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdIn(List<String> values) {
            addCriterion("PROJECT_ID in", values, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdNotIn(List<String> values) {
            addCriterion("PROJECT_ID not in", values, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdBetween(String value1, String value2) {
            addCriterion("PROJECT_ID between", value1, value2, "projectId");
            return (Criteria) this;
        }

        public Criteria andProjectIdNotBetween(String value1, String value2) {
            addCriterion("PROJECT_ID not between", value1, value2, "projectId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdIsNull() {
            addCriterion("PUR_COMPANY_ID is null");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdIsNotNull() {
            addCriterion("PUR_COMPANY_ID is not null");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdEqualTo(String value) {
            addCriterion("PUR_COMPANY_ID =", value, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdNotEqualTo(String value) {
            addCriterion("PUR_COMPANY_ID <>", value, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdGreaterThan(String value) {
            addCriterion("PUR_COMPANY_ID >", value, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdGreaterThanOrEqualTo(String value) {
            addCriterion("PUR_COMPANY_ID >=", value, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdLessThan(String value) {
            addCriterion("PUR_COMPANY_ID <", value, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdLessThanOrEqualTo(String value) {
            addCriterion("PUR_COMPANY_ID <=", value, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdLike(String value) {
            addCriterion("PUR_COMPANY_ID like", value, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdNotLike(String value) {
            addCriterion("PUR_COMPANY_ID not like", value, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdIn(List<String> values) {
            addCriterion("PUR_COMPANY_ID in", values, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdNotIn(List<String> values) {
            addCriterion("PUR_COMPANY_ID not in", values, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdBetween(String value1, String value2) {
            addCriterion("PUR_COMPANY_ID between", value1, value2, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanyIdNotBetween(String value1, String value2) {
            addCriterion("PUR_COMPANY_ID not between", value1, value2, "purCompanyId");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeIsNull() {
            addCriterion("PUR_COMPANY_SRM_CODE is null");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeIsNotNull() {
            addCriterion("PUR_COMPANY_SRM_CODE is not null");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeEqualTo(String value) {
            addCriterion("PUR_COMPANY_SRM_CODE =", value, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeNotEqualTo(String value) {
            addCriterion("PUR_COMPANY_SRM_CODE <>", value, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeGreaterThan(String value) {
            addCriterion("PUR_COMPANY_SRM_CODE >", value, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeGreaterThanOrEqualTo(String value) {
            addCriterion("PUR_COMPANY_SRM_CODE >=", value, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeLessThan(String value) {
            addCriterion("PUR_COMPANY_SRM_CODE <", value, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeLessThanOrEqualTo(String value) {
            addCriterion("PUR_COMPANY_SRM_CODE <=", value, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeLike(String value) {
            addCriterion("PUR_COMPANY_SRM_CODE like", value, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeNotLike(String value) {
            addCriterion("PUR_COMPANY_SRM_CODE not like", value, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeIn(List<String> values) {
            addCriterion("PUR_COMPANY_SRM_CODE in", values, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeNotIn(List<String> values) {
            addCriterion("PUR_COMPANY_SRM_CODE not in", values, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeBetween(String value1, String value2) {
            addCriterion("PUR_COMPANY_SRM_CODE between", value1, value2, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanySrmCodeNotBetween(String value1, String value2) {
            addCriterion("PUR_COMPANY_SRM_CODE not between", value1, value2, "purCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameIsNull() {
            addCriterion("PUR_COMPANY_NAME is null");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameIsNotNull() {
            addCriterion("PUR_COMPANY_NAME is not null");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameEqualTo(String value) {
            addCriterion("PUR_COMPANY_NAME =", value, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameNotEqualTo(String value) {
            addCriterion("PUR_COMPANY_NAME <>", value, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameGreaterThan(String value) {
            addCriterion("PUR_COMPANY_NAME >", value, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameGreaterThanOrEqualTo(String value) {
            addCriterion("PUR_COMPANY_NAME >=", value, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameLessThan(String value) {
            addCriterion("PUR_COMPANY_NAME <", value, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameLessThanOrEqualTo(String value) {
            addCriterion("PUR_COMPANY_NAME <=", value, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameLike(String value) {
            addCriterion("PUR_COMPANY_NAME like", value, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameNotLike(String value) {
            addCriterion("PUR_COMPANY_NAME not like", value, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameIn(List<String> values) {
            addCriterion("PUR_COMPANY_NAME in", values, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameNotIn(List<String> values) {
            addCriterion("PUR_COMPANY_NAME not in", values, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameBetween(String value1, String value2) {
            addCriterion("PUR_COMPANY_NAME between", value1, value2, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andPurCompanyNameNotBetween(String value1, String value2) {
            addCriterion("PUR_COMPANY_NAME not between", value1, value2, "purCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdIsNull() {
            addCriterion("SUP_COMPANY_ID is null");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdIsNotNull() {
            addCriterion("SUP_COMPANY_ID is not null");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdEqualTo(String value) {
            addCriterion("SUP_COMPANY_ID =", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdNotEqualTo(String value) {
            addCriterion("SUP_COMPANY_ID <>", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdGreaterThan(String value) {
            addCriterion("SUP_COMPANY_ID >", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdGreaterThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_ID >=", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdLessThan(String value) {
            addCriterion("SUP_COMPANY_ID <", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdLessThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_ID <=", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdLike(String value) {
            addCriterion("SUP_COMPANY_ID like", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdNotLike(String value) {
            addCriterion("SUP_COMPANY_ID not like", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdIn(List<String> values) {
            addCriterion("SUP_COMPANY_ID in", values, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdNotIn(List<String> values) {
            addCriterion("SUP_COMPANY_ID not in", values, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_ID between", value1, value2, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdNotBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_ID not between", value1, value2, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeIsNull() {
            addCriterion("SUP_COMPANY_SRM_CODE is null");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeIsNotNull() {
            addCriterion("SUP_COMPANY_SRM_CODE is not null");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeEqualTo(String value) {
            addCriterion("SUP_COMPANY_SRM_CODE =", value, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeNotEqualTo(String value) {
            addCriterion("SUP_COMPANY_SRM_CODE <>", value, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeGreaterThan(String value) {
            addCriterion("SUP_COMPANY_SRM_CODE >", value, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeGreaterThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_SRM_CODE >=", value, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeLessThan(String value) {
            addCriterion("SUP_COMPANY_SRM_CODE <", value, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeLessThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_SRM_CODE <=", value, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeLike(String value) {
            addCriterion("SUP_COMPANY_SRM_CODE like", value, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeNotLike(String value) {
            addCriterion("SUP_COMPANY_SRM_CODE not like", value, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeIn(List<String> values) {
            addCriterion("SUP_COMPANY_SRM_CODE in", values, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeNotIn(List<String> values) {
            addCriterion("SUP_COMPANY_SRM_CODE not in", values, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_SRM_CODE between", value1, value2, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeNotBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_SRM_CODE not between", value1, value2, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameIsNull() {
            addCriterion("SUP_COMPANY_NAME is null");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameIsNotNull() {
            addCriterion("SUP_COMPANY_NAME is not null");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameEqualTo(String value) {
            addCriterion("SUP_COMPANY_NAME =", value, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameNotEqualTo(String value) {
            addCriterion("SUP_COMPANY_NAME <>", value, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameGreaterThan(String value) {
            addCriterion("SUP_COMPANY_NAME >", value, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameGreaterThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_NAME >=", value, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameLessThan(String value) {
            addCriterion("SUP_COMPANY_NAME <", value, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameLessThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_NAME <=", value, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameLike(String value) {
            addCriterion("SUP_COMPANY_NAME like", value, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameNotLike(String value) {
            addCriterion("SUP_COMPANY_NAME not like", value, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameIn(List<String> values) {
            addCriterion("SUP_COMPANY_NAME in", values, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameNotIn(List<String> values) {
            addCriterion("SUP_COMPANY_NAME not in", values, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_NAME between", value1, value2, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameNotBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_NAME not between", value1, value2, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andCustomerNameIsNull() {
            addCriterion("CUSTOMER_NAME is null");
            return (Criteria) this;
        }

        public Criteria andCustomerNameIsNotNull() {
            addCriterion("CUSTOMER_NAME is not null");
            return (Criteria) this;
        }

        public Criteria andCustomerNameEqualTo(String value) {
            addCriterion("CUSTOMER_NAME =", value, "customerName");
            return (Criteria) this;
        }

        public Criteria andCustomerNameNotEqualTo(String value) {
            addCriterion("CUSTOMER_NAME <>", value, "customerName");
            return (Criteria) this;
        }

        public Criteria andCustomerNameGreaterThan(String value) {
            addCriterion("CUSTOMER_NAME >", value, "customerName");
            return (Criteria) this;
        }

        public Criteria andCustomerNameGreaterThanOrEqualTo(String value) {
            addCriterion("CUSTOMER_NAME >=", value, "customerName");
            return (Criteria) this;
        }

        public Criteria andCustomerNameLessThan(String value) {
            addCriterion("CUSTOMER_NAME <", value, "customerName");
            return (Criteria) this;
        }

        public Criteria andCustomerNameLessThanOrEqualTo(String value) {
            addCriterion("CUSTOMER_NAME <=", value, "customerName");
            return (Criteria) this;
        }

        public Criteria andCustomerNameLike(String value) {
            addCriterion("CUSTOMER_NAME like", value, "customerName");
            return (Criteria) this;
        }

        public Criteria andCustomerNameNotLike(String value) {
            addCriterion("CUSTOMER_NAME not like", value, "customerName");
            return (Criteria) this;
        }

        public Criteria andCustomerNameIn(List<String> values) {
            addCriterion("CUSTOMER_NAME in", values, "customerName");
            return (Criteria) this;
        }

        public Criteria andCustomerNameNotIn(List<String> values) {
            addCriterion("CUSTOMER_NAME not in", values, "customerName");
            return (Criteria) this;
        }

        public Criteria andCustomerNameBetween(String value1, String value2) {
            addCriterion("CUSTOMER_NAME between", value1, value2, "customerName");
            return (Criteria) this;
        }

        public Criteria andCustomerNameNotBetween(String value1, String value2) {
            addCriterion("CUSTOMER_NAME not between", value1, value2, "customerName");
            return (Criteria) this;
        }

        public Criteria andIndustryIsNull() {
            addCriterion("INDUSTRY is null");
            return (Criteria) this;
        }

        public Criteria andIndustryIsNotNull() {
            addCriterion("INDUSTRY is not null");
            return (Criteria) this;
        }

        public Criteria andIndustryEqualTo(String value) {
            addCriterion("INDUSTRY =", value, "industry");
            return (Criteria) this;
        }

        public Criteria andIndustryNotEqualTo(String value) {
            addCriterion("INDUSTRY <>", value, "industry");
            return (Criteria) this;
        }

        public Criteria andIndustryGreaterThan(String value) {
            addCriterion("INDUSTRY >", value, "industry");
            return (Criteria) this;
        }

        public Criteria andIndustryGreaterThanOrEqualTo(String value) {
            addCriterion("INDUSTRY >=", value, "industry");
            return (Criteria) this;
        }

        public Criteria andIndustryLessThan(String value) {
            addCriterion("INDUSTRY <", value, "industry");
            return (Criteria) this;
        }

        public Criteria andIndustryLessThanOrEqualTo(String value) {
            addCriterion("INDUSTRY <=", value, "industry");
            return (Criteria) this;
        }

        public Criteria andIndustryLike(String value) {
            addCriterion("INDUSTRY like", value, "industry");
            return (Criteria) this;
        }

        public Criteria andIndustryNotLike(String value) {
            addCriterion("INDUSTRY not like", value, "industry");
            return (Criteria) this;
        }

        public Criteria andIndustryIn(List<String> values) {
            addCriterion("INDUSTRY in", values, "industry");
            return (Criteria) this;
        }

        public Criteria andIndustryNotIn(List<String> values) {
            addCriterion("INDUSTRY not in", values, "industry");
            return (Criteria) this;
        }

        public Criteria andIndustryBetween(String value1, String value2) {
            addCriterion("INDUSTRY between", value1, value2, "industry");
            return (Criteria) this;
        }

        public Criteria andIndustryNotBetween(String value1, String value2) {
            addCriterion("INDUSTRY not between", value1, value2, "industry");
            return (Criteria) this;
        }

        public Criteria andAreaIsNull() {
            addCriterion("AREA is null");
            return (Criteria) this;
        }

        public Criteria andAreaIsNotNull() {
            addCriterion("AREA is not null");
            return (Criteria) this;
        }

        public Criteria andAreaEqualTo(String value) {
            addCriterion("AREA =", value, "area");
            return (Criteria) this;
        }

        public Criteria andAreaNotEqualTo(String value) {
            addCriterion("AREA <>", value, "area");
            return (Criteria) this;
        }

        public Criteria andAreaGreaterThan(String value) {
            addCriterion("AREA >", value, "area");
            return (Criteria) this;
        }

        public Criteria andAreaGreaterThanOrEqualTo(String value) {
            addCriterion("AREA >=", value, "area");
            return (Criteria) this;
        }

        public Criteria andAreaLessThan(String value) {
            addCriterion("AREA <", value, "area");
            return (Criteria) this;
        }

        public Criteria andAreaLessThanOrEqualTo(String value) {
            addCriterion("AREA <=", value, "area");
            return (Criteria) this;
        }

        public Criteria andAreaLike(String value) {
            addCriterion("AREA like", value, "area");
            return (Criteria) this;
        }

        public Criteria andAreaNotLike(String value) {
            addCriterion("AREA not like", value, "area");
            return (Criteria) this;
        }

        public Criteria andAreaIn(List<String> values) {
            addCriterion("AREA in", values, "area");
            return (Criteria) this;
        }

        public Criteria andAreaNotIn(List<String> values) {
            addCriterion("AREA not in", values, "area");
            return (Criteria) this;
        }

        public Criteria andAreaBetween(String value1, String value2) {
            addCriterion("AREA between", value1, value2, "area");
            return (Criteria) this;
        }

        public Criteria andAreaNotBetween(String value1, String value2) {
            addCriterion("AREA not between", value1, value2, "area");
            return (Criteria) this;
        }

        public Criteria andProductServiceIsNull() {
            addCriterion("PRODUCT_SERVICE is null");
            return (Criteria) this;
        }

        public Criteria andProductServiceIsNotNull() {
            addCriterion("PRODUCT_SERVICE is not null");
            return (Criteria) this;
        }

        public Criteria andProductServiceEqualTo(String value) {
            addCriterion("PRODUCT_SERVICE =", value, "productService");
            return (Criteria) this;
        }

        public Criteria andProductServiceNotEqualTo(String value) {
            addCriterion("PRODUCT_SERVICE <>", value, "productService");
            return (Criteria) this;
        }

        public Criteria andProductServiceGreaterThan(String value) {
            addCriterion("PRODUCT_SERVICE >", value, "productService");
            return (Criteria) this;
        }

        public Criteria andProductServiceGreaterThanOrEqualTo(String value) {
            addCriterion("PRODUCT_SERVICE >=", value, "productService");
            return (Criteria) this;
        }

        public Criteria andProductServiceLessThan(String value) {
            addCriterion("PRODUCT_SERVICE <", value, "productService");
            return (Criteria) this;
        }

        public Criteria andProductServiceLessThanOrEqualTo(String value) {
            addCriterion("PRODUCT_SERVICE <=", value, "productService");
            return (Criteria) this;
        }

        public Criteria andProductServiceLike(String value) {
            addCriterion("PRODUCT_SERVICE like", value, "productService");
            return (Criteria) this;
        }

        public Criteria andProductServiceNotLike(String value) {
            addCriterion("PRODUCT_SERVICE not like", value, "productService");
            return (Criteria) this;
        }

        public Criteria andProductServiceIn(List<String> values) {
            addCriterion("PRODUCT_SERVICE in", values, "productService");
            return (Criteria) this;
        }

        public Criteria andProductServiceNotIn(List<String> values) {
            addCriterion("PRODUCT_SERVICE not in", values, "productService");
            return (Criteria) this;
        }

        public Criteria andProductServiceBetween(String value1, String value2) {
            addCriterion("PRODUCT_SERVICE between", value1, value2, "productService");
            return (Criteria) this;
        }

        public Criteria andProductServiceNotBetween(String value1, String value2) {
            addCriterion("PRODUCT_SERVICE not between", value1, value2, "productService");
            return (Criteria) this;
        }

        public Criteria andTotalSalePercentIsNull() {
            addCriterion("TOTAL_SALE_PERCENT is null");
            return (Criteria) this;
        }

        public Criteria andTotalSalePercentIsNotNull() {
            addCriterion("TOTAL_SALE_PERCENT is not null");
            return (Criteria) this;
        }

        public Criteria andTotalSalePercentEqualTo(BigDecimal value) {
            addCriterion("TOTAL_SALE_PERCENT =", value, "totalSalePercent");
            return (Criteria) this;
        }

        public Criteria andTotalSalePercentNotEqualTo(BigDecimal value) {
            addCriterion("TOTAL_SALE_PERCENT <>", value, "totalSalePercent");
            return (Criteria) this;
        }

        public Criteria andTotalSalePercentGreaterThan(BigDecimal value) {
            addCriterion("TOTAL_SALE_PERCENT >", value, "totalSalePercent");
            return (Criteria) this;
        }

        public Criteria andTotalSalePercentGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("TOTAL_SALE_PERCENT >=", value, "totalSalePercent");
            return (Criteria) this;
        }

        public Criteria andTotalSalePercentLessThan(BigDecimal value) {
            addCriterion("TOTAL_SALE_PERCENT <", value, "totalSalePercent");
            return (Criteria) this;
        }

        public Criteria andTotalSalePercentLessThanOrEqualTo(BigDecimal value) {
            addCriterion("TOTAL_SALE_PERCENT <=", value, "totalSalePercent");
            return (Criteria) this;
        }

        public Criteria andTotalSalePercentIn(List<BigDecimal> values) {
            addCriterion("TOTAL_SALE_PERCENT in", values, "totalSalePercent");
            return (Criteria) this;
        }

        public Criteria andTotalSalePercentNotIn(List<BigDecimal> values) {
            addCriterion("TOTAL_SALE_PERCENT not in", values, "totalSalePercent");
            return (Criteria) this;
        }

        public Criteria andTotalSalePercentBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("TOTAL_SALE_PERCENT between", value1, value2, "totalSalePercent");
            return (Criteria) this;
        }

        public Criteria andTotalSalePercentNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("TOTAL_SALE_PERCENT not between", value1, value2, "totalSalePercent");
            return (Criteria) this;
        }

        public Criteria andStartTimeIsNull() {
            addCriterion("START_TIME is null");
            return (Criteria) this;
        }

        public Criteria andStartTimeIsNotNull() {
            addCriterion("START_TIME is not null");
            return (Criteria) this;
        }

        public Criteria andStartTimeEqualTo(Date value) {
            addCriterion("START_TIME =", value, "startTime");
            return (Criteria) this;
        }

        public Criteria andStartTimeNotEqualTo(Date value) {
            addCriterion("START_TIME <>", value, "startTime");
            return (Criteria) this;
        }

        public Criteria andStartTimeGreaterThan(Date value) {
            addCriterion("START_TIME >", value, "startTime");
            return (Criteria) this;
        }

        public Criteria andStartTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("START_TIME >=", value, "startTime");
            return (Criteria) this;
        }

        public Criteria andStartTimeLessThan(Date value) {
            addCriterion("START_TIME <", value, "startTime");
            return (Criteria) this;
        }

        public Criteria andStartTimeLessThanOrEqualTo(Date value) {
            addCriterion("START_TIME <=", value, "startTime");
            return (Criteria) this;
        }

        public Criteria andStartTimeIn(List<Date> values) {
            addCriterion("START_TIME in", values, "startTime");
            return (Criteria) this;
        }

        public Criteria andStartTimeNotIn(List<Date> values) {
            addCriterion("START_TIME not in", values, "startTime");
            return (Criteria) this;
        }

        public Criteria andStartTimeBetween(Date value1, Date value2) {
            addCriterion("START_TIME between", value1, value2, "startTime");
            return (Criteria) this;
        }

        public Criteria andStartTimeNotBetween(Date value1, Date value2) {
            addCriterion("START_TIME not between", value1, value2, "startTime");
            return (Criteria) this;
        }

        public Criteria andExplainationIsNull() {
            addCriterion("EXPLAINATION is null");
            return (Criteria) this;
        }

        public Criteria andExplainationIsNotNull() {
            addCriterion("EXPLAINATION is not null");
            return (Criteria) this;
        }

        public Criteria andExplainationEqualTo(String value) {
            addCriterion("EXPLAINATION =", value, "explaination");
            return (Criteria) this;
        }

        public Criteria andExplainationNotEqualTo(String value) {
            addCriterion("EXPLAINATION <>", value, "explaination");
            return (Criteria) this;
        }

        public Criteria andExplainationGreaterThan(String value) {
            addCriterion("EXPLAINATION >", value, "explaination");
            return (Criteria) this;
        }

        public Criteria andExplainationGreaterThanOrEqualTo(String value) {
            addCriterion("EXPLAINATION >=", value, "explaination");
            return (Criteria) this;
        }

        public Criteria andExplainationLessThan(String value) {
            addCriterion("EXPLAINATION <", value, "explaination");
            return (Criteria) this;
        }

        public Criteria andExplainationLessThanOrEqualTo(String value) {
            addCriterion("EXPLAINATION <=", value, "explaination");
            return (Criteria) this;
        }

        public Criteria andExplainationLike(String value) {
            addCriterion("EXPLAINATION like", value, "explaination");
            return (Criteria) this;
        }

        public Criteria andExplainationNotLike(String value) {
            addCriterion("EXPLAINATION not like", value, "explaination");
            return (Criteria) this;
        }

        public Criteria andExplainationIn(List<String> values) {
            addCriterion("EXPLAINATION in", values, "explaination");
            return (Criteria) this;
        }

        public Criteria andExplainationNotIn(List<String> values) {
            addCriterion("EXPLAINATION not in", values, "explaination");
            return (Criteria) this;
        }

        public Criteria andExplainationBetween(String value1, String value2) {
            addCriterion("EXPLAINATION between", value1, value2, "explaination");
            return (Criteria) this;
        }

        public Criteria andExplainationNotBetween(String value1, String value2) {
            addCriterion("EXPLAINATION not between", value1, value2, "explaination");
            return (Criteria) this;
        }

        public Criteria andCarIndustryPercentIsNull() {
            addCriterion("CAR_INDUSTRY_PERCENT is null");
            return (Criteria) this;
        }

        public Criteria andCarIndustryPercentIsNotNull() {
            addCriterion("CAR_INDUSTRY_PERCENT is not null");
            return (Criteria) this;
        }

        public Criteria andCarIndustryPercentEqualTo(BigDecimal value) {
            addCriterion("CAR_INDUSTRY_PERCENT =", value, "carIndustryPercent");
            return (Criteria) this;
        }

        public Criteria andCarIndustryPercentNotEqualTo(BigDecimal value) {
            addCriterion("CAR_INDUSTRY_PERCENT <>", value, "carIndustryPercent");
            return (Criteria) this;
        }

        public Criteria andCarIndustryPercentGreaterThan(BigDecimal value) {
            addCriterion("CAR_INDUSTRY_PERCENT >", value, "carIndustryPercent");
            return (Criteria) this;
        }

        public Criteria andCarIndustryPercentGreaterThanOrEqualTo(BigDecimal value) {
            addCriterion("CAR_INDUSTRY_PERCENT >=", value, "carIndustryPercent");
            return (Criteria) this;
        }

        public Criteria andCarIndustryPercentLessThan(BigDecimal value) {
            addCriterion("CAR_INDUSTRY_PERCENT <", value, "carIndustryPercent");
            return (Criteria) this;
        }

        public Criteria andCarIndustryPercentLessThanOrEqualTo(BigDecimal value) {
            addCriterion("CAR_INDUSTRY_PERCENT <=", value, "carIndustryPercent");
            return (Criteria) this;
        }

        public Criteria andCarIndustryPercentIn(List<BigDecimal> values) {
            addCriterion("CAR_INDUSTRY_PERCENT in", values, "carIndustryPercent");
            return (Criteria) this;
        }

        public Criteria andCarIndustryPercentNotIn(List<BigDecimal> values) {
            addCriterion("CAR_INDUSTRY_PERCENT not in", values, "carIndustryPercent");
            return (Criteria) this;
        }

        public Criteria andCarIndustryPercentBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("CAR_INDUSTRY_PERCENT between", value1, value2, "carIndustryPercent");
            return (Criteria) this;
        }

        public Criteria andCarIndustryPercentNotBetween(BigDecimal value1, BigDecimal value2) {
            addCriterion("CAR_INDUSTRY_PERCENT not between", value1, value2, "carIndustryPercent");
            return (Criteria) this;
        }

        public Criteria andIsEnableIsNull() {
            addCriterion("IS_ENABLE is null");
            return (Criteria) this;
        }

        public Criteria andIsEnableIsNotNull() {
            addCriterion("IS_ENABLE is not null");
            return (Criteria) this;
        }

        public Criteria andIsEnableEqualTo(Integer value) {
            addCriterion("IS_ENABLE =", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableNotEqualTo(Integer value) {
            addCriterion("IS_ENABLE <>", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableGreaterThan(Integer value) {
            addCriterion("IS_ENABLE >", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableGreaterThanOrEqualTo(Integer value) {
            addCriterion("IS_ENABLE >=", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableLessThan(Integer value) {
            addCriterion("IS_ENABLE <", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableLessThanOrEqualTo(Integer value) {
            addCriterion("IS_ENABLE <=", value, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableIn(List<Integer> values) {
            addCriterion("IS_ENABLE in", values, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableNotIn(List<Integer> values) {
            addCriterion("IS_ENABLE not in", values, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableBetween(Integer value1, Integer value2) {
            addCriterion("IS_ENABLE between", value1, value2, "isEnable");
            return (Criteria) this;
        }

        public Criteria andIsEnableNotBetween(Integer value1, Integer value2) {
            addCriterion("IS_ENABLE not between", value1, value2, "isEnable");
            return (Criteria) this;
        }

        public Criteria andFinishFlagIsNull() {
            addCriterion("FINISH_FLAG is null");
            return (Criteria) this;
        }

        public Criteria andFinishFlagIsNotNull() {
            addCriterion("FINISH_FLAG is not null");
            return (Criteria) this;
        }

        public Criteria andFinishFlagEqualTo(Integer value) {
            addCriterion("FINISH_FLAG =", value, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagNotEqualTo(Integer value) {
            addCriterion("FINISH_FLAG <>", value, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagGreaterThan(Integer value) {
            addCriterion("FINISH_FLAG >", value, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagGreaterThanOrEqualTo(Integer value) {
            addCriterion("FINISH_FLAG >=", value, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagLessThan(Integer value) {
            addCriterion("FINISH_FLAG <", value, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagLessThanOrEqualTo(Integer value) {
            addCriterion("FINISH_FLAG <=", value, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagIn(List<Integer> values) {
            addCriterion("FINISH_FLAG in", values, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagNotIn(List<Integer> values) {
            addCriterion("FINISH_FLAG not in", values, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagBetween(Integer value1, Integer value2) {
            addCriterion("FINISH_FLAG between", value1, value2, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andFinishFlagNotBetween(Integer value1, Integer value2) {
            addCriterion("FINISH_FLAG not between", value1, value2, "finishFlag");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNull() {
            addCriterion("CREATE_TIME is null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNotNull() {
            addCriterion("CREATE_TIME is not null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeEqualTo(Date value) {
            addCriterion("CREATE_TIME =", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotEqualTo(Date value) {
            addCriterion("CREATE_TIME <>", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThan(Date value) {
            addCriterion("CREATE_TIME >", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("CREATE_TIME >=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThan(Date value) {
            addCriterion("CREATE_TIME <", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThanOrEqualTo(Date value) {
            addCriterion("CREATE_TIME <=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIn(List<Date> values) {
            addCriterion("CREATE_TIME in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotIn(List<Date> values) {
            addCriterion("CREATE_TIME not in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeBetween(Date value1, Date value2) {
            addCriterion("CREATE_TIME between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotBetween(Date value1, Date value2) {
            addCriterion("CREATE_TIME not between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeIsNull() {
            addCriterion("UPDATE_TIME is null");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeIsNotNull() {
            addCriterion("UPDATE_TIME is not null");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeEqualTo(Date value) {
            addCriterion("UPDATE_TIME =", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeNotEqualTo(Date value) {
            addCriterion("UPDATE_TIME <>", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeGreaterThan(Date value) {
            addCriterion("UPDATE_TIME >", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("UPDATE_TIME >=", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeLessThan(Date value) {
            addCriterion("UPDATE_TIME <", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeLessThanOrEqualTo(Date value) {
            addCriterion("UPDATE_TIME <=", value, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeIn(List<Date> values) {
            addCriterion("UPDATE_TIME in", values, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeNotIn(List<Date> values) {
            addCriterion("UPDATE_TIME not in", values, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeBetween(Date value1, Date value2) {
            addCriterion("UPDATE_TIME between", value1, value2, "updateTime");
            return (Criteria) this;
        }

        public Criteria andUpdateTimeNotBetween(Date value1, Date value2) {
            addCriterion("UPDATE_TIME not between", value1, value2, "updateTime");
            return (Criteria) this;
        }
    }

    public static class Criteria extends GeneratedCriteria implements Serializable {
        private static final long serialVersionUID = 1L;

        protected Criteria() {
            super();
        }
    }

    public static class Criterion implements Serializable {
        private String condition;

        private Object value;

        private Object secondValue;

        private boolean noValue;

        private boolean singleValue;

        private boolean betweenValue;

        private boolean listValue;

        private String typeHandler;

        private static final long serialVersionUID = 1L;

        public String getCondition() {
            return condition;
        }

        public Object getValue() {
            return value;
        }

        public Object getSecondValue() {
            return secondValue;
        }

        public boolean isNoValue() {
            return noValue;
        }

        public boolean isSingleValue() {
            return singleValue;
        }

        public boolean isBetweenValue() {
            return betweenValue;
        }

        public boolean isListValue() {
            return listValue;
        }

        public String getTypeHandler() {
            return typeHandler;
        }

        protected Criterion(String condition) {
            super();
            this.condition = condition;
            this.typeHandler = null;
            this.noValue = true;
        }

        protected Criterion(String condition, Object value, String typeHandler) {
            super();
            this.condition = condition;
            this.value = value;
            this.typeHandler = typeHandler;
            if (value instanceof List<?>) {
                this.listValue = true;
            } else {
                this.singleValue = true;
            }
        }

        protected Criterion(String condition, Object value) {
            this(condition, value, null);
        }

        protected Criterion(String condition, Object value, Object secondValue, String typeHandler) {
            super();
            this.condition = condition;
            this.value = value;
            this.secondValue = secondValue;
            this.typeHandler = typeHandler;
            this.betweenValue = true;
        }

        protected Criterion(String condition, Object value, Object secondValue) {
            this(condition, value, secondValue, null);
        }
    }
}