package com.els.base.certification.customer.service;

import java.util.List;

import com.els.base.certification.customer.entity.CompanyCustomer;
import com.els.base.certification.customer.entity.CompanyCustomerExample;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.project.Project;
import com.els.base.core.service.BaseService;

public interface CompanyCustomerService extends BaseService<CompanyCustomer, CompanyCustomerExample, String> {
	
	/**
	 * 批量插入供应商客户
     * @param projectId
     * @param supCompany
     * @param purCompany
     * @param customerList
     */
	Integer batchInsert(String projectId, Company supCompany, Company purCompany, List<CompanyCustomer> customerList);

	/**
	 * 删除数据
	 * @param projectId
	 * @param company
	 * @param ids
	 */
	void deleteObjByIds(String projectId, Company company, List<String> ids);

	/**
	 * 判断资料是否已经填写完整
	 * @param project
	 * @param company
	 * @return
	 */
    Integer isFinish(Project project, Company company);
}