package com.els.base.certification.exempt.service.impl;

import com.els.base.auth.entity.Role;
import com.els.base.auth.entity.RoleExample;
import com.els.base.auth.entity.User;
import com.els.base.auth.entity.UserRole;
import com.els.base.auth.entity.UserRoleExample;
import com.els.base.auth.service.RoleService;
import com.els.base.auth.service.UserRoleService;
import com.els.base.certification.apply.util.DocumentStatusEnum;
import com.els.base.certification.exempt.dao.ExemptMapper;
import com.els.base.certification.exempt.entity.Exempt;
import com.els.base.certification.exempt.entity.ExemptExample;
import com.els.base.certification.exempt.service.ExemptService;
import com.els.base.certification.exempt.utils.ExemptUtils;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyPartner;
import com.els.base.company.entity.CompanyPartnerExample;
import com.els.base.company.entity.CompanyUserRef;
import com.els.base.company.entity.CompanyUserRefExample;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.company.utils.PartnerRoleEnum;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.file.entity.FileData;
import com.els.base.workflow.common.entity.ProcessStartVO;
import com.els.base.workflow.common.event.TaskOperateEvent;
import com.els.base.workflow.common.service.ITaskListener;
import com.els.base.workflow.common.service.WorkFlowService;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service("defaultExemptService")
public class ExemptServiceImpl implements ExemptService,ITaskListener {
	@Resource
	protected ExemptMapper exemptMapper;

	@Resource
	protected CompanyService companyService;

	@Resource
	protected GenerateCodeService generateCodeService;

	@Resource
	protected RoleService roleService;

	@Resource
	protected CompanyUserRefService companyUserRefService;

	@Resource
	protected UserRoleService userRoleService;
	
	@Resource 
	private WorkFlowService workFlowService;

	@Transactional
	@CacheEvict(value = { "exempt" }, allEntries = true)
	@Override
	public void addObj(Exempt t) {
		this.exemptMapper.insertSelective(t);
	}
	
	@Transactional
	@CacheEvict(value = { "exempt" }, allEntries = true)
	@Override
	public void insert(User user, Exempt t) {
		List<String> list=new ArrayList<>();
		list.add(DocumentStatusEnum.NOT_AUDITED.getCode());
		list.add(DocumentStatusEnum.BEING_AUDITED.getCode());
		list.add(DocumentStatusEnum.AUDITED.getCode());
		
		ExemptExample example = new ExemptExample();
		ExemptExample.Criteria criteria = example.createCriteria();
		criteria.andSupCompanySrmCodeEqualTo(t.getSupCompanySrmCode())
				.andIsEnableEqualTo(Constant.YES_INT)
				.andStatusIn(list);
		
		if (this.exemptMapper.countByExample(example) > 0) {
			throw new CommonException("此供应商编码已有未被驳回或未作废的单据,不能再添加 " + t.getSupCompanySrmCode());
		}

		String companyCode = t.getSupCompanySrmCode();
		Company c = this.companyService.queryCompanyByCode(companyCode);
		t.setId(null);
		t.setProjectId(c.getProjectId());
		t.setSupCompanyId(c.getId());
		t.setSinglePerson(user.getLoginName() + "+" + user.getNickName());
		t.setDocumentNumber(generateCodeService.getNextCode("SUPPLIER_EXEMPTION_NO"));
		this.exemptMapper.insertSelective(t);
	}
	
	@Transactional
	@CacheEvict(value = { "exempt" }, allEntries = true)
	@Override
	public void deleteObjByIds(List<Exempt> supExempt) {
		for (Exempt exempt : supExempt) {
			if (exempt.getIsInvalid() == Constant.YES_INT) {
				throw new CommonException("单据作废，不能进行此操作");
			}
			if (StringUtils.isBlank(exempt.getId())) {
				throw new CommonException("删除失败,id不能为空");
			}
			if (exempt.getStatus().equals(DocumentStatusEnum.NOT_AUDITED.getCode())) {
				this.exemptMapper.deleteByPrimaryKey(exempt.getId());
			} else {
				throw new CommonException("单据已发送审批或已审批或已驳回，不能删除");
			}
		}
	}

	@Transactional
	@CacheEvict(value = { "exempt" }, allEntries = true)
	@Override
	public void updateIsInvalid(List<Exempt> supExempt) {
		for (Exempt exempt : supExempt) {
			if (exempt.getIsInvalid() == Constant.YES_INT) {
				throw new CommonException("单据已作废，不能进行此操作");
			}
			if (StringUtils.isBlank(exempt.getId())) {
				throw new CommonException("id 为空，操作失败");
			}
			if (exempt.getStatus().equals(DocumentStatusEnum.BEING_AUDITED.getCode())) {
				exempt.setIsInvalid(Constant.YES_INT);
				exempt.setStatus(DocumentStatusEnum.INVALID.getCode());
				this.exemptMapper.updateByPrimaryKeySelective(exempt);
				this.workFlowService.stopProcess("gyshmd", exempt.getDocumentNumber());
			} else {
				throw new CommonException("你选的单据是新建或已审核或已驳回，不能作废");
			}
		}
	}

	@CacheEvict(value = { "exempt" }, allEntries = true)
	@Override
	public void modifyObj(Exempt t) {
		if (StringUtils.isBlank(t.getId())) {
			throw new NullPointerException("id 为空，无法更新");
		}
		Exempt exempt=this.exemptMapper.selectByPrimaryKey(t.getId());
		if(t.getSupCompanySrmCode().equals(exempt.getSupCompanySrmCode())){
			this.exemptMapper.updateByPrimaryKeySelective(t);
		}else{
			List<String> list=new ArrayList<>();
			list.add(DocumentStatusEnum.NOT_AUDITED.getCode());
			list.add(DocumentStatusEnum.BEING_AUDITED.getCode());
			list.add(DocumentStatusEnum.AUDITED.getCode());
			
			ExemptExample exemptExample=new ExemptExample();
			exemptExample.createCriteria().andSupCompanySrmCodeEqualTo(t.getSupCompanySrmCode())
						.andIsEnableEqualTo(Constant.YES_INT)
						.andStatusIn(list);
			if(this.exemptMapper.countByExample(exemptExample)>0){
				throw new CommonException("此供应商编码已有未被驳回或未作废的单据，不能再添加");
			}
			Company supCompany = this.companyService.queryCompanyByCode(t.getSupCompanySrmCode());
			t.setSupCompanyId(supCompany.getId());
			this.exemptMapper.updateByPrimaryKeySelective(t);
		}
	}

	@Cacheable(value = "exempt", keyGenerator = "redisKeyGenerator")
	@Override
	public Exempt queryObjById(String id) {
		return this.exemptMapper.selectByPrimaryKey(id);
	}

	@Cacheable(value = "exempt", keyGenerator = "redisKeyGenerator")
	@Override
	public List<Exempt> queryAllObjByExample(ExemptExample example) {
		return this.exemptMapper.selectByExample(example);
	}

	@Cacheable(value = "exempt", keyGenerator = "redisKeyGenerator")
	@Override
	public PageView<Exempt> queryObjByPage(ExemptExample example) {
		PageView<Exempt> pageView = example.getPageView();
		pageView.setQueryResult(this.exemptMapper.selectByExampleByPage(example));
		return pageView;
	}

	@Transactional
	@CacheEvict(value = { "exempt" }, allEntries = true)
	@Override
	public void sendToApprove(List<String> ids) {
		List<String> list = new ArrayList<String>();
		list.add(DocumentStatusEnum.BEING_AUDITED.getCode());
		list.add(DocumentStatusEnum.AUDITED.getCode());
		list.add(DocumentStatusEnum.DISMISSAL.getCode());
		list.add(DocumentStatusEnum.INVALID.getCode());
		ExemptExample example = new ExemptExample();
		example.createCriteria().andIdIn(ids).andStatusIn(list);
		if (this.exemptMapper.countByExample(example) > 0) {
			throw new CommonException("你发送的单据包含已发送审批或已审核或已驳回或已作废，不能发送审批");
		}
		example.clear();
		example.createCriteria().andIdIn(ids);
		
		List<Exempt> exemptList=this.exemptMapper.selectByExample(example);
		Assert.isNotEmpty(exemptList,"查询的数据为空" );
		for(Exempt exempt : exemptList){
			ProcessStartVO vo = ProcessStartVO.newInstance("gyshmd",exempt.getDocumentNumber(),exempt.getId(),"supExemptionBill?id="+exempt.getId());
			vo.setListenerClass(this.getClass());
			ProcessInstance startProcess = this.workFlowService.startProcess(vo);
			if(startProcess!=null){
				Exempt e=new Exempt();
				e.setStatus(DocumentStatusEnum.BEING_AUDITED.getCode());
				e.setAuditTime(new Date());
				
				example.clear();
				example.createCriteria().andIdEqualTo(exempt.getId());
				this.exemptMapper.updateByExampleSelective(e, example);
			}
		}
		/*// 调用通过审核方法
		for (String id : ids) {
			this.updateStatus(id);
		}*/
	}

	@Transactional
	@CacheEvict(value = { "exempt" }, allEntries = true)
	@Override
	public void updateStatus(String id) {
		// 更改单据状态为已审核
		if (StringUtils.isBlank(id)) {
			throw new CommonException("豁免单据ID为空，操作失败");
		}
		/*if (!exempt.getStatus().equals(DocumentStatusEnum.BEING_AUDITED.getCode())) {
			throw new CommonException("单据状态不是已发送审核，不能执行此操作");
		}
		exempt.setStatus(DocumentStatusEnum.AUDITED.getCode());
		this.exemptMapper.updateByPrimaryKeySelective(exempt);*/
		Exempt exempt = this.exemptMapper.selectByPrimaryKey(id);
		// 审核通过直接将供应商变为合格供应商
		String companyId = exempt.getSupCompanyId();
		CompanyPartnerExample example = new CompanyPartnerExample();
		example.createCriteria().andPartnerCompanyIdEqualTo(companyId);
		CompanyPartner companyPartner = new CompanyPartner();
		companyPartner.setPartnerRoleCode(PartnerRoleEnum.QUALIFIED.getCode());
		companyPartner.setPartnerRoleName(PartnerRoleEnum.QUALIFIED.getName());
		this.companyService.updatePartnerRole(companyPartner, example);
		// 变为合格供应商后，分配合格供应商角色
		RoleExample roleExample = new RoleExample();
		roleExample.createCriteria().andRoleCodeEqualTo(PartnerRoleEnum.QUALIFIED.getUserRoleCode());
		List<Role> list = roleService.queryAllObjByExample(roleExample);
		if (CollectionUtils.isNotEmpty(list)) {
			CompanyUserRefExample companyUserExample = new CompanyUserRefExample();
			companyUserExample.createCriteria().andCompanyIdEqualTo(companyId);
			List<CompanyUserRef> companyUserRef = this.companyUserRefService.queryAllObjByExample(companyUserExample);
			UserRoleExample userRoleExample = new UserRoleExample();
			userRoleExample.createCriteria().andUserIdEqualTo(companyUserRef.get(0).getUserId());
			List<UserRole> userRole = this.userRoleService.queryAllObjByExample(userRoleExample);
			for (UserRole ur : userRole) {
				for (Role role : list) {
					ur.setRoleId(role.getId());
					ur.setCreateTime(new Date());
					this.userRoleService.modifyObj(ur);
				}
			}
		}
	}

	@Transactional
	@CacheEvict(value = { "exempt" }, allEntries = true)
	@Override
	public void deleteObjById(String id) {
		this.exemptMapper.deleteByPrimaryKey(id);
	}
	
	@CacheEvict(value = { "exempt" }, allEntries = true)
	@Override
	public void listen(TaskOperateEvent event) {
		ExemptExample exemptExample=new ExemptExample();
		exemptExample.createCriteria().andIdEqualTo(event.getBusinessId());
		Exempt e=this.exemptMapper.selectByPrimaryKey(event.getBusinessId());
		e.setAuditTime(new Date());
		e.setPendingApprovalPeople(event.getAssignee());
		if(event.isFinished() && event.isPass()){
			//审批流完成而且通过
			e.setStatus(DocumentStatusEnum.AUDITED.getCode());
			//通过后修改供应商角色
			this.updateStatus(event.getBusinessId());
		}else if(event.isFinished() && !event.isPass()){
			//审批流完成但被驳回
			e.setStatus(DocumentStatusEnum.DISMISSAL.getCode());
		}
		this.exemptMapper.updateByExampleSelective(e, exemptExample);
	}
	
	@CacheEvict(value = { "exempt" }, allEntries = true)
	@Override
	public FileData print(String projectId, String companyId, List<Exempt> data) {
		Assert.isNotEmpty(data, "传输的数据为空，不能打印");
		//批量获取ID
		List<String> ids=null;
		for(Exempt e : data){
			Assert.isNotBlank(e.getId(), "传输的单据中存在ID为空");
			if(ids==null){
				ids=new ArrayList<>();
			}
			ids.add(e.getId());
		}
		//根据id查询数据
		ExemptExample exemptExample = new ExemptExample();
		exemptExample.createCriteria().andIdIn(ids);
		
		List<Exempt> exemptList=this.exemptMapper.selectByExample(exemptExample);
		Assert.isNotEmpty(exemptList, "查询的数据为空，无法打印");
		
		//创建打印数据
		Map<String,Object> params=new HashMap<String,Object>();
		params.put("exemptList", exemptList);
		//创建文件信息
		FileData fileData=null;
		try{
			fileData=ExemptUtils.generatePdf(projectId,companyId,params,"A4");
		}catch(Exception e){
			e.printStackTrace();
		}
		return fileData;
	}
}