package com.els.base.certification.file.service;

import com.els.base.certification.file.entity.CompanyFile;
import com.els.base.certification.file.entity.CompanyFileExample;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.project.Project;
import com.els.base.core.service.BaseService;

import java.util.List;

public interface CompanyFileService extends BaseService<CompanyFile, CompanyFileExample, String> {

    /**
     * 批量软删除
     * @param projectId
     * @param company
     * @param ids
     */
    void deleteObjByIds(String projectId, Company company, List<String> ids);

    /**
     * 批量插入供应商附件
     * @param projectId
     * @param company
     * @param companyFileList
     */
    Integer batchInsert(String projectId, Company company, List<CompanyFile> companyFileList);

    /**
     * 判断资料是否已经填写完成
     * @param project
     * @param company
     * @return
     */
    Integer isFinish(Project project, Company company);
}