package com.els.base.certification.file.service.impl;

import com.els.base.certification.file.dao.CompanyFileMapper;
import com.els.base.certification.file.entity.CompanyFile;
import com.els.base.certification.file.entity.CompanyFileExample;
import com.els.base.certification.file.service.CompanyFileService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;

import com.els.base.core.entity.project.Project;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service("defaultCompanyFileService")
public class CompanyFileServiceImpl implements CompanyFileService {

    @Resource
    private CompanyFileMapper companyFileMapper;

    @Cacheable(value="companyFile", keyGenerator="redisKeyGenerator")
    @Override
    public Integer isFinish(Project project, Company company) {
        List<Integer> list = new ArrayList<Integer>();
        list.add(Constant.NO_INT);

        CompanyFileExample companyFileExample =new CompanyFileExample();

        //如果数据为空，那么返回0
        companyFileExample.createCriteria()
                .andProjectIdEqualTo(project.getId())
                .andSupCompanyIdEqualTo(company.getId())
                .andIsEnableEqualTo(Constant.YES_INT);
        int count = this.companyFileMapper.countByExample(companyFileExample);
        if(count<=0){
            return 0;
        }

        //如果数据不为空，那么判断完成状态只要有0，那么返回未完成
        companyFileExample.clear();
        companyFileExample.createCriteria()
                .andProjectIdEqualTo(project.getId())
                .andSupCompanyIdEqualTo(company.getId())
                .andIsEnableEqualTo(Constant.YES_INT)
                .andFinishFlagIn(list);

        int finishCount = this.companyFileMapper.countByExample(companyFileExample);
        if(finishCount>0){
            return 0;
        }else{
            return 1;
        }
    }

    @CacheEvict(value={"companyFile"}, allEntries=true)
    @Transactional
    @Override
    public Integer batchInsert(String projectId, Company company, List<CompanyFile> companyFileList) {

        CompanyFileExample companyFileExample=new CompanyFileExample();
        companyFileExample.createCriteria()
                .andProjectIdEqualTo(projectId)
                .andSupCompanyIdEqualTo(company.getId())
                .andIsEnableEqualTo(Constant.YES_INT);
        CompanyFile companyFile=new CompanyFile();
        companyFile.setIsEnable(Constant.NO_INT);
        this.companyFileMapper.updateByExampleSelective(companyFile,companyFileExample);

        List<Integer> list = new ArrayList<Integer>();
        for (CompanyFile file : companyFileList) {
            file.setId(null);
            file.setProjectId(projectId);
            file.setUpdateTime(new Date());
            file.setIsEnable(Constant.YES_INT);
            file.setSupCompanyId(company.getId());

            if(file.getCreateTime()==null){
                file.setCreateTime(new Date());
            }

            Integer finishFlag = file.getFinishFlag();
            file.setFinishFlag(finishFlag);
            this.companyFileMapper.insertSelective(file);

            list.add(finishFlag);
        }

        if(list.contains(Constant.NO_INT)){
            return 0;
        }else{
            return 1;
        }

    }

    @CacheEvict(value={"companyFile"}, allEntries=true)
    @Transactional
    @Override
    public void deleteObjByIds(String projectId, Company company, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("数据不能为空", "base_canot_be_null", "操作失败，数据");
        }
        CompanyFileExample companyFileExample=new CompanyFileExample();
        companyFileExample.createCriteria()
                .andProjectIdEqualTo(projectId)
                .andSupCompanyIdEqualTo(company.getId())
                .andIsEnableEqualTo(Constant.YES_INT)
                .andIdIn(ids);
        CompanyFile companyFile=new CompanyFile();
        companyFile.setIsEnable(Constant.NO_INT);
        this.companyFileMapper.updateByExampleSelective(companyFile,companyFileExample);
    }

    @CacheEvict(value={"companyFile"}, allEntries=true)
    @Override
    public void addObj(CompanyFile t) {
        this.companyFileMapper.insertSelective(t);
    }

    @CacheEvict(value={"companyFile"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.companyFileMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"companyFile"}, allEntries=true)
    @Override
    public void modifyObj(CompanyFile t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.companyFileMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="companyFile", keyGenerator="redisKeyGenerator")
    @Override
    public CompanyFile queryObjById(String id) {
        return this.companyFileMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="companyFile", keyGenerator="redisKeyGenerator")
    @Override
    public List<CompanyFile> queryAllObjByExample(CompanyFileExample example) {
        return this.companyFileMapper.selectByExample(example);
    }

    @Cacheable(value="companyFile", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<CompanyFile> queryObjByPage(CompanyFileExample example) {
        PageView<CompanyFile> pageView = example.getPageView();
        pageView.setQueryResult(this.companyFileMapper.selectByExampleByPage(example));
        return pageView;
    }
}