package com.els.base.certification.finance.service.impl;

import com.els.base.certification.finance.dao.CompanyFinanceMapper;
import com.els.base.certification.finance.entity.CompanyFinance;
import com.els.base.certification.finance.entity.CompanyFinanceExample;
import com.els.base.certification.finance.service.CompanyFinanceService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("defaultCompanyFinanceService")
public class CompanyFinanceServiceImpl implements CompanyFinanceService {

    @Resource
    private CompanyFinanceMapper companyFinanceMapper;

    @Cacheable(value="companyAuth", keyGenerator="redisKeyGenerator")
    @Override
    public Integer isFinish(Project project, Company company) {
        List<Integer> list = new ArrayList<Integer>();
        list.add(Constant.NO_INT);

        CompanyFinanceExample companyFinanceExample =new CompanyFinanceExample();

        //如果数据为空，那么返回0
        companyFinanceExample.createCriteria()
                .andProjectIdEqualTo(project.getId())
                .andSupCompanyIdEqualTo(company.getId())
                .andIsEnableEqualTo(Constant.YES_INT);
        int count = this.companyFinanceMapper.countByExample(companyFinanceExample);
        if(count<=0){
            return 0;
        }

        companyFinanceExample.clear();
        companyFinanceExample.createCriteria()
                .andProjectIdEqualTo(project.getId())
                .andSupCompanyIdEqualTo(company.getId())
                .andIsEnableEqualTo(Constant.YES_INT)
                .andFinishFlagIn(list);

        int finishCount = this.companyFinanceMapper.countByExample(companyFinanceExample);
        if(finishCount>0){
            return 0;
        }else{
            return 1;
        }
    }

    @CacheEvict(value={"companyFinance"}, allEntries=true)
    @Transactional
    @Override
    public void deleteObjByIds(String projectId, Company company, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("数据不能为空", "base_canot_be_null", "操作失败，数据");
        }
        CompanyFinanceExample companyFinanceExample =new CompanyFinanceExample();
        companyFinanceExample.createCriteria().andProjectIdEqualTo(projectId)
                .andSupCompanyIdEqualTo(company.getId())
                .andIsEnableEqualTo(Constant.YES_INT)
                .andIdIn(ids);

        CompanyFinance companyFinance =new CompanyFinance();
        companyFinance.setIsEnable(Constant.NO_INT);

        this.companyFinanceMapper.updateByExampleSelective(companyFinance,companyFinanceExample);

    }

    @CacheEvict(value={"companyFinance"}, allEntries=true)
    @Transactional
    @Override
    public Integer batchInsert(String projectId, Company company, List<CompanyFinance> companyFinanceList) {
        if (CollectionUtils.isEmpty(companyFinanceList)) {
            throw new CommonException("数据不能为空", "base_canot_be_null", "操作失败，数据");
        }

        CompanyFinanceExample companyFinanceExample =new CompanyFinanceExample();
        companyFinanceExample.createCriteria().andProjectIdEqualTo(projectId)
                .andSupCompanyIdEqualTo(company.getId())
                .andIsEnableEqualTo(Constant.YES_INT);

        CompanyFinance companyFinance =new CompanyFinance();
        companyFinance.setIsEnable(Constant.NO_INT);

        this.companyFinanceMapper.updateByExampleSelective(companyFinance,companyFinanceExample);

        List<Integer> list = new ArrayList<Integer>();

        for (CompanyFinance finance : companyFinanceList) {
            finance.setId(null);
            finance.setProjectId(projectId);
            finance.setSupCompanyId(company.getId());
            finance.setIsEnable(Constant.YES_INT);
            finance.setCreateTime(new Date());
            finance.setUpdateTime(new Date());

            Integer finishFlag = finance.getFinishFlag();
            finance.setFinishFlag(finishFlag);
            this.companyFinanceMapper.insertSelective(finance);

            list.add(finishFlag);

        }

        if(list.contains(Constant.NO_INT)){
            return 0;
        }else{
            return 1;
        }

    }

    @CacheEvict(value={"companyFinance"}, allEntries=true)
    @Override
    public void addObj(CompanyFinance t) {
        this.companyFinanceMapper.insertSelective(t);
    }

    @CacheEvict(value={"companyFinance"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.companyFinanceMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"companyFinance"}, allEntries=true)
    @Override
    public void modifyObj(CompanyFinance t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.companyFinanceMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="companyFinance", keyGenerator="redisKeyGenerator")
    @Override
    public CompanyFinance queryObjById(String id) {
        return this.companyFinanceMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="companyFinance", keyGenerator="redisKeyGenerator")
    @Override
    public List<CompanyFinance> queryAllObjByExample(CompanyFinanceExample example) {
        return this.companyFinanceMapper.selectByExample(example);
    }

    @Cacheable(value="companyFinance", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<CompanyFinance> queryObjByPage(CompanyFinanceExample example) {
        PageView<CompanyFinance> pageView = example.getPageView();
        pageView.setQueryResult(this.companyFinanceMapper.selectByExampleByPage(example));
        return pageView;
    }
}