package com.els.base.certification.finance.web.controller;

import com.els.base.certification.common.CompanyFinishFlag;
import com.els.base.certification.finance.entity.CompanyFinance;
import com.els.base.certification.finance.entity.CompanyFinanceExample;
import com.els.base.certification.finance.service.CompanyFinanceService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Api(value="供应商准入-财务信息")
@Controller
@RequestMapping("companyFinance")
public class CompanyFinanceController {

    @Resource
    private CompanyFinanceService companyFinanceService;
    @Resource
    private CompanyService companyService;

    @ApiOperation(httpMethod = "POST", value = "批量创建财务信息")
    @RequestMapping("service/batchInsert")
    @ResponseBody
    public ResponseResult<CompanyFinishFlag> batchInsert(@RequestBody List<CompanyFinance>  companyFinanceList) {
        if (CollectionUtils.isEmpty(companyFinanceList)) {
            throw new CommonException("数据不能为空", "base_canot_be_null", "操作失败，数据");
        }
        Integer  financeStatus = this.companyFinanceService.batchInsert(ProjectUtils.getProjectId(), CompanyUtils.currentCompany(), companyFinanceList);
        CompanyFinishFlag companyFinishFlag =new CompanyFinishFlag();
        companyFinishFlag.setFinanceInfo(financeStatus);
        return ResponseResult.success(companyFinishFlag);
    }

   /* @ApiOperation(httpMethod="POST", value="创建财务信息")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody CompanyFinance companyFinance) {
        this.companyFinanceService.addObj(companyFinance);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑财务信息")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody CompanyFinance companyFinance) {
        if (StringUtils.isBlank(companyFinance.getId())) {
            throw new CommonException("id 为空，保存失败");
        }
        this.companyFinanceService.modifyObj(companyFinance);
        return ResponseResult.success();
    }*/

   /* @ApiOperation(httpMethod="POST", value="删除财务信息")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank(id)) {
            throw new CommonException("删除失败,id不能为空");
        }
        List<String> ids = new ArrayList<String>();
        ids.add(id);
        this.companyFinanceService.deleteObjByIds(ProjectUtils.getProjectId(), CompanyUtils.currentCompany(),ids);
        return ResponseResult.success();
    }*/


    @ApiOperation(httpMethod="POST", value="批量删除财务信息")
    @RequestMapping("service/deleteByIds")
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("删除失败,id不能为空");
        }
        this.companyFinanceService.deleteObjByIds(ProjectUtils.getProjectId(), CompanyUtils.currentCompany(),ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询财务信息")
    @ApiImplicitParams({
            @ApiImplicitParam( name = "supCompanySrmCode", required = false, value = "供应商SRM编码", paramType = "query", dataType = "String"),
         @ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),
         @ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),
         @ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 CompanyFinance", paramType = "body", dataType = "QueryParamWapper" )
    })
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<CompanyFinance>> findByPage(
            @RequestParam(required=false) String supCompanySrmCode,
         @RequestParam(defaultValue="0") int pageNo,
         @RequestParam(defaultValue="10") int pageSize,
         @RequestBody(required=false) QueryParamWapper wapper) {

        CompanyFinanceExample example = new CompanyFinanceExample();
        example.setPageView(new PageView<CompanyFinance>(pageNo, pageSize));
        CompanyFinanceExample.Criteria criteria = example.createCriteria();
        example.setOrderByClause("CREATE_TIME DESC");

        if(StringUtils.isBlank(supCompanySrmCode)){
            //添加查询条件
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId())
                    .andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId())
                    .andIsEnableEqualTo(Constant.YES_INT);
        }else{
            //否则则按照该编码进行查询
            Company company = companyService.queryCompanyByCode(supCompanySrmCode);
            if(company==null){
                throw new CommonException("公司不存在，请检查");
            }
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId())
                    .andSupCompanyIdEqualTo(company.getId())
                    .andIsEnableEqualTo(Constant.YES_INT);
        }

        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        
        PageView<CompanyFinance> pageData = this.companyFinanceService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }


    @ApiOperation(httpMethod="POST", value="查询全部财务信息")
    @ApiImplicitParams({
            @ApiImplicitParam( name = "supCompanySrmCode", required = false, value = "供应商SRM编码", paramType = "query", dataType = "String"),
            @ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 CompanyFinance", paramType = "body", dataType = "QueryParamWapper" )
    })
    @RequestMapping("service/findAll")
    @ResponseBody
    public ResponseResult<List<CompanyFinance>> findAll(
            @RequestParam(required=false) String supCompanySrmCode,
            @RequestBody(required=false) QueryParamWapper wapper) {

        CompanyFinanceExample example = new CompanyFinanceExample();
        CompanyFinanceExample.Criteria criteria = example.createCriteria();
        example.setOrderByClause("CREATE_TIME DESC");

        if(StringUtils.isBlank(supCompanySrmCode)){
            //添加查询条件
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId())
                    .andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId())
                    .andIsEnableEqualTo(Constant.YES_INT);
        }else{
            //否则则按照该编码进行查询
            Company company = companyService.queryCompanyByCode(supCompanySrmCode);
            if(company==null){
                throw new CommonException("公司不存在，请检查");
            }
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId())
                    .andSupCompanyIdEqualTo(company.getId())
                    .andIsEnableEqualTo(Constant.YES_INT);
        }

        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        List<CompanyFinance> companyFinanceList = this.companyFinanceService.queryAllObjByExample(example);
        return ResponseResult.success(companyFinanceList);
    }

}